/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.omegat.core.spellchecker.DictionaryManager;
import org.omegat.gui.dialogs.DictionaryInstallerDialog;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public class SpellcheckerConfigurationDialog
extends JDialog {
    private final JFileChooser fileChooser = new JFileChooser();
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private int returnStatus = 0;
    private Language currentLanguage;
    private DictionaryManager dicMan;
    private DefaultListModel languageListModel;
    private JCheckBox autoSpellcheckCheckBox;
    private JButton cancelButton;
    private JLabel contentLabel;
    private JPanel detailPanel;
    private JButton directoryChooserButton;
    private JLabel directoryLabel;
    private JTextField directoryTextField;
    private JButton installButton;
    private JPanel jPanel2;
    private JList languageList;
    private JScrollPane languageScrollPane;
    private JButton okButton;
    private JButton uninstallButton;

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }

    public SpellcheckerConfigurationDialog(Frame frame, Language language) {
        super(frame, true);
        this.initComponents();
        this.pack();
        this.currentLanguage = language;
        this.languageListModel = new DefaultListModel();
        this.autoSpellcheckCheckBox.setSelected(Preferences.isPreference("allow_auto_spellchecking"));
        this.updateDetailPanel();
        this.directoryTextField.setText(Preferences.getPreference("spellcheker_dir"));
        this.updateLanguageList();
    }

    private void updateLanguageList() {
        String string = this.directoryTextField.getText();
        if (string == null || string.equals("")) {
            return;
        }
        this.dicMan = new DictionaryManager(string);
        ArrayList arrayList = this.dicMan.getLocalDictionaryNameList();
        Collections.sort(arrayList);
        this.languageListModel.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.languageListModel.addElement(arrayList.get(i));
        }
        this.uninstallButton.setSelected(arrayList.size() > 0);
        this.languageList.setModel(this.languageListModel);
    }

    private void updateDetailPanel() {
        boolean bl = this.autoSpellcheckCheckBox.isSelected();
        this.detailPanel.setEnabled(bl);
        this.contentLabel.setEnabled(bl);
        this.directoryChooserButton.setEnabled(bl);
        this.directoryLabel.setEnabled(bl);
        this.directoryTextField.setEnabled(bl);
        this.installButton.setEnabled(bl);
        this.uninstallButton.setEnabled(bl);
        this.languageScrollPane.setEnabled(bl);
        this.languageList.setEnabled(bl);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.autoSpellcheckCheckBox = new JCheckBox();
        this.detailPanel = new JPanel();
        this.directoryTextField = new JTextField();
        this.languageScrollPane = new JScrollPane();
        this.languageList = new JList();
        this.contentLabel = new JLabel();
        this.directoryLabel = new JLabel();
        this.directoryChooserButton = new JButton();
        this.installButton = new JButton();
        this.uninstallButton = new JButton();
        this.setDefaultCloseOperation(2);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellcheckerConfigurationDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellcheckerConfigurationDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(342, Short.MAX_VALUE).add((Component)this.okButton).addPreferredGap(0).add((Component)this.cancelButton)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cancelButton).add((Component)this.okButton)));
        Mnemonics.setLocalizedText((AbstractButton)this.autoSpellcheckCheckBox, (String)OStrings.getString("GUI_SPELLCHECKER_AUTOSPELLCHECKCHECKBOX"));
        this.autoSpellcheckCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoSpellcheckCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.autoSpellcheckCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellcheckerConfigurationDialog.this.autoSpellcheckCheckBoxActionPerformed(actionEvent);
            }
        });
        this.detailPanel.setBorder(BorderFactory.createEtchedBorder());
        this.directoryTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellcheckerConfigurationDialog.this.directoryTextFieldActionPerformed(actionEvent);
            }
        });
        this.languageScrollPane.setViewportView(this.languageList);
        Mnemonics.setLocalizedText((JLabel)this.contentLabel, (String)OStrings.getString("GUI_SPELLCHECKER_AVAILABLE_LABEL"));
        Mnemonics.setLocalizedText((JLabel)this.directoryLabel, (String)OStrings.getString("GUI_SPELLCHECKER_DICTIONARYLABEL"));
        Mnemonics.setLocalizedText((AbstractButton)this.directoryChooserButton, (String)OStrings.getString("GUI_SPELLCHECKER_DIRECTORYCHOOSERBUTTON"));
        this.directoryChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellcheckerConfigurationDialog.this.directoryChooserButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.installButton, (String)OStrings.getString("GUI_SPELLCHECKER_INSTALLBUTTON"));
        this.installButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellcheckerConfigurationDialog.this.installButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.uninstallButton, (String)OStrings.getString("GUI_SPELLCHECKER_UNINSTALLBUTTON"));
        this.uninstallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellcheckerConfigurationDialog.this.uninstallButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.detailPanel);
        this.detailPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.contentLabel).add((Component)this.directoryLabel).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.languageScrollPane, -1, 343, Short.MAX_VALUE).add(2, (Component)this.directoryTextField, -1, 343, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2, false).add((Component)this.directoryChooserButton, -1, -1, Short.MAX_VALUE).add((Component)this.installButton, -1, -1, Short.MAX_VALUE).add((Component)this.uninstallButton, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.directoryLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.directoryChooserButton).add((Component)this.directoryTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.contentLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.installButton).addPreferredGap(0).add((Component)this.uninstallButton)).add((Component)this.languageScrollPane, -1, 123, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.autoSpellcheckCheckBox).add((Component)this.detailPanel, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.autoSpellcheckCheckBox).addPreferredGap(0).add((Component)this.detailPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void directoryTextFieldActionPerformed(ActionEvent actionEvent) {
        this.updateLanguageList();
    }

    private void directoryChooserButtonActionPerformed(ActionEvent actionEvent) {
        this.fileChooser.setFileSelectionMode(1);
        int n = this.fileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.directoryTextField.setText(file.getAbsolutePath());
        }
        this.updateLanguageList();
    }

    private void installButtonActionPerformed(ActionEvent actionEvent) {
        try {
            DictionaryInstallerDialog dictionaryInstallerDialog = new DictionaryInstallerDialog(this, this.dicMan);
            dictionaryInstallerDialog.setVisible(true);
            this.updateLanguageList();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException.toString(), "error", 0);
        }
    }

    private void uninstallButtonActionPerformed(ActionEvent actionEvent) {
        if (this.dicMan == null) {
            return;
        }
        if (this.currentLanguage != null) {
            String string = (String)this.languageListModel.getElementAt(this.languageList.getSelectedIndex());
            String string2 = string.substring(0, string.indexOf(" "));
            if (string2.equals(this.currentLanguage.getLocaleCode()) && JOptionPane.showConfirmDialog(this, OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_CURRENT"), OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_CURRENT_TITLE"), 0) == 1) {
                return;
            }
            if (!this.dicMan.uninstallDictionary(string2)) {
                JOptionPane.showMessageDialog(this, OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_UNABLE"), OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_UNABLE_TITLE"), 0);
            }
            this.languageListModel.remove(this.languageList.getSelectedIndex());
            this.uninstallButton.setEnabled(this.languageListModel.size() > 0);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(0);
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        Preferences.setPreference("allow_auto_spellchecking", this.autoSpellcheckCheckBox.isSelected());
        Preferences.setPreference("spellcheker_dir", this.directoryTextField.getText());
        this.doClose(1);
    }

    private void autoSpellcheckCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.updateDetailPanel();
    }
}

