/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.xhtml;

import java.net.URL;
import java.util.regex.Pattern;
import org.omegat.filters3.xml.DefaultXMLDialect;
import org.omegat.filters3.xml.xhtml.XHTMLOptions;
import org.xml.sax.InputSource;

public class XHTMLDialect
extends DefaultXMLDialect {
    private static final Pattern XHTML_PUBLIC_DTD = Pattern.compile("-//W3C//DTD XHTML.*");
    private static final Pattern PUBLIC_XHTML = Pattern.compile("-//W3C//DTD\\s+XHTML.+");
    private static final String DTD = "/org/omegat/filters3/xml/xhtml/res/xhtml2-flat.dtd";

    public XHTMLDialect() {
        this.defineConstraint(CONSTRAINT_PUBLIC_DOCTYPE, XHTML_PUBLIC_DTD);
    }

    public InputSource resolveEntity(String string, String string2) {
        if (string != null && PUBLIC_XHTML.matcher(string).matches() && string2.endsWith(".dtd")) {
            URL uRL = XHTMLDialect.class.getResource(DTD);
            return new InputSource(uRL.toExternalForm());
        }
        return null;
    }

    public void defineDialect(XHTMLOptions xHTMLOptions) {
        if (xHTMLOptions == null) {
            xHTMLOptions = new XHTMLOptions();
        }
        this.defineParagraphTags(new String[]{"html", "head", "title", "body", "address", "blockquote", "center", "div", "h1", "h2", "h3", "h4", "h5", "table", "th", "tr", "td", "p", "ol", "ul", "li", "dl", "dt", "dd", "form", "textarea", "fieldset", "legend", "label", "select", "option", "hr"});
        if (xHTMLOptions.getParagraphOnBr()) {
            this.defineParagraphTag("br");
        }
        this.defineShortcut("br", "br");
        this.definePreformatTags(new String[]{"textarea", "pre"});
        this.defineIntactTags(new String[]{"style", "script", "object", "embed"});
        this.defineTranslatableAttributes(new String[]{"abbr", "alt", "content", "summary", "title"});
        if (xHTMLOptions.getTranslateHref()) {
            this.defineTranslatableAttribute("href");
        }
        if (xHTMLOptions.getTranslateSrc()) {
            this.defineTranslatableTagAttribute("img", "src");
        }
        if (xHTMLOptions.getTranslateLang()) {
            this.defineTranslatableAttributes(new String[]{"lang", "xml:lang"});
        }
        if (xHTMLOptions.getTranslateHreflang()) {
            this.defineTranslatableAttribute("hreflang");
        }
        if (xHTMLOptions.getTranslateValue()) {
            this.defineTranslatableTagAttribute("input", "value");
        }
    }
}

