/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.Attribute;
import org.omegat.filters3.Element;
import org.omegat.filters3.Entry;
import org.omegat.filters3.Tag;
import org.omegat.filters3.xml.Comment;
import org.omegat.filters3.xml.DTD;
import org.omegat.filters3.xml.Entity;
import org.omegat.filters3.xml.Translator;
import org.omegat.filters3.xml.XMLDialect;
import org.omegat.filters3.xml.XMLEntityText;
import org.omegat.filters3.xml.XMLIntactTag;
import org.omegat.filters3.xml.XMLOutOfTurnTag;
import org.omegat.filters3.xml.XMLTag;
import org.omegat.filters3.xml.XMLText;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

class Handler
extends DefaultHandler
implements LexicalHandler,
DeclHandler {
    private SAXParser parser;
    private Translator translator;
    private XMLDialect dialect;
    private File inFile;
    private String inEncoding;
    private File outFile;
    private String outEncoding;
    private BufferedWriter mainWriter;
    private BufferedWriter extWriter = null;
    private Entity extEntity = null;
    Entry entry;
    Stack outofturnEntries = new Stack();
    Entry intacttagEntry = null;
    String intacttagName = null;
    private ArrayList externalEntities = new ArrayList();
    private Map internalEntities = new HashMap();
    private Entity internalEntityStarted = null;
    private boolean inCDATA = false;
    private DTD dtd = null;
    private boolean inDTD = false;
    private ArrayList processedFiles = new ArrayList();
    private static final String START_JARSCHEMA = "jar:";
    private static final String START_FILESCHEMA = "file:";
    private String sourceFolder = null;

    private BufferedWriter currWriter() {
        if (this.extWriter != null) {
            return this.extWriter;
        }
        return this.mainWriter;
    }

    private boolean collectingOutOfTurnText() {
        return !this.outofturnEntries.empty();
    }

    private boolean collectingIntactText() {
        return this.intacttagEntry != null;
    }

    private Entry currEntry() {
        if (this.collectingIntactText()) {
            return this.intacttagEntry;
        }
        if (this.collectingOutOfTurnText()) {
            return (Entry)this.outofturnEntries.peek();
        }
        return this.entry;
    }

    public ArrayList getProcessedFiles() {
        if (this.processedFiles.size() > 0) {
            return this.processedFiles;
        }
        return null;
    }

    private void reportFatalError(SAXParseException sAXParseException) throws SAXException {
        File file;
        int n = sAXParseException.getLineNumber();
        String string = sAXParseException.getSystemId() != null ? ((file = new File(this.inFile.getParentFile(), this.localizeSystemId(sAXParseException.getSystemId()))).exists() ? file.getAbsolutePath() : this.inFile.getAbsolutePath()) : this.inFile.getAbsolutePath();
        throw new SAXException("\n" + StaticUtils.format(sAXParseException.getMessage() + "\n" + OStrings.getString("XML_FATAL_ERROR"), new Object[]{string, new Integer(n)}));
    }

    public Handler(SAXParser sAXParser, Translator translator, XMLDialect xMLDialect, File file, String string, File file2, String string2) throws IOException {
        this.parser = sAXParser;
        this.translator = translator;
        this.dialect = xMLDialect;
        this.inFile = file;
        this.inEncoding = string;
        this.outFile = file2;
        this.outEncoding = string2;
        this.mainWriter = translator.createWriter(file2, string2);
    }

    private String getSourceFolder() {
        if (this.sourceFolder == null) {
            String string = this.inFile.getAbsoluteFile().getParent();
            try {
                string = this.inFile.getCanonicalFile().getParent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string.charAt(string.length() - 1) != File.separatorChar) {
                string = string + File.separatorChar;
            }
            this.sourceFolder = string;
        }
        return this.sourceFolder;
    }

    private String systemId2fileName(String string) {
        if (string.startsWith(START_FILESCHEMA)) {
            string = string.replace(File.separatorChar, '/');
            string = string.substring(START_FILESCHEMA.length());
            while (string.startsWith("/")) {
                string = string.substring(1);
            }
            string = string.charAt(0) >= 'A' && string.charAt(0) <= 'Z' && string.charAt(1) == ':' ? string.replace('/', File.separatorChar) : '/' + string;
        }
        return string;
    }

    private String localizeSystemId(String string) {
        if (string.startsWith(START_FILESCHEMA) && (string = this.systemId2fileName(string)).startsWith(this.getSourceFolder())) {
            string = string.substring(this.getSourceFolder().length());
        }
        return string;
    }

    private boolean isInSource(String string) {
        return string.startsWith(START_FILESCHEMA) && (string = this.systemId2fileName(string)).startsWith(this.getSourceFolder());
    }

    private Entity findExternalEntity(String string, String string2) {
        if (string == null && string2 == null) {
            return null;
        }
        for (int i = 0; i < this.externalEntities.size(); ++i) {
            Entity entity = (Entity)this.externalEntities.get(i);
            if (entity.isInternal() || !StaticUtils.equal(string, entity.getPublicId()) || !StaticUtils.equal(string2, entity.getSystemId())) continue;
            return entity;
        }
        return null;
    }

    private void doStartEntity(String string) {
        if (this.inDTD) {
            return;
        }
        this.internalEntityStarted = (Entity)this.internalEntities.get(string);
    }

    private void doEndEntity(String string) throws SAXException, TranslationException, IOException {
        if (this.inDTD || this.extEntity == null) {
            return;
        }
        if (this.extEntity.getName().equals(string)) {
            this.extEntity = null;
            this.translateAndFlush();
            this.extWriter.close();
            this.extWriter = null;
            this.mainWriter.write('&' + string + ';');
        }
    }

    public InputSource doResolve(String string, String string2) throws SAXException, TranslationException, IOException {
        if (this.dtd != null && StaticUtils.equal(string, this.dtd.getPublicId()) && (StaticUtils.equal(string2, this.dtd.getSystemId()) || StaticUtils.equal(this.localizeSystemId(string2), this.dtd.getSystemId()))) {
            this.inDTD = true;
        }
        if (string2 != null && (string2.startsWith(START_JARSCHEMA) || string2.startsWith(START_FILESCHEMA))) {
            InputSource inputSource = new InputSource(string2);
            if (string2.startsWith(START_FILESCHEMA) && !new File(this.systemId2fileName(string2)).exists()) {
                inputSource = null;
            }
            if (inputSource != null) {
                if (!this.inDTD && this.outFile != null && this.isInSource(string2) && this.extEntity == null) {
                    this.extEntity = this.findExternalEntity(string, this.localizeSystemId(string2));
                    if (this.extEntity != null) {
                        this.translateAndFlush();
                        File file = new File(this.outFile.getParentFile(), this.localizeSystemId(string2));
                        this.processedFiles.add(new File(this.inFile.getParent(), this.localizeSystemId(string2)));
                        this.extWriter = this.translator.createWriter(file, this.outEncoding);
                        this.extWriter.write("<?xml version=\"1.0\"?>\n");
                    }
                }
                return inputSource;
            }
            return new InputSource(new StringReader(new String()));
        }
        InputSource inputSource = this.dialect.resolveEntity(string, string2);
        if (inputSource != null) {
            return inputSource;
        }
        return new InputSource(new StringReader(new String()));
    }

    private void queueText(String string) {
        if (this.internalEntityStarted != null && string.equals(this.internalEntityStarted.getValue())) {
            this.currEntry().add(new XMLEntityText(this.internalEntityStarted));
        } else {
            XMLText xMLText;
            Element element;
            boolean bl = false;
            if (this.currEntry().size() > 0 && (element = this.currEntry().get(this.currEntry().size() - 1)) instanceof XMLText && (xMLText = (XMLText)element).isInCDATA() == this.inCDATA) {
                this.currEntry().remove(this.currEntry().size() - 1);
                this.currEntry().add(new XMLText(xMLText.getText() + string, this.inCDATA));
                bl = true;
            }
            if (!bl) {
                this.currEntry().add(new XMLText(string, this.inCDATA));
            }
        }
    }

    private void queueTag(String string, Attributes attributes) {
        Tag tag;
        XMLIntactTag xMLIntactTag = null;
        if (!this.collectingIntactText() && this.isIntactTag(string)) {
            xMLIntactTag = new XMLIntactTag(string, this.getShortcut(string), attributes);
            tag = xMLIntactTag;
            this.intacttagName = string;
        } else {
            tag = new XMLTag(string, this.getShortcut(string), 1, attributes);
        }
        this.currEntry().add(tag);
        if (xMLIntactTag != null) {
            this.intacttagEntry = xMLIntactTag.getIntactContents();
        }
        if (!this.collectingIntactText()) {
            for (int i = 0; i < tag.getAttributes().size(); ++i) {
                Attribute attribute = tag.getAttributes().get(i);
                if (!this.dialect.getTranslatableAttributes().contains(attribute.getName()) && !this.dialect.getTranslatableTagAttributes().containsPair(string, attribute.getName())) continue;
                attribute.setValue(this.translator.translate(attribute.getValue()));
            }
        }
    }

    private void queueEndTag(String string) {
        int n = this.currEntry().size();
        if (n > 0 && this.currEntry().get(n - 1) instanceof XMLTag && ((XMLTag)this.currEntry().get(n - 1)).getTag().equals(string) && ((XMLTag)this.currEntry().get(n - 1)).getType() == 1) {
            ((XMLTag)this.currEntry().get(n - 1)).setType(3);
        } else {
            this.currEntry().add(new XMLTag(string, this.getShortcut(string), 2, null));
        }
    }

    private void queueComment(String string) {
        this.currEntry().add(new Comment(string));
    }

    private void queueDTD(DTD dTD) {
        this.currEntry().add(dTD);
    }

    private void start(String string, Attributes attributes) throws SAXException, TranslationException {
        if (this.isOutOfTurnTag(string)) {
            XMLOutOfTurnTag xMLOutOfTurnTag = new XMLOutOfTurnTag(string, this.getShortcut(string), attributes);
            this.currEntry().add(xMLOutOfTurnTag);
            this.outofturnEntries.push(xMLOutOfTurnTag.getEntry());
        } else {
            if (this.isParagraphTag(string) && !this.collectingOutOfTurnText() && !this.collectingIntactText()) {
                this.translateAndFlush();
            }
            this.queueTag(string, attributes);
        }
    }

    private void end(String string) throws SAXException, TranslationException {
        if (this.collectingIntactText() && this.isIntactTag(string) && string.equals(this.intacttagName)) {
            this.intacttagEntry = null;
            this.intacttagName = null;
        } else if (this.collectingOutOfTurnText() && this.isOutOfTurnTag(string)) {
            this.translateButDontFlash();
            this.outofturnEntries.pop();
        } else {
            this.queueEndTag(string);
            if (this.isParagraphTag(string) && !this.collectingOutOfTurnText() && !this.collectingIntactText()) {
                this.translateAndFlush();
            }
        }
    }

    private void translateButDontFlash() throws TranslationException {
        String string;
        if (this.currEntry().size() == 0) {
            return;
        }
        String string2 = this.currEntry().sourceToShortcut();
        Element element = this.currEntry().get(0);
        if (element instanceof Tag && this.isPreformattingTag(((Tag)element).getTag())) {
            string = this.translator.translate(string2);
        } else {
            String string3 = StaticUtils.compressSpaces(string2);
            if (string3.equals(string = this.translator.translate(string3))) {
                string = string2;
            }
        }
        this.currEntry().setTranslation(string);
    }

    private void translateAndFlush() throws SAXException, TranslationException {
        this.translateButDontFlash();
        try {
            this.currWriter().write(this.currEntry().translationToOriginal());
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.currEntry().clear();
    }

    private boolean isParagraphTag(String string) {
        return this.dialect.getParagraphTags() != null && this.dialect.getParagraphTags().contains(string) || this.isPreformattingTag(string);
    }

    private boolean isPreformattingTag(String string) {
        return this.dialect.getPreformatTags() != null && this.dialect.getPreformatTags().contains(string);
    }

    private boolean isIntactTag(String string) {
        return this.dialect.getIntactTags() != null && this.dialect.getIntactTags().contains(string);
    }

    private boolean isOutOfTurnTag(String string) {
        return this.dialect.getOutOfTurnTags() != null && this.dialect.getOutOfTurnTags().contains(string);
    }

    private String getShortcut(String string) {
        if (this.dialect.getShortcuts() != null) {
            return (String)this.dialect.getShortcuts().get(string);
        }
        return null;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        try {
            return this.doResolve(string, string2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (TranslationException translationException) {
            throw new SAXException(translationException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this.start(string3, attributes);
        }
        catch (TranslationException translationException) {
            throw new SAXException(translationException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.end(string3);
        }
        catch (TranslationException translationException) {
            throw new SAXException(translationException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.queueText(new String(cArray, n, n2));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.queueText(new String(cArray, n, n2));
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.queueComment(new String(cArray, n, n2));
    }

    public void startDocument() throws SAXException {
        try {
            this.mainWriter.write("<?xml version=\"1.0\"?>\n");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.entry = new Entry();
    }

    public void endDocument() throws SAXException {
        try {
            this.translateAndFlush();
            if (this.extWriter != null) {
                this.extWriter.close();
                this.extWriter = null;
            }
            this.translateAndFlush();
            this.currWriter().close();
        }
        catch (TranslationException translationException) {
            throw new SAXException(translationException);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.reportFatalError(sAXParseException);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.dtd = new DTD(string, string2, string3);
    }

    public void endDTD() throws SAXException {
        this.queueDTD(this.dtd);
        this.inDTD = false;
        this.dtd = null;
    }

    public void startCDATA() throws SAXException {
        this.inCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.inCDATA = false;
    }

    public void startEntity(String string) throws SAXException {
        this.doStartEntity(string);
    }

    public void endEntity(String string) throws SAXException {
        try {
            this.doEndEntity(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (TranslationException translationException) {
            throw new SAXException(translationException);
        }
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (this.inDTD) {
            return;
        }
        Entity entity = new Entity(string, string2);
        this.internalEntities.put(string, entity);
        this.dtd.addEntity(entity);
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (this.inDTD) {
            return;
        }
        Entity entity = new Entity(string, string2, this.localizeSystemId(string3));
        if (this.isInSource(string3)) {
            this.externalEntities.add(entity);
        }
        this.dtd.addEntity(entity);
    }

    public void elementDecl(String string, String string2) {
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
    }
}

