/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.swing.JFileChooser;
import org.omegat.filters2.TranslationException;
import org.omegat.gui.dialogs.ProjectPropertiesDialog;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.gui.OpenProjectFileChooser;

public class ProjectProperties {
    private String projectName;
    private String projectFile;
    private String projectRoot;
    private String projectInternal;
    private String sourceRoot;
    private String targetRoot;
    private String glossaryRoot;
    private String tmRoot;
    private Language sourceLanguage;
    private Language targetLanguage;
    private boolean sentenceSegmentingOn;
    private boolean dontInsertSource;
    private boolean insertBestMatch;
    private int minimalSimilarity;

    public ProjectProperties() {
        this.reset();
    }

    public String getTargetRoot() {
        return this.targetRoot;
    }

    public void setTargetRoot(String string) {
        this.targetRoot = string;
    }

    public String getGlossaryRoot() {
        return this.glossaryRoot;
    }

    public void setGlossaryRoot(String string) {
        this.glossaryRoot = string;
    }

    public String getTMRoot() {
        return this.tmRoot;
    }

    public void setTMRoot(String string) {
        this.tmRoot = string;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public String getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(String string) {
        this.projectFile = string;
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    public void setProjectRoot(String string) {
        this.projectRoot = string;
    }

    public String getProjectInternal() {
        return this.projectInternal;
    }

    public void setProjectInternal(String string) {
        this.projectInternal = string;
    }

    public String getSourceRoot() {
        return this.sourceRoot;
    }

    public void setSourceRoot(String string) {
        this.sourceRoot = string;
    }

    public Language getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(Language language) {
        this.sourceLanguage = language;
    }

    public void setSourceLanguage(String string) {
        this.sourceLanguage = new Language(string);
    }

    public Language getTargetLanguage() {
        return this.targetLanguage;
    }

    public void setTargetLanguage(Language language) {
        this.targetLanguage = language;
    }

    public void setTargetLanguage(String string) {
        this.targetLanguage = new Language(string);
    }

    public boolean isSentenceSegmentingEnabled() {
        return this.sentenceSegmentingOn;
    }

    public void setSentenceSegmentingEnabled(boolean bl) {
        this.sentenceSegmentingOn = bl;
    }

    public void reset() {
        this.setProjectFile("");
        this.setProjectName("");
        this.setProjectRoot("");
        this.setProjectInternal("");
        this.setSourceRoot("");
        this.setTargetRoot("");
        this.setGlossaryRoot("");
        this.setTMRoot("");
        this.setSourceLanguage("EN-US");
        this.setTargetLanguage("EN-GB");
        this.setSentenceSegmentingEnabled(true);
    }

    public boolean loadExisting(Frame frame, String string) throws IOException, InterruptedIOException {
        Object object;
        this.reset();
        File file = null;
        try {
            file = new File(string);
            if (!file.exists()) {
                file = null;
            }
        }
        catch (Exception exception) {
            file = null;
        }
        if (file == null) {
            object = new OpenProjectFileChooser();
            if (0 != ((JFileChooser)object).showOpenDialog(null)) {
                return false;
            }
            file = ((JFileChooser)object).getSelectedFile();
        }
        string = file.getAbsolutePath() + File.separator;
        Preferences.setPreference("current_folder", file.getParent());
        try {
            object = new ProjectFileStorage();
            this.setProjectName(file.getName());
            this.setProjectRoot(string);
            ((ProjectFileStorage)object).loadProjectFile(this.getProjectRoot() + "omegat.project");
            this.setSourceRoot(((ProjectFileStorage)object).getSource());
            this.setTargetRoot(((ProjectFileStorage)object).getTarget());
            this.setGlossaryRoot(((ProjectFileStorage)object).getGlossary());
            this.setTMRoot(((ProjectFileStorage)object).getTM());
            this.setProjectInternal(this.getProjectRoot() + "omegat" + File.separator);
            this.setSourceLanguage(((ProjectFileStorage)object).getSourceLang());
            this.setTargetLanguage(((ProjectFileStorage)object).getTargetLang());
            Preferences.setPreference("source_lang", this.getSourceLanguage().toString());
            Preferences.setPreference("target_lang", this.getTargetLanguage().toString());
            this.setProjectFile(this.getProjectRoot() + "omegat.project");
            this.setSentenceSegmentingEnabled(((ProjectFileStorage)object).getSentenceSeg() != null && ((ProjectFileStorage)object).getSentenceSeg().equals("true"));
            if (!this.verifyProject()) {
                boolean bl;
                ProjectPropertiesDialog projectPropertiesDialog;
                block10: {
                    projectPropertiesDialog = new ProjectPropertiesDialog(frame, this, this.getProjectFile(), 2);
                    bl = false;
                    do {
                        projectPropertiesDialog.setVisible(true);
                        if (!projectPropertiesDialog.dialogCancelled()) continue;
                        bl = true;
                        break block10;
                    } while (!this.verifyProject());
                    this.buildProjFile();
                }
                projectPropertiesDialog.dispose();
                if (bl) {
                    this.reset();
                    return false;
                }
            }
            return true;
        }
        catch (TranslationException translationException) {
            this.reset();
            Log.log(translationException);
            throw new IOException(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
        }
    }

    private boolean verifyProject() {
        File file = new File(this.getSourceRoot());
        File file2 = new File(this.getTargetRoot());
        File file3 = new File(this.getGlossaryRoot());
        File file4 = new File(this.getTMRoot());
        return file.exists() && file2.exists() && file3.exists() && file4.exists();
    }

    public static boolean verifySingleLangCode(String string) {
        return string.length() == 2 ? Character.isLetter(string.charAt(0)) && Character.isLetter(string.charAt(1)) && new Language(string).getDisplayName().length() > 0 : string.length() == 5 && Character.isLetter(string.charAt(0)) && Character.isLetter(string.charAt(1)) && Character.isLetter(string.charAt(3)) && Character.isLetter(string.charAt(4)) && (string.charAt(2) == '-' || string.charAt(2) == '_') && new Language(string).getDisplayName().length() > 0;
    }

    public boolean createNew(Frame frame) {
        ProjectPropertiesDialog projectPropertiesDialog = new ProjectPropertiesDialog(frame, this, null, 1);
        if (!projectPropertiesDialog.dialogCancelled()) {
            projectPropertiesDialog.setVisible(true);
            if (!projectPropertiesDialog.dialogCancelled()) {
                return true;
            }
        }
        return false;
    }

    public void buildProjFile() throws IOException {
        ProjectFileStorage projectFileStorage = new ProjectFileStorage();
        projectFileStorage.setTarget(this.getTargetRoot());
        projectFileStorage.setSource(this.getSourceRoot());
        projectFileStorage.setTM(this.getTMRoot());
        projectFileStorage.setGlossary(this.getGlossaryRoot());
        projectFileStorage.setSourceLang(this.getSourceLanguage().toString());
        projectFileStorage.setTargetLang(this.getTargetLanguage().toString());
        projectFileStorage.setSentenceSeg(this.isSentenceSegmentingEnabled() ? "true" : "false");
        projectFileStorage.writeProjectFile(this.getProjectFile());
    }

    public boolean editProject(Frame frame) throws IOException {
        boolean bl;
        ProjectPropertiesDialog projectPropertiesDialog;
        ProjectProperties projectProperties;
        block2: {
            projectProperties = this.createBackup();
            projectPropertiesDialog = new ProjectPropertiesDialog(frame, this, this.getProjectFile(), 3);
            bl = false;
            do {
                projectPropertiesDialog.setVisible(true);
                if (!projectPropertiesDialog.dialogCancelled()) continue;
                bl = true;
                break block2;
            } while (!this.verifyProject());
            this.buildProjFile();
        }
        projectPropertiesDialog.dispose();
        if (bl) {
            this.restoreBackup(projectProperties);
            return false;
        }
        return true;
    }

    private ProjectProperties createBackup() {
        try {
            return (ProjectProperties)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void restoreBackup(ProjectProperties projectProperties) {
        if (projectProperties != null) {
            this.setProjectName(projectProperties.projectName);
            this.setProjectFile(projectProperties.projectFile);
            this.setProjectRoot(projectProperties.projectRoot);
            this.setProjectInternal(projectProperties.projectInternal);
            this.setSourceRoot(projectProperties.sourceRoot);
            this.setTargetRoot(projectProperties.targetRoot);
            this.setGlossaryRoot(projectProperties.glossaryRoot);
            this.setTMRoot(projectProperties.tmRoot);
            this.setSourceLanguage(projectProperties.sourceLanguage);
            this.setTargetLanguage(projectProperties.targetLanguage);
            Preferences.setPreference("source_lang", this.getSourceLanguage().toString());
            Preferences.setPreference("target_lang", this.getTargetLanguage().toString());
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        ProjectProperties projectProperties = (ProjectProperties)super.clone();
        projectProperties.sourceLanguage = new Language(this.sourceLanguage.getLocaleCode());
        projectProperties.targetLanguage = new Language(this.targetLanguage.getLocaleCode());
        return projectProperties;
    }
}

