/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Pointer {
    public static final int SIZE = Native.POINTER_SIZE;
    public static final Pointer NULL;
    public static final Pointer PM1;
    long peer;

    Pointer() {
    }

    Pointer(long peer) {
        this.peer = peer;
    }

    Pointer share(int offset, int sz) {
        return new Pointer(this.peer + (long)offset);
    }

    void clear(int size) {
        byte[] buffer = new byte[size];
        this.write(0, buffer, 0, size);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return this.peer == 0L;
        }
        return o instanceof Pointer && ((Pointer)o).peer == this.peer;
    }

    public int hashCode() {
        return (int)((this.peer >>> 32) + (this.peer & 0xFFFFFFFFFFFFFFFFL));
    }

    public boolean isValid() {
        return this.peer != 0L;
    }

    public native int indexOf(int var1, byte var2);

    public native void read(int var1, byte[] var2, int var3, int var4);

    public native void read(int var1, short[] var2, int var3, int var4);

    public native void read(int var1, char[] var2, int var3, int var4);

    public native void read(int var1, int[] var2, int var3, int var4);

    public native void read(int var1, long[] var2, int var3, int var4);

    public native void read(int var1, float[] var2, int var3, int var4);

    public native void read(int var1, double[] var2, int var3, int var4);

    public native void write(int var1, byte[] var2, int var3, int var4);

    public native void write(int var1, short[] var2, int var3, int var4);

    public native void write(int var1, char[] var2, int var3, int var4);

    public native void write(int var1, int[] var2, int var3, int var4);

    public native void write(int var1, long[] var2, int var3, int var4);

    public native void write(int var1, float[] var2, int var3, int var4);

    public native void write(int var1, double[] var2, int var3, int var4);

    public void write(int bOff, Pointer[] buf, int index, int length) {
        for (int i = 0; i < length; ++i) {
            this.setPointer(bOff + i * SIZE, buf[index + i]);
        }
    }

    public native byte getByte(int var1);

    public native char getChar(int var1);

    public native short getShort(int var1);

    public native int getInt(int var1);

    public native long getLong(int var1);

    public NativeLong getNativeLong(int offset) {
        return new NativeLong(NativeLong.SIZE == 8 ? this.getLong(offset) : (long)this.getInt(offset));
    }

    public native float getFloat(int var1);

    public native double getDouble(int var1);

    public native Pointer getPointer(int var1);

    public ByteBuffer getByteBuffer(int offset, int length) {
        return this.getDirectByteBuffer(offset, length).order(ByteOrder.nativeOrder());
    }

    private native ByteBuffer getDirectByteBuffer(int var1, int var2);

    public native String getString(int var1, boolean var2);

    public String getString(int offset) {
        int len;
        String encoding = System.getProperty("jna.encoding");
        if (encoding != null && (len = this.indexOf(offset, (byte)0)) != -1) {
            byte[] data = this.getByteArray(offset, len);
            try {
                return new String(data, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return this.getString(offset, false);
    }

    public byte[] getByteArray(int offset, int arraySize) {
        byte[] buf = new byte[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public char[] getCharArray(int offset, int arraySize) {
        char[] buf = new char[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public short[] getShortArray(int offset, int arraySize) {
        short[] buf = new short[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public int[] getIntArray(int offset, int arraySize) {
        int[] buf = new int[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public long[] getLongArray(int offset, int arraySize) {
        long[] buf = new long[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public float[] getFloatArray(int offset, int arraySize) {
        float[] buf = new float[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public double[] getDoubleArray(int offset, int arraySize) {
        double[] buf = new double[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public Pointer[] getPointerArray(int offset, int arraySize) {
        Pointer[] buf = new Pointer[arraySize];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = this.getPointer(offset + i * SIZE);
        }
        return buf;
    }

    public native void setByte(int var1, byte var2);

    public native void setShort(int var1, short var2);

    public native void setChar(int var1, char var2);

    public native void setInt(int var1, int var2);

    public native void setLong(int var1, long var2);

    public void setNativeLong(int offset, NativeLong value) {
        if (NativeLong.SIZE == 8) {
            this.setLong(offset, value.longValue());
        } else {
            this.setInt(offset, value.intValue());
        }
    }

    public native void setFloat(int var1, float var2);

    public native void setDouble(int var1, double var2);

    public native void setPointer(int var1, Pointer var2);

    public native void setString(int var1, String var2, boolean var3);

    public void setString(int offset, String value) {
        byte[] data = Native.getBytes(value);
        this.write(offset, data, 0, data.length);
        this.setByte(offset + data.length, (byte)0);
    }

    public String toString() {
        return "native@0x" + Long.toHexString(this.peer);
    }

    static {
        if (SIZE == 0) {
            throw new Error("Native library not initialized");
        }
        NULL = null;
        PM1 = new Pointer(-1L);
    }
}

