/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.toolbars;

import com.vlsolutions.swing.toolbars.ToolBarConstraints;
import com.vlsolutions.swing.toolbars.ToolBarPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;

public class ToolBarPanelLayout
implements LayoutManager2 {
    private ToolBarPanel panel;
    private ArrayList componentInfos = new ArrayList();
    private int gap = 3;

    public ToolBarPanelLayout(ToolBarPanel panel) {
        this.panel = panel;
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            throw new NullPointerException();
        }
        ToolBarConstraints tc = (ToolBarConstraints)constraints;
        this.componentInfos.add(new ComponentInfo(comp, tc));
        this.reorderComponents();
    }

    public ToolBarConstraints getConstraints(Component comp) {
        for (int i = 0; i < this.componentInfos.size(); ++i) {
            ComponentInfo ci = (ComponentInfo)this.componentInfos.get(i);
            if (ci.comp != comp) continue;
            return ci.constraints;
        }
        return null;
    }

    public void removeLayoutComponent(Component comp) {
        for (int i = 0; i < this.componentInfos.size(); ++i) {
            ComponentInfo ci = (ComponentInfo)this.componentInfos.get(i);
            if (ci.comp != comp) continue;
            this.componentInfos.remove(i);
            return;
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container parent) {
        ToolBarPanel panel = (ToolBarPanel)parent;
        boolean isHorizontal = panel.getOrientation() == 0;
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            boolean visible = false;
            int majorCount = this.getMajorCount();
            for (int i = 0; i < majorCount; ++i) {
                Dimension minorDim = new Dimension(0, 0);
                ArrayList minorList = this.getMinorComponents(i);
                for (int j = 0; j < minorList.size(); ++j) {
                    ComponentInfo ci = (ComponentInfo)minorList.get(j);
                    Dimension d = ci.comp.getPreferredSize();
                    if (!ci.comp.isVisible()) continue;
                    if (isHorizontal) {
                        minorDim.width += d.width;
                        minorDim.height = Math.max(minorDim.height, d.height);
                        if (j <= 0) continue;
                        minorDim.width += this.gap;
                        continue;
                    }
                    minorDim.width = Math.max(minorDim.width, d.width);
                    minorDim.height += d.height;
                    if (j <= 0) continue;
                    minorDim.height += this.gap;
                }
                if (isHorizontal) {
                    dim.width = Math.max(dim.width, minorDim.width);
                    dim.height += minorDim.height;
                    continue;
                }
                dim.width += minorDim.width;
                dim.height = Math.max(dim.height, minorDim.height);
            }
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    public Component[] getComponents() {
        Component[] comps = new Component[this.componentInfos.size()];
        for (int i = 0; i < this.componentInfos.size(); ++i) {
            ComponentInfo ci = (ComponentInfo)this.componentInfos.get(i);
            comps[i] = ci.comp;
        }
        return comps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        ToolBarPanel panel = (ToolBarPanel)target;
        boolean isHorizontal = panel.getOrientation() == 0;
        Object object = target.getTreeLock();
        synchronized (object) {
            Collections.sort(this.componentInfos);
            Insets insets = target.getInsets();
            if (isHorizontal) {
                int top = insets.top;
                int majorCount = this.getMajorCount();
                for (int i = 0; i < majorCount; ++i) {
                    int left = insets.left;
                    int maxHeight = 0;
                    ArrayList minorList = this.getMinorComponents(i);
                    for (int j = 0; j < minorList.size(); ++j) {
                        ComponentInfo ci = (ComponentInfo)minorList.get(j);
                        Component comp = ci.comp;
                        if (!comp.isVisible()) continue;
                        Dimension d = comp.getPreferredSize();
                        comp.setBounds(left, top, d.width, d.height);
                        left += d.width + this.gap;
                        maxHeight = Math.max(maxHeight, d.height);
                    }
                    top += maxHeight;
                }
            } else {
                int majorCount = this.getMajorCount();
                int left = insets.left;
                for (int i = 0; i < majorCount; ++i) {
                    int top = insets.top;
                    int maxWidth = 0;
                    ArrayList minorList = this.getMinorComponents(i);
                    for (int j = 0; j < minorList.size(); ++j) {
                        ComponentInfo ci = (ComponentInfo)minorList.get(j);
                        Component comp = ci.comp;
                        if (!comp.isVisible()) continue;
                        Dimension d = comp.getPreferredSize();
                        comp.setBounds(left, top, d.width, d.height);
                        top += d.height + this.gap;
                        maxWidth = Math.max(maxWidth, d.width);
                    }
                    left += maxWidth;
                }
            }
        }
    }

    private void reorderComponents() {
        ComponentInfo next;
        int j;
        ComponentInfo ci;
        int i;
        Collections.sort(this.componentInfos);
        for (i = 0; i < this.componentInfos.size(); ++i) {
            ci = (ComponentInfo)this.componentInfos.get(i);
            if (ci.constraints.majorOffset < 0) {
                ci.constraints.majorOffset = 0;
                for (j = i + 1; j < this.componentInfos.size(); ++j) {
                    next = (ComponentInfo)this.componentInfos.get(j);
                    ++next.constraints.majorOrder;
                }
                continue;
            }
            if (ci.constraints.majorOffset <= 0) continue;
            ci.constraints.majorOffset = 0;
            for (j = i; j < this.componentInfos.size(); ++j) {
                next = (ComponentInfo)this.componentInfos.get(j);
                ++next.constraints.majorOrder;
            }
        }
        for (i = 0; i < this.componentInfos.size(); ++i) {
            ci = (ComponentInfo)this.componentInfos.get(i);
            if (ci.constraints.minorOffset < 0) {
                ci.constraints.minorOffset = 0;
                for (j = i + 1; j < this.componentInfos.size(); ++j) {
                    next = (ComponentInfo)this.componentInfos.get(j);
                    if (next.constraints.majorOrder != ci.constraints.majorOrder) continue;
                    ++next.constraints.minorOrder;
                }
                continue;
            }
            if (ci.constraints.minorOffset <= 0) continue;
            ci.constraints.minorOffset = 0;
            for (j = i; j < this.componentInfos.size(); ++j) {
                next = (ComponentInfo)this.componentInfos.get(j);
                if (next.constraints.majorOrder != ci.constraints.majorOrder) continue;
                ++next.constraints.minorOrder;
            }
        }
        int order = 0;
        int minorOrder = 0;
        int lastMajorOrder = -1;
        int lastMinorOrder = -1;
        for (int i2 = 0; i2 < this.componentInfos.size(); ++i2) {
            ComponentInfo ci2 = (ComponentInfo)this.componentInfos.get(i2);
            if (lastMajorOrder == -1) {
                lastMajorOrder = ci2.constraints.majorOrder;
                lastMinorOrder = ci2.constraints.minorOrder;
            }
            if (ci2.constraints.majorOrder == lastMajorOrder) {
                ci2.constraints.majorOrder = order;
                if (ci2.constraints.minorOrder == lastMinorOrder) {
                    ci2.constraints.minorOrder = minorOrder;
                    continue;
                }
                lastMinorOrder = ci2.constraints.minorOrder;
                ci2.constraints.minorOrder = ++minorOrder;
                continue;
            }
            minorOrder = 0;
            lastMajorOrder = ci2.constraints.majorOrder;
            lastMinorOrder = ci2.constraints.minorOrder;
            ci2.constraints.majorOrder = ++order;
            ci2.constraints.minorOrder = minorOrder;
        }
    }

    private ToolBarConstraints getHorizontalInsertionContraintsAt(Component draggedComponent, Point p) {
        ToolBarConstraints tc = new ToolBarConstraints();
        int majorCount = this.getMajorCount();
        for (int i = 0; i < majorCount; ++i) {
            ArrayList minorList;
            Rectangle bounds = this.getMinorBounds(i);
            if (p.y < bounds.y) {
                tc.majorOrder = i;
                tc.minorOrder = 0;
                tc.majorOffset = -1;
                return tc;
            }
            if (p.y < bounds.y + 5) {
                tc.majorOrder = i;
                tc.minorOrder = 0;
                tc.majorOffset = -1;
                return tc;
            }
            if (p.y > bounds.y + bounds.height) continue;
            if (p.y > bounds.y + bounds.height - 5) {
                tc.majorOrder = i;
                tc.minorOrder = 0;
                tc.majorOffset = 1;
                return tc;
            }
            if (p.x < bounds.x + bounds.width) {
                minorList = this.getMinorComponents(i);
                for (int j = 0; j < minorList.size(); ++j) {
                    ComponentInfo ci = (ComponentInfo)minorList.get(j);
                    Component comp = ci.comp;
                    if (!comp.isVisible() || p.x >= comp.getX() + comp.getWidth()) continue;
                    if (comp == draggedComponent) {
                        return null;
                    }
                    if (p.x < comp.getX() + 10) {
                        tc.majorOrder = i;
                        tc.minorOrder = j;
                        tc.minorOffset = -1;
                        return tc;
                    }
                    if (j < minorList.size() - 1) {
                        ComponentInfo next = (ComponentInfo)minorList.get(j + 1);
                        if (next.comp == draggedComponent) {
                            return null;
                        }
                    }
                    tc.majorOrder = i;
                    tc.minorOrder = j;
                    tc.minorOffset = 1;
                    return tc;
                }
                continue;
            }
            minorList = this.getMinorComponents(i);
            tc.majorOrder = i;
            tc.minorOrder = minorList.size();
            return tc;
        }
        tc.majorOrder = majorCount;
        tc.minorOrder = 0;
        return tc;
    }

    private ToolBarConstraints getVerticalInsertionContraintsAt(Component draggedComponent, Point p) {
        ToolBarConstraints tc = new ToolBarConstraints();
        int majorCount = this.getMajorCount();
        for (int i = 0; i < majorCount; ++i) {
            ArrayList minorList;
            Rectangle bounds = this.getMinorBounds(i);
            if (p.x < bounds.x) {
                tc.majorOrder = i;
                tc.minorOrder = 0;
                tc.majorOffset = -1;
                return tc;
            }
            if (p.x < bounds.x + 3) {
                tc.majorOrder = i;
                tc.minorOrder = 0;
                tc.majorOffset = -1;
                return tc;
            }
            if (p.x > bounds.x + bounds.width) continue;
            if (p.x > bounds.x + bounds.width - 3) {
                tc.majorOrder = i;
                tc.minorOrder = 0;
                tc.majorOffset = 1;
                return tc;
            }
            if (p.y < bounds.y + bounds.height) {
                minorList = this.getMinorComponents(i);
                for (int j = 0; j < minorList.size(); ++j) {
                    ComponentInfo ci = (ComponentInfo)minorList.get(j);
                    Component comp = ci.comp;
                    if (!comp.isVisible() || p.y >= comp.getY() + comp.getHeight()) continue;
                    if (comp == draggedComponent) {
                        return null;
                    }
                    if (p.y < comp.getY() + 10) {
                        tc.majorOrder = i;
                        tc.minorOrder = j;
                        tc.minorOffset = -1;
                        return tc;
                    }
                    if (j < minorList.size() - 1) {
                        ComponentInfo next = (ComponentInfo)minorList.get(j + 1);
                        if (next.comp == draggedComponent) {
                            return null;
                        }
                    }
                    tc.majorOrder = i;
                    tc.minorOrder = j;
                    tc.minorOffset = 1;
                    return tc;
                }
                continue;
            }
            minorList = this.getMinorComponents(i);
            tc.majorOrder = i;
            tc.minorOrder = minorList.size();
            return tc;
        }
        tc.majorOrder = majorCount;
        tc.minorOrder = 0;
        return tc;
    }

    public ToolBarConstraints getInsertionContraintsAt(Component draggedComponent, Point p) {
        boolean isHorizontal;
        boolean bl = isHorizontal = this.panel.getOrientation() == 0;
        if (isHorizontal) {
            return this.getHorizontalInsertionContraintsAt(draggedComponent, p);
        }
        return this.getVerticalInsertionContraintsAt(draggedComponent, p);
    }

    private int getMajorCount() {
        int max = 0;
        for (int i = 0; i < this.componentInfos.size(); ++i) {
            ComponentInfo ci = (ComponentInfo)this.componentInfos.get(i);
            ToolBarConstraints tc = ci.constraints;
            if (tc.majorOrder <= max) continue;
            max = tc.majorOrder;
        }
        return max + 1;
    }

    private Rectangle getMinorBounds(int majorOrder) {
        Rectangle r = new Rectangle();
        Rectangle temp = null;
        for (int i = 0; i < this.componentInfos.size(); ++i) {
            ComponentInfo ci = (ComponentInfo)this.componentInfos.get(i);
            if (ci.constraints.majorOrder != majorOrder) continue;
            temp = ci.comp.getBounds(temp);
            r = r.union(temp);
        }
        return r;
    }

    private ArrayList getMinorComponents(int majorOrder) {
        ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>();
        for (int i = 0; i < this.componentInfos.size(); ++i) {
            ComponentInfo ci = (ComponentInfo)this.componentInfos.get(i);
            if (ci.constraints.majorOrder != majorOrder) continue;
            list.add(ci);
        }
        return list;
    }

    private class ComponentInfo
    implements Comparable {
        Component comp;
        ToolBarConstraints constraints;

        ComponentInfo(Component comp, ToolBarConstraints constraints) {
            this.comp = comp;
            this.constraints = constraints;
        }

        private int getCompareOrder() {
            int order = this.constraints.majorOrder * 100000 + this.constraints.majorOffset * 10000 + this.constraints.minorOrder * 100 + this.constraints.minorOffset;
            return order;
        }

        public int compareTo(Object obj) {
            ComponentInfo ci = (ComponentInfo)obj;
            return this.getCompareOrder() - ci.getCompareOrder();
        }
    }
}

