/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableContainerFactory;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.SingleDockableContainer;
import com.vlsolutions.swing.docking.SplitContainer;
import com.vlsolutions.swing.docking.SplitResizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

class RelativeDockingUtilities {
    private RelativeDockingUtilities() {
    }

    private static SplitContainer findBestContainer(Container dockingPanel, RelativeDockablePosition position) {
        Component centerComp;
        Component splitComp;
        int x = (int)(position.getX() * (double)dockingPanel.getWidth());
        int y = (int)(position.getY() * (double)dockingPanel.getHeight());
        int w = (int)(position.getWidth() * (double)dockingPanel.getWidth());
        int h = (int)(position.getHeight() * (double)dockingPanel.getHeight());
        int centerX = x + w / 2;
        int centerY = y + h / 2;
        for (splitComp = centerComp = dockingPanel.findComponentAt(centerX, centerY); splitComp != null && !(splitComp instanceof SplitContainer); splitComp = splitComp.getParent()) {
        }
        if (splitComp instanceof SplitContainer) {
            boolean anchoredTop = y < 5;
            boolean anchoredLeft = x < 5;
            boolean anchoredBottom = Math.abs(y + h - dockingPanel.getHeight()) < 5;
            boolean anchoredRight = Math.abs(x + w - dockingPanel.getWidth()) < 5;
            return RelativeDockingUtilities.findBetterContainer((SplitContainer)splitComp, dockingPanel, anchoredTop, anchoredLeft, anchoredBottom, anchoredRight);
        }
        return null;
    }

    private static SplitContainer findBetterContainer(SplitContainer split, Container dockingPanel, boolean anchoredTop, boolean anchoredLeft, boolean anchoredBottom, boolean anchoredRight) {
        boolean[] globalAnchors = new boolean[]{anchoredTop, anchoredLeft, anchoredBottom, anchoredRight};
        int globalCount = 0;
        for (int i = 0; i < 4; ++i) {
            if (!globalAnchors[i]) continue;
            ++globalCount;
        }
        SplitContainer betterSplit = split;
        while (true) {
            boolean[] splitAnchors = RelativeDockingUtilities.findAnchors(split, dockingPanel);
            int count = 0;
            for (int i = 0; i < 4; ++i) {
                if (!globalAnchors[i] || !splitAnchors[i]) continue;
                ++count;
            }
            if (count >= globalCount) {
                return split;
            }
            if (!(split.getParent() instanceof SplitContainer)) break;
            split = (SplitContainer)split.getParent();
        }
        return split;
    }

    private static boolean[] findAnchors(Component comp, Container container) {
        Rectangle r = SwingUtilities.convertRectangle(comp, new Rectangle(0, 0, comp.getWidth(), comp.getHeight()), container);
        int x = container.getX();
        int y = container.getY();
        int w = container.getWidth();
        int h = container.getHeight();
        boolean[] anchors = new boolean[]{Math.abs(y - r.y) < 5, Math.abs(x - r.x) < 5, Math.abs(y + h - r.y - r.height) < 30, Math.abs(x + w - r.x - r.width) < 5};
        return anchors;
    }

    private static void hSplitAndResize(Component base, Component left, Component right, double proportion) {
        Container parent = base.getParent();
        SplitContainer newSplit = new SplitContainer(1);
        DockingUtilities.replaceChild(parent, base, newSplit);
        newSplit.setLeftComponent(left);
        newSplit.setRightComponent(right);
        SwingUtilities.invokeLater(new SplitResizer(newSplit, proportion));
    }

    private static void vSplitAndResize(Component base, Component top, Component bottom, double proportion) {
        Container parent = base.getParent();
        SplitContainer newSplit = new SplitContainer(0);
        DockingUtilities.replaceChild(parent, base, newSplit);
        newSplit.setTopComponent(top);
        newSplit.setBottomComponent(bottom);
        SwingUtilities.invokeLater(new SplitResizer(newSplit, proportion));
    }

    public static SingleDockableContainer insertDockable(Container dockingPanel, Dockable dockable, RelativeDockablePosition position) {
        if (position == null) {
            position = new RelativeDockablePosition(0.0, 0.8, 0.5, 0.2);
        }
        SingleDockableContainer dockableContainer = null;
        if (dockingPanel.getComponentCount() == 0) {
            dockableContainer = DockableContainerFactory.getFactory().createDockableContainer(dockable, 0);
            dockingPanel.add((Component)((Object)dockableContainer), "Center");
            dockingPanel.invalidate();
            dockingPanel.validate();
            dockingPanel.repaint();
        } else {
            dockableContainer = DockableContainerFactory.getFactory().createDockableContainer(dockable, 2);
            int x = (int)(position.getX() * (double)dockingPanel.getWidth());
            int y = (int)(position.getY() * (double)dockingPanel.getHeight());
            int w = (int)(position.getWidth() * (double)dockingPanel.getWidth());
            int h = (int)(position.getHeight() * (double)dockingPanel.getHeight());
            int centerX = x + w / 2;
            int centerY = y + h / 2;
            SplitContainer split = RelativeDockingUtilities.findBestContainer(dockingPanel, position);
            if (split != null) {
                Component bestComp;
                Point bestCenter;
                Rectangle splitRect = SwingUtilities.convertRectangle(split, new Rectangle(0, 0, split.getWidth(), split.getHeight()), dockingPanel);
                boolean anchoredTop = Math.abs(y - splitRect.y) < 5;
                boolean anchoredLeft = Math.abs(x - splitRect.x) < 5;
                boolean anchoredBottom = Math.abs(y + h - splitRect.y - splitRect.height) < 30;
                boolean anchoredRight = Math.abs(x + w - splitRect.x - splitRect.width) < 5;
                Component left = split.getLeftComponent();
                Component right = split.getRightComponent();
                Point leftCenter = SwingUtilities.convertPoint(left, left.getWidth() / 2, left.getHeight() / 2, dockingPanel);
                Point rightCenter = SwingUtilities.convertPoint(right, right.getWidth() / 2, right.getHeight() / 2, dockingPanel);
                int leftDist = (leftCenter.x - x) * (leftCenter.x - x) + (leftCenter.y - y) * leftCenter.y;
                int rightDist = (rightCenter.x - x) * (rightCenter.x - x) + (rightCenter.y - y) * rightCenter.y;
                if (leftDist < rightDist) {
                    bestCenter = leftCenter;
                    bestComp = left;
                } else {
                    bestCenter = rightCenter;
                    bestComp = right;
                }
                if (split.getOrientation() == 0) {
                    int splitW;
                    float proportionW;
                    Component top = split.getTopComponent();
                    Component bottom = split.getBottomComponent();
                    int topH = top.getHeight();
                    int bottomH = bottom.getHeight();
                    float proportionTopH = (float)h / (float)topH;
                    float proportionBottomH = (float)h / (float)bottomH;
                    if (proportionTopH >= 0.6f) {
                        proportionTopH = 0.6f;
                    }
                    if (proportionBottomH >= 0.6f) {
                        proportionBottomH = 0.6f;
                    }
                    if ((proportionW = (float)w / (float)(splitW = split.getWidth())) >= 0.8f) {
                        proportionW = 0.8f;
                    }
                    if (anchoredTop) {
                        if (anchoredLeft) {
                            if (anchoredBottom) {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setLeftComponent((Component)((Object)dockableContainer));
                                newSplit.setRightComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionW));
                            } else {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split, top, newSplit);
                                newSplit.setLeftComponent((Component)((Object)dockableContainer));
                                newSplit.setRightComponent(top);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionW));
                            }
                        } else if (anchoredRight) {
                            if (anchoredBottom) {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setRightComponent((Component)((Object)dockableContainer));
                                newSplit.setLeftComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionW));
                            } else {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split, top, newSplit);
                                newSplit.setLeftComponent(top);
                                newSplit.setRightComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionW));
                            }
                        } else {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split, top, newSplit);
                            newSplit.setTopComponent((Component)((Object)dockableContainer));
                            newSplit.setBottomComponent(top);
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionTopH));
                        }
                    } else if (anchoredBottom) {
                        if (anchoredLeft) {
                            if (anchoredRight) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split, bottom, newSplit);
                                newSplit.setTopComponent(bottom);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionBottomH));
                            } else {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split, bottom, newSplit);
                                newSplit.setLeftComponent((Component)((Object)dockableContainer));
                                newSplit.setRightComponent(bottom);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionW));
                            }
                        } else if (anchoredRight) {
                            SplitContainer newSplit = new SplitContainer(1);
                            DockingUtilities.replaceChild(split, bottom, newSplit);
                            newSplit.setLeftComponent(bottom);
                            newSplit.setRightComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionW));
                        } else {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split, bottom, newSplit);
                            newSplit.setTopComponent(bottom);
                            newSplit.setBottomComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionBottomH));
                        }
                    } else if (anchoredLeft) {
                        if (anchoredRight) {
                            int yTop = y;
                            int yBottom = split.getHeight() - y - h;
                            int splitTop = top.getHeight();
                            int splitBottom = bottom.getHeight();
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split, bestComp, newSplit);
                            if (bestComp == top) {
                                newSplit.setTopComponent(bestComp);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(split, (float)(split.getHeight() - yBottom) / (float)split.getHeight()));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)yTop / (float)split.getHeight()));
                            } else {
                                newSplit.setBottomComponent(bestComp);
                                newSplit.setTopComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(split, (float)yTop / (float)split.getHeight()));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)h / (float)splitBottom));
                            }
                        } else {
                            SplitContainer newSplit = new SplitContainer(1);
                            DockingUtilities.replaceChild(split, bestComp, newSplit);
                            newSplit.setRightComponent(bestComp);
                            newSplit.setLeftComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionW));
                        }
                    } else if (anchoredRight) {
                        SplitContainer newSplit = new SplitContainer(1);
                        DockingUtilities.replaceChild(split, bestComp, newSplit);
                        newSplit.setLeftComponent(bestComp);
                        newSplit.setRightComponent((Component)((Object)dockableContainer));
                        SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionW));
                    } else {
                        SplitContainer newSplit = new SplitContainer(0);
                        DockingUtilities.replaceChild(split, bestComp, newSplit);
                        if (bestCenter.y < centerY) {
                            newSplit.setTopComponent(bestComp);
                            newSplit.setBottomComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionBottomH));
                        } else {
                            newSplit.setBottomComponent(bestComp);
                            newSplit.setTopComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionTopH));
                        }
                    }
                } else {
                    int splitH;
                    float proportionH;
                    float proportionLeftW = (float)w / (float)left.getWidth();
                    float proportionRightW = (float)w / (float)right.getWidth();
                    if (proportionLeftW >= 0.8f) {
                        proportionLeftW = 0.8f;
                    }
                    if (proportionRightW >= 0.8f) {
                        proportionRightW = 0.8f;
                    }
                    if ((proportionH = (float)h / (float)(splitH = split.getHeight())) >= 0.6f) {
                        proportionH = 0.6f;
                    }
                    if (anchoredTop) {
                        if (anchoredLeft) {
                            if (anchoredBottom) {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split, left, newSplit);
                                newSplit.setLeftComponent((Component)((Object)dockableContainer));
                                newSplit.setRightComponent(left);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionLeftW));
                            } else if (anchoredRight) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setTopComponent((Component)((Object)dockableContainer));
                                newSplit.setBottomComponent(split);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionH));
                            } else {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split, left, newSplit);
                                newSplit.setTopComponent((Component)((Object)dockableContainer));
                                newSplit.setBottomComponent(left);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionH));
                            }
                        } else if (anchoredRight) {
                            if (anchoredBottom) {
                                SplitContainer newSplit = new SplitContainer(1);
                                DockingUtilities.replaceChild(split, right, newSplit);
                                newSplit.setRightComponent((Component)((Object)dockableContainer));
                                newSplit.setLeftComponent(right);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionRightW));
                            } else {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split, right, newSplit);
                                newSplit.setBottomComponent(right);
                                newSplit.setTopComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionH));
                            }
                        } else if (anchoredBottom) {
                            int xLeft = x;
                            int xRight = split.getWidth() - x - w;
                            int splitLeft = left.getWidth();
                            int splitRight = right.getWidth();
                            SplitContainer newSplit = new SplitContainer(1);
                            DockingUtilities.replaceChild(split, bestComp, newSplit);
                            if (bestComp == left) {
                                newSplit.setLeftComponent(bestComp);
                                newSplit.setRightComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(split, (float)(split.getWidth() - xRight) / (float)split.getWidth()));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)xLeft / (float)split.getWidth()));
                            } else {
                                newSplit.setRightComponent(bestComp);
                                newSplit.setLeftComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(split, (float)xLeft / (float)split.getWidth()));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, (float)w / (float)splitRight));
                            }
                        } else {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split, bestComp, newSplit);
                            newSplit.setTopComponent((Component)((Object)dockableContainer));
                            newSplit.setBottomComponent(bestComp);
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionH));
                        }
                    } else if (anchoredBottom) {
                        if (anchoredLeft) {
                            if (anchoredRight) {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split.getParent(), split, newSplit);
                                newSplit.setTopComponent(split);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionH));
                            } else {
                                SplitContainer newSplit = new SplitContainer(0);
                                DockingUtilities.replaceChild(split, left, newSplit);
                                newSplit.setBottomComponent((Component)((Object)dockableContainer));
                                newSplit.setTopComponent(left);
                                SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionH));
                            }
                        } else if (anchoredRight) {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split, right, newSplit);
                            newSplit.setTopComponent(right);
                            newSplit.setBottomComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionH));
                        } else {
                            SplitContainer newSplit = new SplitContainer(0);
                            DockingUtilities.replaceChild(split, bestComp, newSplit);
                            newSplit.setTopComponent(bestComp);
                            newSplit.setBottomComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionH));
                        }
                    } else if (anchoredLeft) {
                        SplitContainer newSplit = new SplitContainer(1);
                        DockingUtilities.replaceChild(split, left, newSplit);
                        newSplit.setRightComponent(left);
                        newSplit.setLeftComponent((Component)((Object)dockableContainer));
                        SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionLeftW));
                    } else if (anchoredRight) {
                        SplitContainer newSplit = new SplitContainer(1);
                        DockingUtilities.replaceChild(split, right, newSplit);
                        newSplit.setLeftComponent(right);
                        newSplit.setRightComponent((Component)((Object)dockableContainer));
                        SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionRightW));
                    } else {
                        SplitContainer newSplit = new SplitContainer(0);
                        DockingUtilities.replaceChild(split, bestComp, newSplit);
                        if (bestCenter.y < centerY) {
                            newSplit.setTopComponent(bestComp);
                            newSplit.setBottomComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, 1.0f - proportionH));
                        } else {
                            newSplit.setBottomComponent(bestComp);
                            newSplit.setTopComponent((Component)((Object)dockableContainer));
                            SwingUtilities.invokeLater(new SplitResizer(newSplit, proportionH));
                        }
                    }
                }
            } else {
                float proportionH;
                boolean anchoredTop = y < 5;
                boolean anchoredLeft = x < 5;
                boolean anchoredBottom = Math.abs(y + h - dockingPanel.getHeight()) < 5;
                boolean anchoredRight = Math.abs(x + w - dockingPanel.getWidth()) < 5;
                Component singleComp = dockingPanel.getComponent(0);
                float proportionW = (float)w / (float)dockingPanel.getWidth();
                if (proportionW >= 0.8f) {
                    proportionW = 0.8f;
                }
                if ((proportionH = (float)h / (float)dockingPanel.getHeight()) >= 0.6f) {
                    proportionH = 0.6f;
                }
                if (anchoredTop) {
                    if (anchoredLeft) {
                        if (anchoredBottom) {
                            RelativeDockingUtilities.hSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionW);
                        } else if (anchoredRight) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionH);
                        } else if (w > h) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionH);
                        } else {
                            RelativeDockingUtilities.hSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionW);
                        }
                    } else if (anchoredRight) {
                        if (anchoredBottom) {
                            RelativeDockingUtilities.hSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionW);
                        } else if (w > h) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionH);
                        } else {
                            RelativeDockingUtilities.hSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionW);
                        }
                    } else {
                        RelativeDockingUtilities.vSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionH);
                    }
                } else if (anchoredLeft) {
                    if (anchoredBottom) {
                        if (anchoredRight) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionH);
                        } else if (w > h) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionH);
                        } else {
                            RelativeDockingUtilities.hSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionW);
                        }
                    } else if (anchoredRight) {
                        if (centerY < dockingPanel.getHeight() / 2) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionH);
                        } else {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionH);
                        }
                    } else {
                        RelativeDockingUtilities.hSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionW);
                    }
                } else if (anchoredBottom) {
                    if (anchoredRight) {
                        if (w > h) {
                            RelativeDockingUtilities.vSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionH);
                        } else {
                            RelativeDockingUtilities.hSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionW);
                        }
                    } else {
                        RelativeDockingUtilities.vSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionH);
                    }
                } else if (anchoredRight) {
                    RelativeDockingUtilities.hSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionW);
                } else if (centerY < dockingPanel.getHeight() / 2) {
                    RelativeDockingUtilities.vSplitAndResize(singleComp, (Component)((Object)dockableContainer), singleComp, proportionH);
                } else {
                    RelativeDockingUtilities.vSplitAndResize(singleComp, singleComp, (Component)((Object)dockableContainer), 1.0f - proportionH);
                }
            }
        }
        return dockableContainer;
    }
}

