/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DockDropReceiver;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableDragSource;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingPanel;
import com.vlsolutions.swing.docking.DockingPreferences;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.FloatingDockableContainer;
import com.vlsolutions.swing.docking.SplitContainer;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockDragEvent;
import com.vlsolutions.swing.docking.event.DockDropEvent;
import com.vlsolutions.swing.docking.event.DockableStateChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class DragControler
implements MouseListener,
MouseMotionListener {
    private static boolean isLightWeight = DockingPreferences.isLightWeightUsageEnabled();
    private ShapePainterStrategy currentShapePainterStrategy;
    private boolean startDrag;
    private Shape dropShape;
    private boolean isFloatingShape = false;
    private DockableDragSource dockableDragSource;
    private Point dragPoint;
    private Point startDragPoint;
    private DockDropReceiver dropReceiver;
    private DockingDesktop desktop;
    private boolean ignoreDrag;
    private boolean paintFloatingDragShape = UIManager.getBoolean("FloatingContainer.paintDragShape");
    private HashMap shapePainters = new HashMap();
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$java$awt$Container;

    DragControler(DockingDesktop desktop) {
        this.desktop = desktop;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.startDrag = true;
            this.ignoreDrag = false;
        } else if (this.dragPoint != null) {
            this.cancelDrag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            if (this.dragPoint != null) {
                this.cancelDrag();
            }
        } else {
            if (this.ignoreDrag) {
                return;
            }
            try {
                if (this.dragPoint != null && this.dockableDragSource != null) {
                    this.processMouseReleased(e);
                }
            }
            finally {
                this.cancelDrag();
            }
        }
    }

    private void processMouseReleased(MouseEvent e) {
        DockableDragSource dragSource = (DockableDragSource)e.getSource();
        this.dragPoint = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.desktop);
        Component underMouse = this.findComponentUnderMouse(e);
        ShapePainterStrategy shapePainterStrategy = this.getShapePainter(underMouse, dragSource);
        int dx = this.dragPoint.x - this.startDragPoint.x;
        int dy = this.dragPoint.y - this.startDragPoint.y;
        if (Math.abs(dx) < 20 && Math.abs(dy) < 10) {
            return;
        }
        DockingPanel dp = this.desktop.getDockingPanel();
        Insets i = this.desktop.getDockingPanelInsets();
        Rectangle deskBounds = new Rectangle(i.left, i.top, this.desktop.getWidth() - i.left - i.right, this.desktop.getHeight() - i.top - i.bottom);
        Rectangle innerBounds = new Rectangle(deskBounds);
        innerBounds.x += 5;
        innerBounds.y += 5;
        innerBounds.width -= 10;
        innerBounds.height -= 10;
        if (deskBounds.contains(this.dragPoint) && !innerBounds.contains(this.dragPoint)) {
            underMouse = dp;
        }
        while (underMouse != null && underMouse != this.desktop && !(underMouse instanceof DockDropReceiver)) {
            underMouse = underMouse.getParent();
        }
        if (underMouse == null) {
            DropProcess dropProcess;
            if (underMouse instanceof DockDropReceiver) {
                this.dropReceiver = (DockDropReceiver)((Object)underMouse);
            }
            if ((dropProcess = new DropProcess(e, this.dockableDragSource, underMouse)).canDockableBeDetached() && dropProcess.checkDockableWillBeDetached()) {
                Point location = new Point(e.getPoint());
                SwingUtilities.convertPointToScreen(location, e.getComponent());
                dropProcess.setFloating(location);
            }
        } else if (underMouse instanceof DockDropReceiver && e.isControlDown()) {
            this.processHotSwap(underMouse, e.getComponent(), null, true);
        } else if (underMouse instanceof DockDropReceiver) {
            DropProcess process = new DropProcess(e, this.dockableDragSource, underMouse);
            DockDragEvent event = process.findAcceptableEvent(e);
            if (event.isDragAccepted() && process.checkStateChange()) {
                process.dropIfPossible();
            } else if (process.canDockableBeDetached() && process.checkDockableWillBeDetached()) {
                Point location = new Point(e.getPoint());
                SwingUtilities.convertPointToScreen(location, e.getComponent());
                process.setFloating(location);
            }
        } else {
            DropProcess process = new DropProcess(e, this.dockableDragSource, underMouse);
            if (process.canDockableBeDetached() && process.checkDockableWillBeDetached()) {
                Point location = new Point(e.getPoint());
                SwingUtilities.convertPointToScreen(location, e.getComponent());
                process.setFloating(location);
            }
        }
    }

    public void cancelDrag() {
        this.ignoreDrag = true;
        this.dropShape = null;
        this.dockableDragSource = null;
        this.startDrag = true;
        this.dragPoint = null;
        if (this.currentShapePainterStrategy != null) {
            this.currentShapePainterStrategy.endDrag();
        }
        this.clearStrategies();
        this.desktop.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.isDragAndDropEnabled()) {
            this.ignoreDrag = true;
        }
        if (this.ignoreDrag) {
            return;
        }
        if (this.startDrag) {
            this.startDrag = false;
            this.processDragGestureStart(e);
        } else {
            this.processMouseDragged(e);
        }
    }

    private void processDragGestureStart(MouseEvent e) {
        DockableDragSource dragSource = (DockableDragSource)e.getSource();
        this.dragPoint = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.desktop);
        this.dropShape = null;
        this.dockableDragSource = null;
        this.startDragPoint = e.getPoint();
        if (dragSource.startDragComponent(this.startDragPoint)) {
            this.dockableDragSource = dragSource;
            this.getShapePainter(e.getComponent(), dragSource).startDrag(dragSource);
            this.startDragPoint = new Point(this.dragPoint);
            this.processMouseDragged(e);
        } else {
            this.ignoreDrag = true;
        }
    }

    private boolean isDragAndDropEnabled() {
        return UIManager.getBoolean("DragControler.isDragAndDropEnabled");
    }

    private void processMouseDragged(MouseEvent e) {
        Component dragged = (Component)e.getSource();
        DockableDragSource dragSource = (DockableDragSource)e.getSource();
        this.dragPoint = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.desktop);
        Component underMouse = this.findComponentUnderMouse(e);
        ShapePainterStrategy shapePainterStrategy = this.getShapePainter(underMouse, dragSource);
        if (this.dragPoint == null || this.startDragPoint == null) {
            this.ignoreDrag = true;
            return;
        }
        int dx = this.dragPoint.x - this.startDragPoint.x;
        int dy = this.dragPoint.y - this.startDragPoint.y;
        if (Math.abs(dx) < 20 && Math.abs(dy) < 10) {
            shapePainterStrategy.showStopDragCursor();
            this.setDropShape(null, shapePainterStrategy);
            return;
        }
        DockingPanel dp = this.desktop.getDockingPanel();
        Insets i = this.desktop.getDockingPanelInsets();
        Rectangle deskBounds = new Rectangle(i.left, i.top, this.desktop.getWidth() - i.left - i.right, this.desktop.getHeight() - i.top - i.bottom);
        Rectangle innerBounds = new Rectangle(deskBounds);
        innerBounds.x += 5;
        innerBounds.y += 5;
        innerBounds.width -= 10;
        innerBounds.height -= 10;
        if (deskBounds.contains(this.dragPoint) && !innerBounds.contains(this.dragPoint)) {
            underMouse = dp;
        }
        while (underMouse != null && underMouse != this.desktop && !(underMouse instanceof DockDropReceiver)) {
            underMouse = underMouse.getParent();
        }
        if (underMouse == null) {
            DragProcess process;
            if (underMouse instanceof DockDropReceiver) {
                this.dropReceiver = (DockDropReceiver)((Object)underMouse);
            }
            if (!(process = new DragProcess(this.dockableDragSource, underMouse)).canDockableBeDetached() || !process.checkAndDetachDockable(shapePainterStrategy)) {
                shapePainterStrategy.showStopDragCursor();
                this.setDropShape(null, shapePainterStrategy);
            }
        } else if (underMouse instanceof DockDropReceiver && e.isControlDown()) {
            this.processHotSwap(underMouse, dragged, shapePainterStrategy, false);
        } else if (underMouse instanceof DockDropReceiver) {
            DragProcess process = new DragProcess(this.dockableDragSource, underMouse);
            DockDragEvent event = process.findAcceptableEvent(e);
            if (event.isDragAccepted() && process.checkStateChange()) {
                shapePainterStrategy.showDragCursor();
                this.setDropShape(event.getDropShape(), shapePainterStrategy);
            } else if (!process.canDockableBeDetached() || !process.checkAndDetachDockable(shapePainterStrategy)) {
                event.rejectDrag();
                shapePainterStrategy.showStopDragCursor();
                this.setDropShape(null, shapePainterStrategy);
            }
        } else {
            DragProcess process = new DragProcess(this.dockableDragSource, underMouse);
            if (!process.canDockableBeDetached() || !process.checkAndDetachDockable(shapePainterStrategy)) {
                shapePainterStrategy.showStopDragCursor();
                this.setDropShape(null, shapePainterStrategy);
            }
        }
    }

    private void processHotSwap(Component underMouse, Component dragged, ShapePainterStrategy shapePainterStrategy, boolean drop) {
        while (underMouse != null && !(underMouse.getParent() instanceof SplitContainer)) {
            underMouse = underMouse.getParent();
        }
        if (underMouse != null) {
            Component splitChild;
            for (splitChild = dragged; splitChild != null && !(splitChild.getParent() instanceof SplitContainer); splitChild = splitChild.getParent()) {
            }
            if (splitChild != null && splitChild != underMouse && underMouse instanceof DockDropReceiver) {
                if (drop) {
                    DockingUtilities.updateResizeWeights(this.desktop.getDockingPanel());
                    DockingUtilities.swapComponents(splitChild, underMouse);
                    DockingUtilities.updateResizeWeights(this.desktop.getDockingPanel());
                } else {
                    shapePainterStrategy.showSwapDragCursor();
                    Rectangle bounds = underMouse.getBounds();
                    Rectangle2D.Float shape = new Rectangle2D.Float(0.0f, 0.0f, bounds.width, bounds.height);
                    this.dropReceiver = (DockDropReceiver)((Object)underMouse);
                    this.setDropShape(shape, shapePainterStrategy);
                }
            } else if (!drop) {
                shapePainterStrategy.showStopDragCursor();
                this.setDropShape(null, shapePainterStrategy);
            }
        } else if (!drop) {
            shapePainterStrategy.showStopDragCursor();
            this.setDropShape(null, shapePainterStrategy);
        }
    }

    private void setDropShape(Shape shape, ShapePainterStrategy shapePainterStrategy) {
        this.setDropShape(shape, shapePainterStrategy, false);
    }

    private void setDropShape(Shape shape, ShapePainterStrategy shapePainterStrategy, boolean floating) {
        if (this.dropShape == null) {
            if (shape != null) {
                this.dropShape = shape;
                this.isFloatingShape = floating;
                shapePainterStrategy.repaint();
            }
        } else if (shape != null) {
            if (!this.dropShape.equals(shape)) {
                this.dropShape = shape;
                this.isFloatingShape = floating;
                shapePainterStrategy.repaint();
            }
        } else {
            this.dropShape = shape;
            this.isFloatingShape = floating;
            shapePainterStrategy.repaint();
        }
    }

    private boolean isAncestorOf(Component probableAncestor, Component child) {
        while (child != null && child != probableAncestor) {
            child = child.getParent();
        }
        return child == probableAncestor;
    }

    public void mouseMoved(MouseEvent e) {
    }

    private Component findComponentUnderMouse(MouseEvent e) {
        Point p = new Point(e.getPoint());
        SwingUtilities.convertPointToScreen(p, e.getComponent());
        Component underMouse = null;
        Window w = SwingUtilities.getWindowAncestor(this.desktop);
        Window[] children = w.getOwnedWindows();
        for (int i = 0; i < children.length; ++i) {
            Window wChild;
            Rectangle bounds;
            if (!(children[i] instanceof FloatingDockableContainer) || !children[i].isVisible() || !(bounds = (wChild = children[i]).getBounds()).contains(p)) continue;
            Point p2 = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), wChild);
            Container contentPane = wChild instanceof JDialog ? ((JDialog)wChild).getContentPane() : ((JFrame)wChild).getContentPane();
            underMouse = this.findComponentAt(contentPane, p2.x, p2.y);
        }
        if (underMouse == null) {
            underMouse = this.findComponentAt(this.desktop, this.dragPoint.x, this.dragPoint.y);
        }
        return underMouse;
    }

    private Component findComponentAt(Container container, int x, int y) {
        if (isLightWeight) {
            return container.findComponentAt(x, y);
        }
        return this.findComponentAtForHeavy(container, x, y);
    }

    private Component findComponentAtForHeavy(Container container, int x, int y) {
        Rectangle bounds = new Rectangle();
        int count = container.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = container.getComponent(i);
            if (!child.isVisible()) continue;
            child.getBounds(bounds);
            if (!bounds.contains(x, y)) continue;
            if (child instanceof Container) {
                Component found = this.findComponentAtForHeavy((Container)child, x - bounds.x, y - bounds.y);
                if (found != null) {
                    return found;
                }
                return child;
            }
            if (child instanceof HeavyShape || child instanceof HeavyLabel) continue;
            return child;
        }
        return null;
    }

    private ShapePainterStrategy getShapePainter(Component comp, DockableDragSource source) {
        Window w;
        ShapePainterStrategy newStrategy;
        if (comp == null) {
            comp = this.desktop;
        }
        if ((newStrategy = (ShapePainterStrategy)this.shapePainters.get(w = SwingUtilities.getWindowAncestor(comp))) == null) {
            newStrategy = new ShapePainterStrategy(w);
            this.shapePainters.put(w, newStrategy);
            if (this.currentShapePainterStrategy != null) {
                this.currentShapePainterStrategy.endDrag();
            }
            this.currentShapePainterStrategy = newStrategy;
            newStrategy.startDrag(source);
            return newStrategy;
        }
        if (newStrategy == this.currentShapePainterStrategy) {
            return newStrategy;
        }
        this.currentShapePainterStrategy.endDrag();
        this.currentShapePainterStrategy = newStrategy;
        newStrategy.startDrag(source);
        return newStrategy;
    }

    private void clearStrategies() {
        Window w = SwingUtilities.getWindowAncestor(this.desktop);
        Window[] owned = w.getOwnedWindows();
        for (int i = 0; i < owned.length; ++i) {
            this.shapePainters.remove(w);
        }
    }

    private class DropProcess
    extends DragProcess {
        MouseEvent event;

        DropProcess(MouseEvent event, DockableDragSource source, Component underMouse) {
            super(source, underMouse);
            this.event = event;
        }

        public void dropIfPossible() {
            MouseEvent convertMouse = SwingUtilities.convertMouseEvent((Component)this.event.getSource(), this.event, this.underMouse);
            DockDropEvent dropEvent = new DockDropEvent(DragControler.this.desktop, this.source, convertMouse);
            DragControler.this.dropReceiver.processDockableDrop(dropEvent);
            if (dropEvent.isDropAccepted()) {
                if (this.underMouse instanceof JComponent) {
                    ((JComponent)this.underMouse).revalidate();
                } else if (this.underMouse instanceof Component) {
                    this.underMouse.validate();
                    this.underMouse.repaint();
                }
                if (this.stateChange) {
                    this.fireStateChange();
                }
            }
        }

        public void fireStateChange() {
            if (this.source.getDockableContainer() instanceof TabbedDockableContainer) {
                TabbedDockableContainer tdc = (TabbedDockableContainer)((Object)this.source.getDockableContainer());
                for (int i = 0; i < tdc.getTabCount(); ++i) {
                    Dockable d = tdc.getDockableAt(i);
                    this.fireSingleStateChange(tdc.getDockableAt(i));
                }
            } else {
                this.fireSingleStateChange(this.source.getDockable());
            }
        }

        private void fireSingleStateChange(Dockable dockable) {
            DockableState currentState = DragControler.this.desktop.getDockableState(dockable);
            dockable.getDockKey().setDockableState(this.futureState);
            DragControler.this.desktop.fireDockableStateChange(new DockableStateChangeEvent(currentState, new DockableState(dockable, this.futureState)));
        }

        public void setFloating(Point location) {
            if (this.source.getDockableContainer() instanceof TabbedDockableContainer) {
                DragControler.this.desktop.setFloating((TabbedDockableContainer)((Object)this.source.getDockableContainer()), location);
            } else {
                Dockable dockable = this.source.getDockable();
                DragControler.this.desktop.setFloating(this.source.getDockable(), true, location);
            }
        }
    }

    private class DragProcess {
        DockableDragSource source;
        Component underMouse;
        boolean stateChange = false;
        int futureState;

        DragProcess(DockableDragSource source, Component underMouse) {
            this.source = source;
            this.underMouse = underMouse;
            this.futureState = DragControler.this.desktop.isAncestorOf(underMouse) ? 1 : 4;
        }

        public DockDragEvent findAcceptableEvent(MouseEvent e) {
            DockDragEvent event;
            boolean loop = false;
            do {
                DragControler.this.dropReceiver = (DockDropReceiver)((Object)this.underMouse);
                MouseEvent convertMouse = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, this.underMouse);
                DockableDragSource dragSource = (DockableDragSource)e.getSource();
                event = new DockDragEvent(DragControler.this.desktop, dragSource, convertMouse);
                DragControler.this.dropReceiver.processDockableDrag(event);
                if (event.isDragAccepted() || !event.isDragDelegated()) continue;
                this.underMouse = this.underMouse.getParent();
                while (this.underMouse != null && this.underMouse != DragControler.this.desktop && !(this.underMouse instanceof DockDropReceiver)) {
                    this.underMouse = this.underMouse.getParent();
                }
            } while (loop = event.isDragAccepted() ? false : event.isDragDelegated() && this.underMouse instanceof DockDropReceiver);
            return event;
        }

        public boolean checkStateChange() {
            if (this.source.getDockableContainer() instanceof TabbedDockableContainer) {
                TabbedDockableContainer tdc = (TabbedDockableContainer)((Object)this.source.getDockableContainer());
                for (int i = 0; i < tdc.getTabCount(); ++i) {
                    Dockable d = tdc.getDockableAt(i);
                    if (this.checkSingleDockableStateChange(d)) continue;
                    return false;
                }
                return true;
            }
            return this.checkSingleDockableStateChange(this.source.getDockable());
        }

        private boolean checkSingleDockableStateChange(Dockable dockable) {
            DockableState currentState = DragControler.this.desktop.getDockableState(dockable);
            if (currentState.getState() != this.futureState) {
                this.stateChange = true;
                DockableState newState = new DockableState(dockable, this.futureState);
                DockableStateWillChangeEvent dscwEvent = new DockableStateWillChangeEvent(currentState, newState);
                if (!DragControler.this.desktop.fireDockableStateWillChange(dscwEvent)) {
                    return false;
                }
            }
            return true;
        }

        public boolean canDockableBeDetached() {
            if (this.source.getDockableContainer() instanceof TabbedDockableContainer) {
                TabbedDockableContainer tdc = (TabbedDockableContainer)((Object)this.source.getDockableContainer());
                for (int i = 0; i < tdc.getTabCount(); ++i) {
                    Dockable d = tdc.getDockableAt(i);
                    if (this.canSingleDockableBeDetached(d)) continue;
                    return false;
                }
                Dockable any = tdc.getDockableAt(0);
                return any.getDockKey().getDockableState() != 4;
            }
            return this.canSingleDockableBeDetached(this.source.getDockable());
        }

        private boolean canSingleDockableBeDetached(Dockable dockable) {
            DockKey key = dockable.getDockKey();
            if (key.getDockableState() == 4) {
                return DockingUtilities.findTabbedDockableContainer(dockable) != null;
            }
            if (key.isFloatEnabled()) {
                return key.getDockableState() != 3;
            }
            return false;
        }

        public boolean checkDockableWillBeDetached() {
            if (this.source.getDockableContainer() instanceof TabbedDockableContainer) {
                TabbedDockableContainer tdc = (TabbedDockableContainer)((Object)this.source.getDockableContainer());
                for (int i = 0; i < tdc.getTabCount(); ++i) {
                    Dockable d = tdc.getDockableAt(i);
                    if (this.checkSingleDockableWillBeDetached(d)) continue;
                    return false;
                }
                return true;
            }
            return this.checkSingleDockableWillBeDetached(this.source.getDockable());
        }

        private boolean checkSingleDockableWillBeDetached(Dockable dockable) {
            DockableState newState = new DockableState(dockable, 4);
            DockableState currentState = DragControler.this.desktop.getDockableState(dockable);
            DockableStateWillChangeEvent dscwEvent = new DockableStateWillChangeEvent(currentState, newState);
            return DragControler.this.desktop.fireDockableStateWillChange(dscwEvent);
        }

        public boolean checkAndDetachDockable(ShapePainterStrategy shapePainterStrategy) {
            if (this.checkDockableWillBeDetached()) {
                if (DockingPreferences.isLightWeightUsageEnabled() && DragControler.this.paintFloatingDragShape) {
                    Point shapePoint = new Point(DragControler.this.dragPoint);
                    SwingUtilities.convertPointToScreen(shapePoint, DragControler.this.desktop);
                    if (DragControler.this.dropReceiver != null) {
                        SwingUtilities.convertPointFromScreen(shapePoint, (Component)((Object)DragControler.this.dropReceiver));
                        Dimension dragSize = DragControler.this.dockableDragSource.getDockableContainer().getSize();
                        DragControler.this.setDropShape(new Rectangle2D.Float(shapePoint.x, shapePoint.y, dragSize.width, dragSize.height), shapePainterStrategy, true);
                    } else {
                        DragControler.this.setDropShape(null, shapePainterStrategy);
                    }
                } else {
                    DragControler.this.setDropShape(null, shapePainterStrategy);
                }
                shapePainterStrategy.showFloatCursor();
                return true;
            }
            return false;
        }
    }

    private class ShapeLabelPainter {
        private Color textColor = Color.WHITE;
        private Color textFillColor = new Color(32, 32, 32, 128);
        private Color textBorderColor = new Color(64, 64, 64);

        private ShapeLabelPainter() {
        }

        public void paintLabel(Graphics2D g2, Shape s, String name) {
            int by;
            int bx;
            Rectangle bounds = s.getBounds();
            FontMetrics fm = g2.getFontMetrics();
            int w = fm.stringWidth(name);
            g2.setColor(this.textFillColor);
            if (DragControler.this.isFloatingShape) {
                bx = bounds.x + bounds.width / 2 - w / 2;
                by = bounds.y + bounds.height / 2 - fm.getHeight() / 2;
            } else {
                bx = 4 * ((bounds.x + bounds.width / 2 - w / 2) / 4);
                by = 4 * ((bounds.y + bounds.height / 2 - fm.getHeight() / 2) / 4);
            }
            g2.fillRect(bx - 5, by, w + 10, fm.getHeight());
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(this.textBorderColor);
            g2.drawRect(bx - 5, by, w + 10, fm.getHeight());
            g2.setColor(this.textColor);
            g2.drawString(name, bx, by + fm.getAscent());
        }
    }

    private class ShapeOutlinePainter {
        private Color innerColor = new Color(64, 64, 64);

        private ShapeOutlinePainter() {
        }

        public void paintShape(Graphics2D g2, Shape s) {
            Composite old = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.25f));
            g2.setStroke(new BasicStroke(3.0f));
            g2.setColor(this.innerColor);
            g2.fill(s);
            g2.setComposite(old);
            g2.setColor(Color.DARK_GRAY);
            g2.draw(s);
        }
    }

    private class HeavyLabel
    extends Canvas {
        private Color textColor = Color.WHITE;
        private Color textFillColor = new Color(128, 128, 128);
        private Color textBorderColor = new Color(64, 64, 64);
        private String name;
        private Icon icon;

        public HeavyLabel() {
            this.setEnabled(false);
        }

        public void setZOrder() {
            try {
                Method m = (class$java$awt$Container == null ? (class$java$awt$Container = DragControler.class$("java.awt.Container")) : class$java$awt$Container).getMethod("setComponentZOrder", class$java$awt$Component == null ? (class$java$awt$Component = DragControler.class$("java.awt.Component")) : class$java$awt$Component, Integer.TYPE);
                m.invoke((Object)this.getParent(), this, new Integer(0));
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public void moveToCenter(Rectangle shapeBounds) {
            Font f = this.getFont();
            if (f != null) {
                FontMetrics fm = this.getFontMetrics(f);
                int w = fm.stringWidth(this.name) + 10;
                int h = fm.getHeight() + 5;
                this.setBounds(shapeBounds.x + shapeBounds.width / 2 - w / 2, shapeBounds.y + shapeBounds.height / 2 - h / 2, w, h);
            }
        }

        public void paint(Graphics g) {
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(this.name);
            int h = fm.getHeight();
            g.setColor(this.textFillColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.textBorderColor);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(this.textColor);
            g.drawString(this.name, this.getWidth() / 2 - w / 2, this.getHeight() / 2 + h / 2);
        }
    }

    private class HeavyShape
    extends Canvas {
        private Rectangle cachedShapeBounds;
        private BufferedImage desktopImage;
        private Image subImage;
        private Rectangle subImageBounds;
        private ShapeOutlinePainter outlinePainter;
        private HeavyLabel label;

        public HeavyShape() {
            this.outlinePainter = new ShapeOutlinePainter();
            this.label = new HeavyLabel();
            this.setEnabled(false);
        }

        public void setZOrder() {
            try {
                Method m = (class$java$awt$Container == null ? (class$java$awt$Container = DragControler.class$("java.awt.Container")) : class$java$awt$Container).getMethod("setComponentZOrder", class$java$awt$Component == null ? (class$java$awt$Component = DragControler.class$("java.awt.Component")) : class$java$awt$Component, Integer.TYPE);
                m.invoke((Object)this.getParent(), this, new Integer(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.label.setZOrder();
        }

        private void startDrag() {
            Container parent = this.getParent();
            if (this.desktopImage == null || this.desktopImage.getWidth() != parent.getWidth() || this.desktopImage.getHeight() != parent.getHeight()) {
                this.desktopImage = (BufferedImage)parent.createImage(parent.getWidth(), parent.getHeight());
                this.subImage = null;
            }
            Graphics g = this.desktopImage.getGraphics();
            parent.paint(g);
            g.dispose();
        }

        public void paint(Graphics g) {
            if (DragControler.this.dropShape != null) {
                Point p = SwingUtilities.convertPoint((Component)((Object)DragControler.this.dropReceiver), 0, 0, this.getParent());
                Rectangle r = DragControler.this.dropShape.getBounds();
                int shapeX = r.x;
                int shapeY = r.y;
                r.x += p.x;
                r.y += p.y;
                r.width += 2;
                r.height += 2;
                if (r.x + r.width > this.desktopImage.getWidth()) {
                    r.width = this.desktopImage.getWidth() - r.x;
                }
                if (r.y + r.height > this.desktopImage.getHeight()) {
                    r.height = this.desktopImage.getHeight() - r.y;
                }
                if (this.subImage == null || !r.equals(this.subImageBounds)) {
                    this.subImageBounds = r;
                    this.subImage = this.desktopImage.getSubimage(r.x, r.y, r.width, r.height);
                }
                g.drawImage(this.subImage, 0, 0, null);
                Shape s = AffineTransform.getTranslateInstance(-shapeX, -shapeY).createTransformedShape(DragControler.this.dropShape);
                Graphics2D g2 = (Graphics2D)g;
                this.outlinePainter.paintShape(g2, s);
            }
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.label.setVisible(visible);
        }

        public void setCursor(Cursor cursor) {
            super.setCursor(cursor);
            this.label.setCursor(cursor);
        }

        public void moveToShape(Shape newShape) {
            this.setVisible(true);
            Shape s = DragControler.this.dropShape;
            Container container = this.getParent();
            Point p = SwingUtilities.convertPoint((Component)((Object)DragControler.this.dropReceiver), 0, 0, container);
            Rectangle r = DragControler.this.dropShape.getBounds();
            r.x += p.x;
            r.y += p.y;
            r.width += 2;
            r.height += 2;
            if (r.x + r.width > container.getWidth()) {
                r.width = container.getWidth() - r.x;
            }
            if (r.y + r.height > container.getHeight()) {
                r.height = container.getHeight() - r.y;
            }
            if (!r.equals(this.cachedShapeBounds)) {
                this.setBounds(r);
                this.cachedShapeBounds = r;
                this.label.moveToCenter(r);
            }
        }
    }

    class GlassPane
    extends JComponent {
        Cursor stopDragCursor;
        Cursor dragCursor;
        Cursor floatCursor;
        Cursor swapDragCursor;
        Color innerColor = new Color(64, 64, 64, 64);
        Color textColor = Color.WHITE;
        Color textFillColor = new Color(32, 32, 32, 128);
        Color textBorderColor = new Color(64, 64, 64);
        boolean paintShapes = true;
        ShapeLabelPainter labelPainter = new ShapeLabelPainter();
        ShapeOutlinePainter outlinePainer = new ShapeOutlinePainter();

        GlassPane() {
            this.addMouseListener(new MouseAdapter(){});
            this.addMouseMotionListener(new MouseMotionAdapter(){});
            this.showDragCursor();
        }

        public void setPaintShapes(boolean paintShapes) {
            this.paintShapes = paintShapes;
        }

        public void paintComponent(Graphics g) {
            if (this.paintShapes) {
                Graphics2D g2 = (Graphics2D)g;
                if (DragControler.this.dropShape != null) {
                    Shape s = DragControler.this.dropShape;
                    Point p = SwingUtilities.convertPoint((Component)((Object)DragControler.this.dropReceiver), 0, 0, this);
                    Shape s2 = AffineTransform.getTranslateInstance(p.x, p.y).createTransformedShape(s);
                    this.outlinePainer.paintShape(g2, s2);
                    this.labelPainter.paintLabel(g2, s2, DragControler.this.dockableDragSource.getDockable().getDockKey().getName());
                }
            }
        }

        public void showStopDragCursor() {
            if (this.stopDragCursor == null) {
                Image stopDragImage = (Image)UIManager.get("DragControler.stopDragCursor");
                this.stopDragCursor = Toolkit.getDefaultToolkit().createCustomCursor(stopDragImage, new Point(16, 16), "stopdragcursor");
            }
            this.setCursor(this.stopDragCursor);
        }

        public void showSwapDragCursor() {
            if (this.swapDragCursor == null) {
                Image swapDragImage = (Image)UIManager.get("DragControler.swapDragCursor");
                this.swapDragCursor = Toolkit.getDefaultToolkit().createCustomCursor(swapDragImage, new Point(16, 16), "swapdragcursor");
            }
            this.setCursor(this.swapDragCursor);
        }

        public void showFloatCursor() {
            if (this.floatCursor == null) {
                Image floatImage = (Image)UIManager.get("DragControler.detachCursor");
                this.floatCursor = Toolkit.getDefaultToolkit().createCustomCursor(floatImage, new Point(16, 16), "floatcursor");
            }
            this.setCursor(this.floatCursor);
        }

        public void showDragCursor() {
            if (this.dragCursor == null) {
                Image dragImage = (Image)UIManager.get("DragControler.dragCursor");
                this.dragCursor = Toolkit.getDefaultToolkit().createCustomCursor(dragImage, new Point(16, 16), "dragcursor");
            }
            this.setCursor(this.dragCursor);
        }
    }

    private class ShapePainterStrategy {
        private GlassPane dragGlassPane;
        private Component oldGlassPane;
        private boolean oldGlassPaneVisible;
        private Window window;
        private boolean isDragStarted;
        private HeavyShape heavyShape;

        public ShapePainterStrategy(Window window) {
            this.dragGlassPane = new GlassPane();
            this.oldGlassPane = null;
            this.oldGlassPaneVisible = false;
            this.window = null;
            this.isDragStarted = false;
            this.window = window;
            if (!isLightWeight) {
                this.dragGlassPane.setPaintShapes(false);
                this.heavyShape = new HeavyShape();
            }
        }

        public void showDragCursor() {
            this.dragGlassPane.showDragCursor();
            if (!isLightWeight) {
                this.heavyShape.setCursor(this.dragGlassPane.getCursor());
            }
        }

        public void showStopDragCursor() {
            this.dragGlassPane.showStopDragCursor();
            if (!isLightWeight) {
                this.heavyShape.setCursor(this.dragGlassPane.getCursor());
            }
        }

        public void showSwapDragCursor() {
            this.dragGlassPane.showSwapDragCursor();
            if (!isLightWeight) {
                this.heavyShape.setCursor(this.dragGlassPane.getCursor());
            }
        }

        public void showFloatCursor() {
            this.dragGlassPane.showFloatCursor();
            if (!isLightWeight) {
                this.heavyShape.setCursor(this.dragGlassPane.getCursor());
            }
        }

        public void repaint() {
            if (isLightWeight) {
                this.dragGlassPane.repaint();
            } else if (DragControler.this.dropShape != null) {
                this.heavyShape.moveToShape(DragControler.this.dropShape);
            } else if (this.heavyShape.isVisible()) {
                this.heavyShape.setVisible(false);
            }
        }

        public void startDrag(DockableDragSource source) {
            if (this.isDragStarted || source == null) {
                return;
            }
            Window aboveWindow = this.window;
            this.isDragStarted = true;
            if (!isLightWeight) {
                if (this.heavyShape.getParent() == null) {
                    if (aboveWindow instanceof JFrame) {
                        JFrame fr = (JFrame)aboveWindow;
                        fr.getLayeredPane().add((Component)this.heavyShape, JLayeredPane.DRAG_LAYER);
                        this.heavyShape.validate();
                        fr.getLayeredPane().add((Component)this.heavyShape.label, JLayeredPane.DRAG_LAYER);
                    } else if (aboveWindow instanceof JDialog) {
                        JDialog dlg = (JDialog)aboveWindow;
                        dlg.getLayeredPane().add((Component)this.heavyShape, JLayeredPane.DRAG_LAYER);
                        this.heavyShape.validate();
                        dlg.getLayeredPane().add((Component)this.heavyShape.label, JLayeredPane.DRAG_LAYER);
                    }
                    this.heavyShape.setZOrder();
                }
                this.heavyShape.label.setName(source.getDockable().getDockKey().getName());
                this.heavyShape.startDrag();
            }
            if (aboveWindow instanceof JFrame) {
                this.oldGlassPane = ((JFrame)aboveWindow).getGlassPane();
                this.oldGlassPaneVisible = this.oldGlassPane.isVisible();
                ((JFrame)aboveWindow).setGlassPane(this.dragGlassPane);
                this.dragGlassPane.setVisible(true);
            } else if (aboveWindow instanceof JDialog) {
                this.oldGlassPane = ((JDialog)aboveWindow).getGlassPane();
                this.oldGlassPaneVisible = this.oldGlassPane.isVisible();
                ((JDialog)aboveWindow).setGlassPane(this.dragGlassPane);
                this.dragGlassPane.setVisible(true);
            }
        }

        public void endDrag() {
            Window aboveWindow;
            if (!isLightWeight) {
                this.heavyShape.setVisible(false);
            }
            if ((aboveWindow = this.window) instanceof JFrame) {
                ((JFrame)aboveWindow).setGlassPane(this.oldGlassPane);
            } else if (aboveWindow instanceof JDialog) {
                ((JDialog)aboveWindow).setGlassPane(this.oldGlassPane);
            }
            this.oldGlassPane.setVisible(this.oldGlassPaneVisible);
            this.isDragStarted = false;
        }
    }
}

