/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableDragSource;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockDragEvent;
import com.vlsolutions.swing.docking.event.DockDropEvent;
import com.vlsolutions.swing.docking.event.DockEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

public class BorderSplitter {
    Component delegator;

    public BorderSplitter(Component delegator) {
        this.delegator = delegator;
    }

    public void processDockableDrag(DockDragEvent e) {
        this.scanDrop(e, false);
    }

    public void processDockableDrop(DockDropEvent e) {
        this.scanDrop(e, true);
    }

    public void split(DockDropEvent event, Container draggedContainer, DockingConstants.Split position) {
        event.getDesktop().splitComponent(this.delegator, draggedContainer, position);
    }

    private void acceptSplit(DockDropEvent event, DockingConstants.Split position) {
        Container container = event.getDragSource().getDockableContainer();
        Dockable dockable = event.getDragSource().getDockable();
        TabbedDockableContainer tabAncestor = DockingUtilities.findTabbedDockableContainer(dockable);
        event.acceptDrop();
        if (container instanceof TabbedDockableContainer) {
            this.split(event, container, position);
        } else if (tabAncestor != null && tabAncestor.getTabCount() == 1 && tabAncestor == this.delegator) {
            Dockable remainingDockable = tabAncestor.getDockableAt(0);
            event.getDesktop().split(remainingDockable, dockable, position);
        } else {
            event.getDesktop().splitComponent(this.delegator, dockable, position);
        }
    }

    private void scanDrop(DockEvent event, boolean drop) {
        Point p = event.getMouseEvent().getPoint();
        Dimension size = this.delegator.getSize();
        int distTop = p.y;
        int distLeft = p.x;
        int min = Math.min(distTop, distLeft);
        int distRight = size.width - p.x;
        min = Math.min(min, distRight);
        int distBottom = size.height - p.y;
        min = Math.min(min, distBottom);
        Dimension draggedSize = null;
        DockableDragSource source = event.getDragSource();
        draggedSize = source.getDockableContainer().getSize();
        int bestHeight = (int)Math.min((double)draggedSize.height, (double)size.height * 0.5);
        int bestWidth = (int)Math.min((double)draggedSize.width, (double)size.width * 0.5);
        if (min == distTop && min < this.delegator.getHeight() / 4) {
            if (drop) {
                this.acceptSplit((DockDropEvent)event, DockingConstants.SPLIT_TOP);
            } else {
                Rectangle2D.Float r2d = new Rectangle2D.Float(0.0f, 0.0f, size.width, bestHeight);
                ((DockDragEvent)event).acceptDrag(r2d);
            }
        } else if (min == distLeft && min < this.delegator.getWidth() / 4) {
            if (drop) {
                this.acceptSplit((DockDropEvent)event, DockingConstants.SPLIT_LEFT);
            } else {
                Rectangle2D.Float r2d = new Rectangle2D.Float(0.0f, 0.0f, bestWidth, size.height);
                ((DockDragEvent)event).acceptDrag(r2d);
            }
        } else if (min == distBottom && min < this.delegator.getHeight() / 4) {
            if (drop) {
                this.acceptSplit((DockDropEvent)event, DockingConstants.SPLIT_BOTTOM);
            } else {
                Rectangle2D.Float r2d = new Rectangle2D.Float(0.0f, size.height - bestHeight, size.width, bestHeight);
                ((DockDragEvent)event).acceptDrag(r2d);
            }
        } else if (min == distRight && min < this.delegator.getWidth() / 4) {
            if (drop) {
                this.acceptSplit((DockDropEvent)event, DockingConstants.SPLIT_RIGHT);
            } else {
                Rectangle2D.Float r2d = new Rectangle2D.Float(size.width - bestWidth, 0.0f, bestWidth, size.height);
                ((DockDragEvent)event).acceptDrag(r2d);
            }
        }
    }
}

