/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.filter;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dts.spell.filter.Filter;
import org.dts.spell.finder.Word;
import org.dts.spell.tokenizer.WordTokenizer;

public class ChainFilter
implements Filter {
    private List<Filter> filters = new LinkedList<Filter>();

    public Word filter(Word word, WordTokenizer tokenizer) {
        Iterator<Filter> iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            Filter filter = iterator.next();
            word = filter.filter(word, tokenizer);
            if (word != null) continue;
            return null;
        }
        return word;
    }

    public void updateCharSequence(WordTokenizer tokenizer, int start, int end, int cause) {
        Iterator<Filter> iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            Filter filter = iterator.next();
            filter.updateCharSequence(tokenizer, start, end, cause);
        }
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
    }
}

