/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell;

import java.util.Iterator;
import java.util.List;
import org.dts.spell.dictionary.myspell.AffixMgr;
import org.dts.spell.dictionary.myspell.GuessWord;
import org.dts.spell.dictionary.myspell.HEntry;
import org.dts.spell.dictionary.myspell.MapEntry;
import org.dts.spell.dictionary.myspell.ReplEntry;
import org.dts.spell.dictionary.myspell.Utils;
import org.dts.spell.dictionary.myspell.wordmaps.WordMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestMgr {
    private static final int MAX_ROOTS = 10;
    private static final int MAX_GUESS = 10;
    private static final int NGRAM_LONGER_WORSE = 1;
    private static final int NGRAM_ANY_MISMATCH = 2;
    private static final char[] EMPTY_TRY = new char[0];
    private char[] ctry;
    private AffixMgr pAMgr;
    private int maxSug;
    private boolean nosplitsugs;

    public SuggestMgr(String tryme, int maxn, AffixMgr aptr) {
        this.pAMgr = aptr;
        this.ctry = tryme != null ? tryme.toCharArray() : EMPTY_TRY;
        this.maxSug = maxn;
        this.nosplitsugs = false;
        if (this.pAMgr != null) {
            this.nosplitsugs = this.pAMgr.get_nosplitsugs();
        }
    }

    public List<String> suggest(List<String> wlst, String word) {
        return this.suggest(wlst, word, this.maxSug);
    }

    public List<String> suggest(List<String> wlst, String word, int maxSug) {
        int nsug = wlst.size();
        int oldMaxSug = this.maxSug;
        this.maxSug = maxSug;
        if (nsug < maxSug) {
            nsug = this.firstCapital(wlst, word);
        }
        if (nsug < maxSug) {
            nsug = this.mapchars(wlst, word);
        }
        if (nsug < maxSug) {
            nsug = this.replchars(wlst, word);
        }
        if (nsug < maxSug) {
            nsug = this.forgotchar(wlst, word);
        }
        if (nsug < maxSug) {
            nsug = this.swapchar(wlst, word);
        }
        if (nsug < maxSug) {
            nsug = this.extrachar(wlst, word);
        }
        if (nsug < maxSug) {
            nsug = this.badchar(wlst, word);
        }
        if (!this.nosplitsugs && nsug < maxSug) {
            this.twowords(wlst, word);
        }
        this.maxSug = oldMaxSug;
        return wlst;
    }

    public boolean check(String word) {
        HEntry rv = null;
        if (this.pAMgr != null && (rv = this.pAMgr.lookup(word)) == null) {
            rv = this.pAMgr.affix_check(word);
        }
        return rv != null;
    }

    private int firstCapital(List<String> wlst, String word) {
        String candidate = Utils.mkInitCap(word);
        if (this.check(candidate)) {
            wlst.add(candidate);
        }
        return wlst.size();
    }

    public List<String> ngsuggest(List<String> wlst, String word, WordMap pHMgr, int nMax) {
        int j;
        int sc;
        if (pHMgr == null) {
            return wlst;
        }
        HEntry[] roots = new HEntry[10];
        int[] scores = new int[10];
        int i = 0;
        while (i < 10) {
            scores[i] = -100 * i;
            ++i;
        }
        int lp = 9;
        int n = word.length();
        Iterator<HEntry> it = pHMgr.iterator();
        while (it.hasNext()) {
            HEntry hp = it.next();
            sc = this.ngram(3, word, hp.word, 1);
            if (sc <= scores[lp]) continue;
            scores[lp] = sc;
            roots[lp] = hp;
            int lval2 = sc;
            j = 0;
            while (j < 10) {
                if (scores[j] < lval2) {
                    lp = j;
                    lval2 = scores[j];
                }
                ++j;
            }
        }
        int thresh = 0;
        char[] mw = null;
        int sp = 1;
        while (sp < 4) {
            mw = word.toCharArray();
            int k = sp;
            while (k < n) {
                mw[k] = 42;
                k += 4;
            }
            thresh += this.ngram(n, word, new String(mw), 2);
            mw = null;
            ++sp;
        }
        mw = null;
        thresh /= 3;
        --thresh;
        String[] guess = new String[10];
        int[] gscore = new int[10];
        i = 0;
        while (i < 10) {
            gscore[i] = -100 * i;
            ++i;
        }
        lp = 9;
        i = 0;
        while (i < 10) {
            if (roots[i] != null) {
                HEntry rp = roots[i];
                List<GuessWord> glst = this.pAMgr.expand_rootword(rp.word, rp.astr);
                for (GuessWord glstK : glst) {
                    sc = this.ngram(n, word, glstK.word, 2);
                    if (sc <= thresh || sc <= gscore[lp]) continue;
                    gscore[lp] = sc;
                    guess[lp] = glstK.word;
                    int lval = sc;
                    j = 0;
                    while (j < 10) {
                        if (gscore[j] < lval) {
                            lp = j;
                            lval = gscore[j];
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.bubblesort(guess, gscore);
        i = 0;
        while (i < 10 && wlst.size() < nMax) {
            if (guess[i] != null) {
                boolean unique = true;
                j = i + 1;
                while (j < 10 && unique) {
                    unique = !guess[i].equals(guess[j]);
                    ++j;
                }
                if (unique) {
                    wlst.add(guess[i]);
                }
            }
            ++i;
        }
        return wlst;
    }

    private int replchars(List<String> wlst, String word) {
        int ns = wlst.size();
        int wl = word.length();
        if (wl < 2 || this.pAMgr == null) {
            return ns;
        }
        int numrep = this.pAMgr.get_numrep();
        ReplEntry[] reptable = this.pAMgr.get_reptable();
        if (reptable == null) {
            return ns;
        }
        int i = 0;
        while (i < numrep) {
            int r = 0;
            int lenp = reptable[i].pattern.length();
            while ((r = word.indexOf(reptable[i].pattern, r)) != -1) {
                String candidate = new StringBuffer(String.valueOf(word.substring(0, r))).append(reptable[i].replacement).append(word.substring(r + lenp)).toString();
                if (!wlst.contains(candidate) && this.check(candidate)) {
                    if (ns < this.maxSug) {
                        wlst.add(candidate);
                    } else {
                        return wlst.size();
                    }
                }
                ++r;
            }
            ++i;
        }
        return wlst.size();
    }

    private int mapchars(List<String> wlst, String word) {
        int ns = wlst.size();
        int wl = word.length();
        if (wl < 2 || this.pAMgr == null) {
            return ns;
        }
        MapEntry[] maptable = this.pAMgr.get_maptable();
        if (maptable == null) {
            return ns;
        }
        this.map_related(word, 0, wlst, maptable);
        return wlst.size();
    }

    private void map_related(String word, int i, List<String> wlst, MapEntry[] maptable) {
        int nummap = maptable.length;
        if (word.length() <= i) {
            if (!wlst.contains(word) && this.check(word) && wlst.size() < this.maxSug) {
                wlst.add(word);
            }
            return;
        }
        char c = word.charAt(i);
        boolean in_map = false;
        int j = 0;
        while (j < nummap && wlst.size() < this.maxSug) {
            if (maptable[j].set.indexOf(c) != -1) {
                in_map = true;
                StringBuffer newword = new StringBuffer(word);
                int k = 0;
                while (k < maptable[j].set.length() && wlst.size() < this.maxSug) {
                    newword.setCharAt(i, maptable[j].set.charAt(k));
                    this.map_related(newword.toString(), i + 1, wlst, maptable);
                    ++k;
                }
            }
            ++j;
        }
        if (!in_map) {
            this.map_related(word, ++i, wlst, maptable);
        }
    }

    private int forgotchar(List<String> wlst, String word) {
        int ns;
        String candidateStr;
        int i;
        char[] candidate = new char[word.length() + 1];
        int wl = word.length();
        int ctryl = this.ctry.length;
        System.arraycopy(word.toCharArray(), 0, candidate, 1, wl);
        int q = 0;
        while (q < wl) {
            i = 0;
            while (i < ctryl) {
                candidate[q] = this.ctry[i];
                candidateStr = new String(candidate);
                if (!wlst.contains(candidateStr) && this.check(candidateStr)) {
                    ns = wlst.size();
                    if (ns < this.maxSug) {
                        wlst.add(candidateStr);
                    } else {
                        return ns;
                    }
                }
                ++i;
            }
            candidate[q] = word.charAt(q);
            ++q;
        }
        i = 0;
        while (i < ctryl) {
            candidate[q] = this.ctry[i];
            candidateStr = new String(candidate);
            if (!wlst.contains(candidateStr) && this.check(candidateStr)) {
                ns = wlst.size();
                if (ns < this.maxSug) {
                    wlst.add(candidateStr);
                } else {
                    return ns;
                }
            }
            ++i;
        }
        return wlst.size();
    }

    private int swapchar(List<String> wlst, String word) {
        int wl = word.length();
        char[] candidate = word.toCharArray();
        int p = 0;
        while (p + 1 < wl) {
            char tmpc = candidate[p];
            candidate[p] = candidate[p + 1];
            candidate[p + 1] = tmpc;
            String candidateStr = new String(candidate);
            if (!wlst.contains(candidateStr) && this.check(candidateStr)) {
                int ns = wlst.size();
                if (ns < this.maxSug) {
                    wlst.add(candidateStr);
                } else {
                    return ns;
                }
            }
            tmpc = candidate[p];
            candidate[p] = candidate[p + 1];
            candidate[p + 1] = tmpc;
            ++p;
        }
        return wlst.size();
    }

    private int extrachar(List<String> wlst, String word) {
        int wl = word.length();
        if (wl < 2) {
            return wlst.size();
        }
        char[] candidate = new char[wl];
        System.arraycopy(word.toCharArray(), 1, candidate, 0, wl - 1);
        int p = 0;
        while (p < wl) {
            String candidateStr = new String(candidate, 0, wl - 1);
            if (!wlst.contains(candidateStr) && this.check(candidateStr)) {
                int ns = wlst.size();
                if (ns < this.maxSug) {
                    wlst.add(candidateStr);
                } else {
                    return ns;
                }
            }
            candidate[p] = word.charAt(p);
            ++p;
        }
        return wlst.size();
    }

    private int badchar(List<String> wlst, String word) {
        char[] candidate = word.toCharArray();
        int wl = word.length();
        int ctryl = this.ctry.length;
        int i = 0;
        while (i < wl) {
            char tmpc = candidate[i];
            int j = 0;
            while (j < ctryl) {
                if (this.ctry[j] != tmpc) {
                    candidate[i] = this.ctry[j];
                    String candidateStr = new String(candidate);
                    if (!wlst.contains(candidateStr) && this.check(candidateStr)) {
                        int ns = wlst.size();
                        if (ns < this.maxSug) {
                            wlst.add(candidateStr);
                        } else {
                            return ns;
                        }
                    }
                    candidate[i] = tmpc;
                }
                ++j;
            }
            ++i;
        }
        return wlst.size();
    }

    private int twowords(List<String> wlst, String word) {
        int wl = word.length();
        if (wl < 3) {
            return wlst.size();
        }
        char[] candidate = new char[wl + 1];
        System.arraycopy(word.toCharArray(), 0, candidate, 1, wl);
        int p = 1;
        while (p + 1 < wl + 1) {
            candidate[p - 1] = candidate[p];
            String candidateStr = new String(candidate, 0, p);
            if (this.check(candidateStr) && this.check(candidateStr = new String(candidate, p + 1, candidate.length - (p + 1)))) {
                int ns = wlst.size();
                candidate[p] = 32;
                if (ns < this.maxSug) {
                    wlst.add(new String(candidate));
                } else {
                    return ns;
                }
            }
            ++p;
        }
        return wlst.size();
    }

    private int ngram(int n, String s1, String s2, int uselen) {
        int ns;
        int nscore = 0;
        int l1 = s1.length();
        int l2 = s2.length();
        int j = 1;
        while (j <= n) {
            ns = 0;
            int i = 0;
            while (i <= l1 - j) {
                if (s2.indexOf(s1.substring(i, i + j)) != -1) {
                    ++ns;
                }
                ++i;
            }
            nscore += ns;
            if (ns < 2) break;
            ++j;
        }
        ns = 0;
        if (uselen == 1) {
            ns = l2 - l1 - 2;
        }
        if (uselen == 2) {
            ns = Math.abs(l2 - l1) - 2;
        }
        return nscore - (ns > 0 ? ns : 0);
    }

    private void bubblesort(String[] rword, int[] rsc) {
        int n = rword.length;
        int m = 1;
        while (m < n) {
            int j = m;
            while (j > 0) {
                if (rsc[j - 1] >= rsc[j]) break;
                int sctmp = rsc[j - 1];
                String wdtmp = rword[j - 1];
                rsc[j - 1] = rsc[j];
                rword[j - 1] = rword[j];
                rsc[j] = sctmp;
                rword[j] = wdtmp;
                --j;
            }
            ++m;
        }
    }
}

