/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.soap.actions;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

import blanco.commons.io.File2StreamWrapper;
import blanco.commons.util.BlancoFileUtil;
import blanco.commons.util.BlancoNameUtil;
import blanco.plugin.soap.BlancoSOAPPlugin;
import blanco.plugin.soap.editors.BlancoSOAPPluginUtil;
import blanco.plugin.soap.resourcebundle.BlancoSOAPPluginResourceBundle;
import blanco.valueobject.BlancoValueObjectXml2JavaClass;
import blanco.xsd.BlancoXsdXsd2Castor;
import blanco.xsd.BlancoXsdXsd2CastorTest;
import blanco.xsd.BlancoXsdXsd2TemplateXml;
import blanco.xsd.BlancoXsdXsd2ValueObject;
import blanco.xsd.BlancoXsdXsdValidator;
import blanco.xsd.parser.ComplexTypeStructure;

/**
 * XSD쓮ANV
 * 
 * @author IGA Tosiki
 */
public class BlancoXsdGenerateAction implements IObjectActionDelegate {
    private static final BlancoSOAPPluginResourceBundle bundle = new BlancoSOAPPluginResourceBundle();

    /**
     * GUIfobOp̒ᑬ[hBʏfalseŉ^p܂B
     */
    private static final boolean IS_DEBUG_SLOW = false;

    public BlancoXsdGenerateAction() {
        super();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        // 
    }

    public void selectionChanged(IAction action, ISelection selection) {
        // this.selection = selection;
    }

    /**
     * blancoSOAP\[XR[hs܂B
     * 
     * @param input
     * @return
     * @throws InvocationTargetException
     * @throws InterruptedException
     */
    public static final void process(final IFile ifile, final Shell shell,
            final IProgressMonitor workbenchMonitor, final String metaDir)
            throws InvocationTargetException, InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask("blancoXsd\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_쐬: blancotH_");

                                final IFolder folderDirBlanco = ifile
                                        .getProject().getFolder("blanco");
                                folderDirBlanco.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);
                                if (folderDirBlanco.exists() == false) {
                                    folderDirBlanco.create(true, true,
                                            workbenchMonitor);
                                }

                                monitor.subTask("tH_쐬: blanco/maintH_");
                                final IFolder folderDirBlancoMain = folderDirBlanco
                                        .getFolder("main");
                                // XV͕sv
                                if (folderDirBlancoMain.exists() == false) {
                                    folderDirBlancoMain.create(true, true,
                                            workbenchMonitor);
                                }

                                monitor.subTask("tH_쐬: blanco/testtH_");
                                final IFolder folderDirBlancoTest = folderDirBlanco
                                        .getFolder("test");
                                // XV͕sv
                                if (folderDirBlancoTest.exists() == false) {
                                    folderDirBlancoTest.create(true, true,
                                            workbenchMonitor);
                                }

                                monitor.subTask("fBNg: e|tH_̒");

                                // e|tH_U폜܂B
                                BlancoSOAPPluginUtil.deleteFolder(ifile,
                                        workbenchMonitor, "tmp/soap/xsd");
                                BlancoSOAPPluginUtil.createFolder(ifile,
                                        workbenchMonitor, "tmp/soap/xsd");

                                final IFolder folderDirSoapXsd = BlancoSOAPPluginUtil
                                        .findFolder(ifile, workbenchMonitor,
                                                "tmp/soap/xsd");
                                folderDirSoapXsd.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                final IFolder folderDirMetaDir = BlancoSOAPPluginUtil
                                        .findFolder(ifile, workbenchMonitor,
                                                metaDir);
                                folderDirMetaDir.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);
                                final IResource[] resourcesMetaFiles = folderDirMetaDir
                                        .members();
                                for (int index = 0; index < resourcesMetaFiles.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesMetaFiles[index] instanceof IFile) {
                                        final IFile fileLookMetaFile = (IFile) resourcesMetaFiles[index];
                                        if (fileLookMetaFile.getFileExtension()
                                                .equals("xsd") == false) {
                                            // gqxsdȊÕt@C̓XLbv܂B
                                            continue;
                                        }

                                        monitor.subTask("Java\[XR[h쐬: t@C["
                                                + fileLookMetaFile.getName()
                                                + "]܂ (" + (index + 1)
                                                + "/"
                                                + resourcesMetaFiles.length
                                                + ")");
                                        final String fileName = BlancoNameUtil
                                                .trimFileExtension(fileLookMetaFile
                                                        .getName());
                                        if (fileName == null) {
                                            throw new IllegalArgumentException(
                                                    "̉ߒŉH̃t@CnullɂȂĂ܂܂BHÕt@C["
                                                            + fileName + "]");
                                        }
                                        try {
                                            // xsdt@C̑Ó؂s܂B
                                            new File2StreamWrapper(
                                                    fileLookMetaFile
                                                            .getLocation()
                                                            .toFile(), null) {
                                                protected void process(
                                                        InputStream inStream,
                                                        OutputStream outStreamIgnore)
                                                        throws Exception {
                                                    new BlancoXsdXsdValidator()
                                                            .process(inStream,
                                                                    fileName);
                                                }
                                            }.run();

                                            // ValueObject`t@C𐶐܂B
                                            new BlancoXsdXsd2ValueObject()
                                                    .process(
                                                            fileLookMetaFile
                                                                    .getLocation()
                                                                    .toFile(),
                                                            folderDirSoapXsd
                                                                    .getLocation()
                                                                    .toFile());
                                        } catch (IllegalArgumentException ex) {
                                            BlancoSOAPPlugin.log(ex);
                                            throw new IllegalArgumentException(

                                                    "t@C["
                                                            + fileLookMetaFile
                                                                    .getName()
                                                            + "]ValueObjectɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        try {
                                            final ComplexTypeStructure[] result = new ComplexTypeStructure[1];

                                            // Castorp̐ݒt@C𐶐܂B
                                            final File fileCastorTarget = new File(
                                                    folderDirSoapXsd
                                                            .getLocation()
                                                            .toFile()
                                                            .getAbsolutePath()
                                                            + "/"
                                                            + fileName
                                                            + ".castorxml");
                                            final InputStream inStream = fileLookMetaFile
                                                    .getContents();
                                            try {
                                                new File2StreamWrapper(null,
                                                        fileCastorTarget) {
                                                    protected void process(
                                                            InputStream inStreamIgnore,
                                                            OutputStream outStream)
                                                            throws Exception {
                                                        result[0] = new BlancoXsdXsd2Castor()
                                                                .process(
                                                                        inStream,
                                                                        fileName,
                                                                        outStream);
                                                    }
                                                }.run();
                                            } finally {
                                                // OōXg[͊Oŕ܂B
                                                inStream.close();
                                            }
                                            if (AbstractActionExternalOption
                                                    .isUseExternalOption()) {
                                                // OIvV01𗘗pĂꍇɂ́AblancotH_castorpݒt@CxsdRs[
                                                final String targetFilenameWithoutExt = folderDirBlancoMain
                                                        .getLocation().toFile()
                                                        .getAbsolutePath()
                                                        + "/"
                                                        + result[0]
                                                                .getTypeOfJava()
                                                                .replace('.',
                                                                        '/');
                                                BlancoFileUtil
                                                        .copy(
                                                                fileCastorTarget,
                                                                new File(
                                                                        targetFilenameWithoutExt
                                                                                + ".xml"));
                                                BlancoFileUtil
                                                        .copy(
                                                                fileLookMetaFile
                                                                        .getLocation()
                                                                        .toFile(),
                                                                new File(
                                                                        targetFilenameWithoutExt
                                                                                + ".xsd"));
                                            }
                                        } catch (IllegalArgumentException ex) {
                                            BlancoSOAPPlugin.log(ex);
                                            throw new IllegalArgumentException(
                                                    "t@C["
                                                            + fileLookMetaFile
                                                                    .getName()
                                                            + "]CastorɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        try {
                                            // xsdT^IXMLf[^𐶐܂B
                                            new BlancoXsdXsd2TemplateXml()
                                                    .process(
                                                            fileName,
                                                            fileName,
                                                            fileLookMetaFile
                                                                    .getLocation()
                                                                    .toFile(),
                                                            new File(
                                                                    folderDirSoapXsd
                                                                            .getLocation()
                                                                            .toFile()
                                                                            .getAbsolutePath()
                                                                            + "/"
                                                                            + fileName
                                                                            + ".templatexml"));
                                        } catch (IllegalArgumentException ex) {
                                            BlancoSOAPPlugin.log(ex);
                                            throw new IllegalArgumentException(
                                                    "t@C["
                                                            + fileLookMetaFile
                                                                    .getName()
                                                            + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        try {
                                            // xsdT^ICastorJUnit𐶐܂B
                                            new BlancoXsdXsd2CastorTest()
                                                    .process(
                                                            new File(
                                                                    folderDirSoapXsd
                                                                            .getLocation()
                                                                            .toFile()
                                                                            .getAbsolutePath()
                                                                            + "/"
                                                                            + fileName
                                                                            + ".templatexml"),
                                                            fileLookMetaFile
                                                                    .getLocation()
                                                                    .toFile(),
                                                            folderDirBlanco
                                                                    .getLocation()
                                                                    .toFile()
                                                                    .getAbsolutePath());
                                        } catch (IllegalArgumentException ex) {
                                            BlancoSOAPPlugin.log(ex);
                                            throw new IllegalArgumentException(
                                                    "t@C["
                                                            + fileLookMetaFile
                                                                    .getName()
                                                            + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        if (IS_DEBUG_SLOW) {
                                            Thread.sleep(1000);
                                        }
                                    }
                                }

                                monitor.subTask("Java\[XR[h쐬");
                                monitor.worked(1);

                                folderDirSoapXsd.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);
                                final IResource[] resourcesValueObject = folderDirSoapXsd
                                        .members();
                                for (int index = 0; index < resourcesValueObject.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesValueObject[index] instanceof IFile) {
                                        final IFile fileLookValueObjectMeta = (IFile) resourcesValueObject[index];
                                        if (fileLookValueObjectMeta
                                                .getFileExtension().equals(
                                                        "blancovalueobject") == false) {
                                            // gqblancovalueobjectȊÕt@C̓XLbv܂B
                                            continue;
                                        }

                                        monitor.subTask("Java\[XR[h쐬: t@C["
                                                + fileLookValueObjectMeta
                                                        .getName()
                                                + "]܂ (" + (index + 1)
                                                + "/"
                                                + resourcesMetaFiles.length
                                                + ")");
                                        try {
                                            new BlancoValueObjectXml2JavaClass()
                                                    .process(
                                                            fileLookValueObjectMeta
                                                                    .getLocation()
                                                                    .toFile(),
                                                            folderDirBlanco
                                                                    .getLocation()
                                                                    .toFile());
                                        } catch (IllegalArgumentException ex) {
                                            BlancoSOAPPlugin.log(ex);
                                            throw new IllegalArgumentException(
                                                    "t@C["
                                                            + fileLookValueObjectMeta
                                                                    .getName()
                                                            + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        if (IS_DEBUG_SLOW) {
                                            Thread.sleep(1000);
                                        }
                                    }
                                }

                                if (AbstractActionExternalOption
                                        .isUseExternalOption()) {
                                    // OIvV01̃LbN
                                    processExternalProgram(monitor,
                                            resourcesMetaFiles);
                                }

                                monitor.subTask("tH_XV: blancotH_XV");
                                monitor.worked(1);

                                folderDirBlanco.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                folderDirSoapXsd.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                if (IS_DEBUG_SLOW) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }

                        /**
                         * OIvV01̎ss܂B
                         * 
                         * @param monitor
                         * @param resourcesMeta
                         * @param blancoTargetDirectory
                         * @throws Exception
                         */
                        private void processExternalProgram(
                                final IProgressMonitor monitor,
                                final IResource[] resourcesMeta)
                                throws Exception {
                            // blancotH_΍ŏɍ쐬܂B
                            final IFolder folderTargetDirectoryBlanco = ifile
                                    .getProject().getFolder("blanco");
                            if (ifile.getProject().getFolder(metaDir).exists() == false) {
                                folderTargetDirectoryBlanco.create(true, true,
                                        workbenchMonitor);
                            }
                            final File blancoTargetDirectory = folderTargetDirectoryBlanco
                                    .getLocation().toFile();
                            final File tempDirectory = ifile.getProject()
                                    .getFolder("tmp").getLocation().toFile();

                            // yOIvV01z
                            // OIvV01̃LbN:wx
                            final AbstractActionExternalOption actionExternalOption = AbstractActionExternalOption
                                    .newInstance();
                            actionExternalOption.open();

                            for (int index = 0; index < resourcesMeta.length; index++) {
                                if (monitor.isCanceled()) {
                                    return;
                                }

                                if (resourcesMeta[index] instanceof IFile) {
                                    IFile fileLook = (IFile) resourcesMeta[index];
                                    if (fileLook.getFileExtension().equals(
                                            "wsdl") == false) {
                                        // gqwsdlȊÕt@C̓XLbv܂B
                                        continue;
                                    }

                                    monitor.subTask("Java\[XR[h쐬: t@C["
                                            + fileLook.getName() + "]܂ ("
                                            + (index + 1) + "/"
                                            + resourcesMeta.length + ")");
                                    try {
                                        // yOIvV01z
                                        // OIvV01̃LbN:wt@CƂ̏x
                                        actionExternalOption
                                                .processFile(
                                                        fileLook.getLocation()
                                                                .toFile(),
                                                        tempDirectory,
                                                        blancoTargetDirectory);
                                    } catch (IllegalArgumentException ex) {
                                        BlancoSOAPPlugin.log(ex);
                                        throw new IllegalArgumentException(

                                                "t@C["
                                                        + fileLook.getName()
                                                        + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                        + ex.toString());
                                    }

                                    if (IS_DEBUG_SLOW) {
                                        Thread.sleep(1000);
                                    }
                                }
                            }

                            // yOIvV01z
                            // OIvV01̃LbN:wIx
                            actionExternalOption
                                    .close(folderTargetDirectoryBlanco
                                            .getLocation().toFile());
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoSOAPPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        }
    }
}