/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.soap.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.plugin.soap.BlancoSOAPPlugin;
import blanco.plugin.soap.editors.BlancoSOAPPluginUtil;
import blanco.sax.BlancoSaxXml2Handler;
import blanco.sax.BlancoSaxXml2HandlerTest;
import blanco.sax.BlancoSaxXml2Serializer;
import blanco.sax.BlancoSaxXml2SerializerTest;

/**
 * blancoConcreteSax쓮ANV
 * 
 * @author IGA Tosiki
 */
public class BlancoSAXGenerateAction implements IObjectActionDelegate {

    private ISelection selection;

    /**
     * GUIfobOp̒ᑬ[hBʏfalseŉ^p܂B
     */
    private static final boolean IS_DEBUG_SLOW = false;

    public BlancoSAXGenerateAction() {
        super();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Shell shell = new Shell();

        if (selection instanceof StructuredSelection) {
            StructuredSelection look = (StructuredSelection) selection;
            Object objectLook = look.getFirstElement();
            if (objectLook instanceof IFile) {
                try {
                    final StringBuffer metaDir = new StringBuffer();
                    final StringBuffer metaPackage = new StringBuffer();
                    InputStream inStream = null;
                    try {
                        inStream = ((IFile) objectLook).getContents();

                        TransformerFactory tf = TransformerFactory
                                .newInstance();
                        Transformer transformer = tf.newTransformer();
                        transformer.transform(new StreamSource(inStream),
                                new SAXResult(new ContentHandler() {
                                    public void setDocumentLocator(Locator arg0) {
                                    }

                                    public void startDocument()
                                            throws SAXException {
                                    }

                                    public void endDocument()
                                            throws SAXException {
                                    }

                                    public void startPrefixMapping(String arg0,
                                            String arg1) throws SAXException {
                                    }

                                    public void endPrefixMapping(String arg0)
                                            throws SAXException {
                                    }

                                    public void startElement(String arg0,
                                            String arg1, String arg2,
                                            Attributes attributes)
                                            throws SAXException {
                                        if (arg1.equals("blancosoap")) {
                                            for (int index = 0; index < attributes
                                                    .getLength(); index++) {
                                                String localName = attributes
                                                        .getLocalName(index);
                                                String value = attributes
                                                        .getValue(index);
                                                if (localName
                                                        .equals("metasaxdir")) {
                                                    metaDir.append(value);
                                                }
                                                if (localName
                                                        .equals("metasaxpackage")) {
                                                    metaPackage.append(value);
                                                }
                                            }
                                        }
                                    }

                                    public void endElement(String arg0,
                                            String arg1, String arg2)
                                            throws SAXException {
                                    }

                                    public void characters(char[] arg0,
                                            int arg1, int arg2)
                                            throws SAXException {
                                    }

                                    public void ignorableWhitespace(
                                            char[] arg0, int arg1, int arg2)
                                            throws SAXException {
                                    }

                                    public void processingInstruction(
                                            String arg0, String arg1)
                                            throws SAXException {
                                    }

                                    public void skippedEntity(String arg0)
                                            throws SAXException {
                                    }
                                }));
                    } catch (Exception e) {
                        // ŏIhqC
                        e.printStackTrace();
                        throw new InvocationTargetException(e, e.toString());
                    } catch (Error e) {
                        // ŏIhqC
                        e.printStackTrace();
                        throw new InvocationTargetException(e, e.toString());
                    } finally {
                        try {
                            if (inStream != null) {
                                inStream.close();
                            }
                        } catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }

                    System.out.println("metaDir:" + metaDir.toString());
                    if (metaDir.length() > 0) {
                        process((IFile) objectLook, shell, null, metaDir
                                .toString(), metaPackage.toString());
                    }
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    /**
     * blancoSOAP\[XR[hs܂B
     * 
     * @param input
     * @return
     * @throws InvocationTargetException
     * @throws InterruptedException
     */
    public static final void process(final IFile ifile, final Shell shell,
            final IProgressMonitor workbenchMonitor, final String metaDir,
            final String metaPackage) throws InvocationTargetException,
            InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask("blancoSOAP: SAX֘A", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                // ܂ŏɃtH_邾܂B
                                monitor.subTask("tH_쐬: blancotH_");
                                final IFolder folderDirBlanco = ifile
                                        .getProject().getFolder("blanco");
                                folderDirBlanco.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);
                                if (folderDirBlanco.exists() == false) {
                                    folderDirBlanco.create(true, true,
                                            workbenchMonitor);
                                }

                                monitor.subTask("tH_쐬: blanco/maintH_");
                                final IFolder folderDirBlancoMain = folderDirBlanco
                                        .getFolder("main");
                                folderDirBlancoMain.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);
                                if (folderDirBlancoMain.exists() == false) {
                                    folderDirBlancoMain.create(true, true,
                                            workbenchMonitor);
                                }

                                final File fileDirBlanco = folderDirBlanco
                                        .getLocation().toFile();

                                monitor.subTask("SAX: Java\[XR[h쐬");
                                monitor.worked(1);

                                final IFolder folderDirMetaDir = BlancoSOAPPluginUtil
                                        .findFolder(ifile, workbenchMonitor,
                                                metaDir);
                                folderDirMetaDir.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);
                                final IResource[] resourcesMetaFiles = folderDirMetaDir
                                        .members();
                                for (int index = 0; index < resourcesMetaFiles.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesMetaFiles[index] instanceof IFile) {
                                        final IFile fileLookMetaFile = (IFile) resourcesMetaFiles[index];
                                        if (fileLookMetaFile.getFileExtension()
                                                .equals("xml") == false) {
                                            // gqxmlȊÕt@C̓XLbv܂B
                                            continue;
                                        }

                                        monitor
                                                .subTask("SAX: Java\[XR[h쐬: t@C["
                                                        + fileLookMetaFile
                                                                .getName()
                                                        + "]܂ ("
                                                        + (index + 1)
                                                        + "/"
                                                        + resourcesMetaFiles.length
                                                        + ")");
                                        final String fileName = BlancoNameUtil
                                                .trimFileExtension(fileLookMetaFile
                                                        .getName());
                                        try {
                                            new BlancoSaxXml2Handler()
                                                    .process(
                                                            fileLookMetaFile
                                                                    .getLocation()
                                                                    .toFile(),
                                                            fileDirBlanco
                                                                    .getAbsolutePath(),
                                                            metaPackage,
                                                            BlancoNameAdjuster
                                                                    .toClassName(fileName)
                                                                    + "Handler");
                                            new BlancoSaxXml2Serializer()
                                                    .process(
                                                            fileLookMetaFile
                                                                    .getLocation()
                                                                    .toFile(),
                                                            fileDirBlanco
                                                                    .getAbsolutePath(),
                                                            metaPackage,
                                                            BlancoNameAdjuster
                                                                    .toClassName(fileName)
                                                                    + "Serializer");
                                            // eXgNX܂B
                                            new BlancoSaxXml2HandlerTest()
                                                    .process(
                                                            fileLookMetaFile
                                                                    .getLocation()
                                                                    .toFile(),
                                                            fileDirBlanco
                                                                    .getAbsolutePath(),
                                                            metaPackage,
                                                            BlancoNameAdjuster
                                                                    .toClassName(fileName)
                                                                    + "Handler");
                                            new BlancoSaxXml2SerializerTest()
                                                    .process(
                                                            fileLookMetaFile
                                                                    .getLocation()
                                                                    .toFile(),
                                                            fileDirBlanco
                                                                    .getAbsolutePath(),
                                                            metaPackage,
                                                            BlancoNameAdjuster
                                                                    .toClassName(fileName)
                                                                    + "Serializer");
                                        } catch (IllegalArgumentException ex) {
                                            throw new IllegalArgumentException(

                                                    "t@C["
                                                            + fileLookMetaFile
                                                                    .getName()
                                                            + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        if (IS_DEBUG_SLOW) {
                                            Thread.sleep(1000);
                                        }

                                    }
                                }

                                monitor.subTask("tH_XV: blancotH_XV");
                                monitor.worked(1);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                folderDirBlanco.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                if (IS_DEBUG_SLOW) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoSOAPPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        }
    }
}