/*
 * blanco Framework
 * Copyright(C) 2006-2008 NTT DATA BUSINESS BRAINS CORPORATION.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.soap.terasoluna.rich;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

import javax.xml.transform.TransformerException;

import blanco.commons.io.Native2AsciiWriter;
import blanco.wsdl.parser.BlancoWsdlParser;
import blanco.wsdl.valueobject.BlancoWsdlWebService;
import blanco.wsdl.valueobject.BlancoWsdlWebServiceOperation;

/**
 * WSDLTERASOLUNApvpeBt@CNXB
 * 
 * ̃NX́AblancoSOAPTERASOLUNA RichΉg̈ꕔƂȂ܂B
 * 
 * @author IGA Tosiki
 * @version 1.0
 */
public class TerasolunaBLogicWsdl2NamespacesProperties {
    /**
     * vpeBt@C̃t@CB
     */
    public static final String FILE_NAME = "namespaces.properties";

    /**
     * ̓NX̃XgێB
     */
    private final ArrayList listInputClass = new ArrayList();

    /**
     * WSDLt@C̉͌
     */
    private BlancoWsdlWebService fWsdl = null;

    /**
     * W܂Ƃ propertiest@C𐶐B
     * 
     * t@C native2asciiꂽ̏Ԃō쐬B
     * 
     * @param outStream
     *            propertiest@Co͂Xg[B
     * @throws IOException
     *             o͗OꍇB
     */
    public void generate(final OutputStream outStream) throws IOException {
        final Native2AsciiWriter writer = new Native2AsciiWriter(
                new BufferedWriter(new OutputStreamWriter(outStream, "8859_1")));
        try {
            writer
                    .writeComment("############################################################################");
            writer.writeComment(" d|MNX}bsOݒ");
            writer
                    .writeComment("############################################################################");
            for (int index = 0; index < listInputClass.size(); index++) {
                String[] value = (String[]) listInputClass.get(index);
                writer.writeProperty(value[0], value[1]);
            }
        } finally {
            writer.close();
        }
    }

    /**
     * ^ꂽWSDLt@C͂B
     * 
     * WSDLt@C XSDt@Cǂݍ݁A邢͖OԂLȂǂ̏sB
     * 
     * @param fileSource
     *            WSDLt@C
     * @throws IOException
     *             o͗OꍇB
     * @throws TransformerException
     *             XMLϊG[ꍇB
     */
    public void parse(final File fileSource) throws IOException,
            TransformerException {
        fWsdl = new BlancoWsdlParser().parse(fileSource);

        // ̂̂operationɑ΂ďsB
        final ArrayList listOperation = fWsdl.getOperationList();
        for (int indexOperation = 0; indexOperation < listOperation.size(); indexOperation++) {
            final BlancoWsdlWebServiceOperation operation = (BlancoWsdlWebServiceOperation) listOperation
                    .get(indexOperation);

            // w肳ꂽoperation̏LB
            remenberOperation(operation);
        }
    }

    /**
     * WSDLoperationɂċLsB
     * 
     * WSDLoperationɂċLsBLoperation
     * properties쐬邪ApropertiesɊւ閼Oό`ȂǂsB
     * 
     * @param operation
     *            WSDL̃Iy[V
     * @throws IOException
     *             o͗OꍇB
     */
    private void remenberOperation(final BlancoWsdlWebServiceOperation operation)
            throws IOException {
        final String[] valueNameSpace = new String[] {
                operation.getInput().getTypeOfJava() + ".Namespace",
                operation.getInput().getTargetNamespace() };
        listInputClass.add(valueNameSpace);
    }
}
