/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xsd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.xsd.concretesax.CastorMarshalXmlSerializer;
import blanco.xsd.parser.BlancoXsdParser;
import blanco.xsd.parser.ComplexTypeFieldStructure;
import blanco.xsd.parser.ComplexTypeStructure;

/**
 * XSD͂ƂCastorXMLݒt@C쐬܂B<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoXsdXsd2Castor {
    /**
     * ς̌^L}bvB
     */
    private HashMap processedType = new HashMap();

    /**
     * ̓Xg[̓eƂɁACastor̂߂̐ݒt@C𐶐܂B
     * 
     * @param inStream
     *            XSD̓Xg[
     * @param targetName
     *            ^[QbgƂȂ^
     * @param outStream
     *            o̓Xg[
     * @return RvbNX^̏
     * @throws IOException
     *             o͗Oꍇ
     * @throws TransformerException
     *             XMLϊOꍇ
     * @throws SAXException
     *             SAXOꍇ
     */
    public ComplexTypeStructure process(final InputStream inStream,
            final String targetName, final OutputStream outStream)
            throws IOException, TransformerException, SAXException {
        // xsdp[X܂B
        BlancoXsdParser parser = new BlancoXsdParser();
        final ComplexTypeStructure type = parser.process(inStream, targetName);

        final CastorMarshalXmlSerializer serializer = new CastorMarshalXmlSerializer(
                outStream);
        serializer.startDocument();
        serializer.startElementMapping(type.getTargetNamespace(),
                "http://castor.exolab.org/");
        serializer.characters("\n  ");
        serializer.startElementDescription();
        serializer
                .characters("\n    blancoSOAP generated mapping file for Castor");
        serializer.characters("\n  ");
        serializer.endElementDescription();

        expandComplexType(type, serializer);

        serializer.characters("\n");
        serializer.endElementMapping();
        serializer.endDocument();

        return type;
    }

    /**
     * w肳ꂽRvbNX^`WJ܂B
     * 
     * @param type
     *            RvbNX^̏
     * @param serializer
     *            XMLt@Cւ̃VACU
     * @throws SAXException
     *             SAXOꍇ
     * @throws IOException
     *             o͗Oꍇ
     * @throws TransformerConfigurationException
     *             XMLϊOꍇ
     */
    private void expandComplexType(final ComplexTypeStructure type,
            final CastorMarshalXmlSerializer serializer) throws SAXException,
            IOException, TransformerConfigurationException {

        if (processedType.get(type.getName()) != null) {
            // łɏς݂łB
            return;
        }
        processedType.put(type.getName(), type);

        // ܂ɎQƂĂNXWJ܂B
        for (int index = 0; index < type.getListField().size(); index++) {
            final ComplexTypeFieldStructure field = (ComplexTypeFieldStructure) type
                    .getListField().get(index);

            if (field.getTypeStructure() instanceof ComplexTypeStructure) {
                expandComplexType((ComplexTypeStructure) field
                        .getTypeStructure(), serializer);
            }
        }

        serializer.characters("\n  ");
        serializer.startElementClass(type.getPackageOfJava() + "."
                + BlancoNameAdjuster.toClassName(type.getName()));
        serializer.characters("\n    ");
        serializer.startElementDescription();
        serializer.characters("\n      ̃t@CxsdꂽCastor`t@CłB");
        serializer.characters("\n    ");
        serializer.endElementDescription();
        serializer.characters("\n    ");
        serializer.startElementMapTo(type.getName(), type.getTargetNamespace());
        serializer.endElementMapTo();

        for (int index = 0; index < type.getListField().size(); index++) {
            final ComplexTypeFieldStructure field = (ComplexTypeFieldStructure) type
                    .getListField().get(index);

            serializer.characters("\n    ");
            // z^ǂ`FbN܂B
            final boolean isArray = BlancoXsdUtil.isMaxOccursArray(field
                    .getMaxOccurs());
            serializer.startElementField(BlancoNameAdjuster.toClassName(field
                    .getFieldName()), field.getTypeStructure()
                    .getTypeOfJavaWithoutArray(), (isArray ? "array" : null));

            serializer.characters("\n      ");
            serializer.startElementBindXml(field.getFieldName(), "element");
            serializer.endElementBindXml();

            serializer.characters("\n    ");
            serializer.endElementField();
            serializer.characters("\n");
        }
        serializer.characters("  ");
        serializer.endElementClass();
    }
}