/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobject.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.commons.util.BlancoStringUtil;
import blanco.test.valueobject.BlancoValueObjectXml2JUnit;
import blanco.valueobject.BlancoValueObjectMeta2Xml;
import blanco.valueobject.BlancoValueObjectXml2JavaClass;
import blanco.valueobject.resourcebundle.BlancoValueObjectResourceBundle;

public class BlancoValueObjectTask extends AbstractBlancoValueObjectTask {
    private final BlancoValueObjectResourceBundle bundle = new BlancoValueObjectResourceBundle();

    protected void process() throws IllegalArgumentException {
        try {
            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg[" + getMetadir()
                        + "]݂܂B");
            }

            // e|fBNg쐬B
            new File(getTmpdir() + bundle.getTargetDirectory()).mkdirs();

            new BlancoValueObjectMeta2Xml().processDirectory(fileMetadir,
                    getTmpdir() + bundle.getTargetDirectory());

            // XMLꂽ^t@CValueObject𐶐
            // ŏɃe|tH_𑖍
            final File[] fileMeta2 = new File(getTmpdir()
                    + bundle.getTargetDirectory()).listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                final BlancoValueObjectXml2JavaClass xml2JavaClass = new BlancoValueObjectXml2JavaClass();
                xml2JavaClass.setNameAdjust(BlancoStringUtil.null2Blank(
                        getNameAdjust()).equals("true"));
                xml2JavaClass.process(fileMeta2[index],
                        new File(getTargetdir()));

                // P̎R[h
                if (getJunit().equals("true")) {
                    final BlancoValueObjectXml2JUnit xml2JUnit = new BlancoValueObjectXml2JUnit();
                    xml2JUnit.setNameAdjust(BlancoStringUtil.null2Blank(
                            getNameAdjust()).equals("true"));
                    xml2JUnit.process(fileMeta2[index],
                            new File(getTargetdir()));
                }
            }

            // Ƀ^fBNgƂĎw肳ĂfBNg𑖍
            final File[] fileMeta3 = fileMetadir.listFiles();
            for (int index = 0; index < fileMeta3.length; index++) {
                if (fileMeta3[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                final BlancoValueObjectXml2JavaClass xml2JavaClass = new BlancoValueObjectXml2JavaClass();
                xml2JavaClass.setNameAdjust(BlancoStringUtil.null2Blank(
                        getNameAdjust()).equals("true"));
                xml2JavaClass.process(fileMeta3[index],
                        new File(getTargetdir()));

                // P̎R[h
                if (getJunit().equals("true")) {
                    final BlancoValueObjectXml2JUnit xml2JUnit = new BlancoValueObjectXml2JUnit();
                    xml2JUnit.setNameAdjust(BlancoStringUtil.null2Blank(
                            getNameAdjust()).equals("true"));
                    xml2JUnit.process(fileMeta2[index],
                            new File(getTargetdir()));
                }
            }
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw e;
        }
    }
}
