/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.rss.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

import blanco.rss.core.valueobject.BlancoRss;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * RSSp[X o[IuWFNg܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoRssParser {
    private final Logger fLog = Logger.getLogger("blanco.rss.core");

    /**
     * RSSp[X o[IuWFNg܂B
     * 
     * @param argInput
     *            RSS̓̓Xg[B
     * @return o[IuWFNgꂽRSSBp[XɎsꍇɂ nullB
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͗OꍇB
     */
    public BlancoRss parse(final InputStream argInput) throws IOException,
            IllegalArgumentException {
        final BlancoXmlDocument document = new BlancoXmlUnmarshaller()
                .unmarshal(argInput);
        if (document == null) {
            return null;
        }

        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(document);

        // [g̃Ggɂ蕪B
        if ("rss".equals(elementRoot.getQName())) {
            fLog.finest("RSS ["
                    + BlancoXmlBindingUtil.getAttribute(elementRoot, "version")
                    + "]");
            return new BlancoRssRss09Parser().parse(elementRoot);
        } else if ("rdf:RDF".equals(elementRoot.getQName())) {
            fLog.finest("RDF");
            return new BlancoRssRdfParser().parse(elementRoot);
        } else {
            fLog.fine("Ή:[g[" + elementRoot.getQName() + "]");
            return null;
        }
    }
}
