package blanco.rss.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;

import junit.framework.TestCase;
import blanco.rss.core.valueobject.BlancoRss;
import blanco.rss.core.valueobject.BlancoRssItem;

public class BlancoRssParserTest extends TestCase {
    static {
        final String LOGGING_PROPERTIES_DATA = "handlers=java.util.logging.ConsoleHandler\n"
                + ".level=ALL\n"
                + "java.util.logging.ConsoleHandler.level=ALL\n"
                + "java.util.logging.ConsoleHandler.formatter=java.util.logging.SimpleFormatter";
        InputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(LOGGING_PROPERTIES_DATA
                    .getBytes("UTF-8"));
            LogManager.getLogManager().readConfiguration(inStream);
            if (inStream != null) {
                inStream.close();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testParse() throws Exception {
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(new File(
                    "test/data/idxall.rss0.9.xml")));

            final BlancoRss rss = new BlancoRssParser().parse(inStream);
            for (int index = 0; index < rss.getItems().size(); index++) {
                final BlancoRssItem item = (BlancoRssItem) rss.getItems().get(
                        index);
                System.out.println(item.getTitle());
            }
        } finally {
            if (inStream != null) {
                inStream.close();
            }
        }
        assertTrue("rss0.9͓K؂Ƀp[X", true);
    }

    public void testParse2() throws Exception {
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(new File(
                    "test/data/idxall.rss1.0.xml")));

            final BlancoRss rss = new BlancoRssParser().parse(inStream);
            for (int index = 0; index < rss.getItems().size(); index++) {
                final BlancoRssItem item = (BlancoRssItem) rss.getItems().get(
                        index);
                System.out.println(item.getTitle());
            }
        } finally {
            if (inStream != null) {
                inStream.close();
            }
        }
        assertTrue("rss1.0͓K؂Ƀp[X", true);
    }
}
