/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.rss.core;

import java.io.IOException;
import java.util.logging.Logger;

import blanco.rss.core.valueobject.BlancoRss;
import blanco.rss.core.valueobject.BlancoRssItem;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * RDFp[X o[IuWFNg܂B
 * 
 * @author IGA Tosiki
 */
class BlancoRssRdfParser {
    private final Logger fLog = Logger.getLogger("blanco.rss.core");

    /**
     * ^ꂽGgp[X܂B
     * 
     * @param argElementRoot
     *            [gGgB
     * @return o̓o[IuWFNgB
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͗OꍇB
     */
    public BlancoRss parse(final BlancoXmlElement argElementRoot)
            throws IOException, IllegalArgumentException {
        final BlancoRss outputRss = new BlancoRss();
        outputRss.setName(argElementRoot.getQName());

        for (int index = 0; index < argElementRoot.getChildNodes().size(); index++) {
            final Object objChild = argElementRoot.getChildNodes().get(index);
            if (objChild instanceof BlancoXmlElement == false) {
                continue;
            }

            final BlancoXmlElement elementChild = (BlancoXmlElement) objChild;

            if (elementChild.getQName().equals("channel")) {
                parseChannel(elementChild, outputRss);
            } else if (elementChild.getQName().equals("item")) {
                parseItem(elementChild, outputRss);
            } else {
                fLog.fine("Ή:channelitemȊO͖Ή:" + elementChild.getQName());
            }
        }

        return outputRss;
    }

    /**
     * channelGgp[X܂B
     * 
     * @param argElement
     *            channelGgB
     * @param argOutputRss
     *            o̓o[IuWFNgB
     */
    private void parseChannel(final BlancoXmlElement argElement,
            final BlancoRss argOutputRss) {
        for (int indexChannel = 0; indexChannel < argElement.getChildNodes()
                .size(); indexChannel++) {
            final Object objLook = argElement.getChildNodes().get(indexChannel);
            if (objLook instanceof BlancoXmlElement == false) {
                continue;
            }

            final BlancoXmlElement eleLook = (BlancoXmlElement) objLook;
            final String text = BlancoXmlBindingUtil.getTextContent(eleLook);
            if ("title".equals(eleLook.getQName())) {
                argOutputRss.getChannel().setTitle(text);
            } else if ("link".equals(eleLook.getQName())) {
                argOutputRss.getChannel().setLink(text);
            } else if ("description".equals(eleLook.getQName())) {
                argOutputRss.getChannel().setDescription(text);
            } else if ("language".equals(eleLook.getQName())) {
                argOutputRss.getChannel().setLanguage(text);
            } else if ("copyright".equals(eleLook.getQName())) {
                argOutputRss.getChannel().setCopyright(text);
            } else if ("dc:date".equals(eleLook.getQName())) {
                // TODO B
                System.out.println("t[" + text + "]");
            } else if ("items".equals(eleLook.getQName())) {
                // ܂B
            } else {
                fLog.fine("Ή:channel[" + eleLook.getQName() + "]");
            }
        }
    }

    /**
     * itemGgp[X܂B
     * 
     * @param argElement
     *            itemGgB
     * @param argOutputRss
     *            o̓o[IuWFNgB
     */
    private void parseItem(final BlancoXmlElement argElement,
            final BlancoRss argOutputRss) {
        final BlancoRssItem item = new BlancoRssItem();
        argOutputRss.getItems().add(item);

        for (int indexItem = 0; indexItem < argElement.getChildNodes().size(); indexItem++) {
            final Object objLook = argElement.getChildNodes().get(indexItem);
            if (objLook instanceof BlancoXmlElement == false) {
                continue;
            }
            final BlancoXmlElement eleLook = (BlancoXmlElement) objLook;
            final String text = BlancoXmlBindingUtil.getTextContent(eleLook);
            if ("title".equals(eleLook.getQName())) {
                item.setTitle(text);
            } else if ("link".equals(eleLook.getQName())) {
                item.setLink(text);
            } else if ("description".equals(eleLook.getQName())) {
                item.setDescription(text);
            } else if ("dc:date".equals(eleLook.getQName())) {
                // TODO B
                System.out.println("t[" + text + "]");
            } else {
                fLog.fine("Ή:item[" + eleLook.getQName() + "]");
            }
        }
    }
}
