/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.text.converter;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.text.converter.valueobject.BlancoTextConverterSrcTxtChapterStructure;
import blanco.text.converter.valueobject.BlancoTextConverterSrcTxtStructure;

/**
 * u\[XeLXgvp[X܂B
 */
public class BlancoTextConverterSrcTxtParser {
    public BlancoTextConverterSrcTxtStructure parse(
            final BufferedReader argReader) throws IOException {
        final BlancoTextConverterSrcTxtStructure structure = new BlancoTextConverterSrcTxtStructure();

        boolean isBodyStarted = false;

        final StringBuffer strbuf = new StringBuffer();
        for (;;) {
            final String line = argReader.readLine();
            if (line == null) {
                break;
            }

            if (isBodyStarted == false) {
                // s̊Jn̏ꍇɂ̂ݔf܂B
                //  : ̐擪󔒂͖悤ɕύXB
                if (line.startsWith("Subject:")) {
                    structure.setSubject(line.substring("Subject:".length())
                            .trim());
                } else if (line.startsWith("Description:")) {
                    structure.setDescription(line.substring(
                            "Description:".length()).trim());
                } else if (line.startsWith("Keywords:")) {
                    structure.setKeywords(line.substring("Keywords:".length())
                            .trim());
                } else if (line.startsWith("Date:")) {
                    try {
                        // final SimpleDateFormat sdFormat = new
                        // SimpleDateFormat(
                        // "yyyy-MM-dd");
                        final SimpleDateFormat sdFormat = new SimpleDateFormat(
                                "yyyy-MM-dd HH:mm:ss");
                        structure.setDate(sdFormat.parse(line.substring(
                                "Date:".length()).trim()));
                    } catch (ParseException e) {
                        try {
                            final SimpleDateFormat sdFormat = new SimpleDateFormat(
                                    "yyyy-MM-dd");
                            structure.setDate(sdFormat.parse(line.substring(
                                    "Date:".length()).trim()));
                        } catch (ParseException e1) {
                            // ͂△Ă܂܂B
                            e1.printStackTrace();
                        }

                    }
                } else if (line.trim().length() == 0) {
                    // {fB̈̊JnB
                    isBodyStarted = true;
                } else {
                    //  Ă͂Ȃ܂B
                    System.out.println("p[XɎs[" + line + "]B܂B");
                }
            } else {
                // {fB̈łB
                // \̉͂Ȃ܂B

                // TODO ܂ [[]]̉͂Ȃ܂BdvB

                if (line.length() > 1 && line.charAt(0) != ' ') {
                    // 1ڂ當΃^CgB
                    writeChapter(line, 0, strbuf, structure);
                } else if (line.length() > 2 && line.charAt(0) == ' '
                        && line.charAt(1) != ' ') {
                    writeChapter(line, 1, strbuf, structure);
                } else if (line.length() > 3 && line.charAt(0) == ' '
                        && line.charAt(1) == ' ' && line.charAt(2) != ' ') {
                    writeChapter(line, 2, strbuf, structure);
                } else if (line.length() > 4 && line.charAt(0) == ' '
                        && line.charAt(1) == ' ' && line.charAt(2) == ' '
                        && line.charAt(3) != ' ') {
                    writeChapter(line, 3, strbuf, structure);
                } else {
                    if (line.trim().length() == 0) {
                        // słB
                        flushStringLine(strbuf, structure);
                    } else {
                        // ʏ̍słB

                        if (strbuf.length() > 0) {
                            strbuf.append("<br>\n");
                        }

                        if (line.startsWith("    ") == false) {
                            throw new IllegalArgumentException("͖[" + line
                                    + "]");
                        }

                        // ̎_ŃGR[hĂi[܂B
                        strbuf.append(BlancoJavaSourceUtil
                                .escapeStringAsJavaDoc(line.substring(4)));
                    }
                }
            }
        }

        flushStringLine(strbuf, structure);

        return structure;
    }

    private void writeChapter(final String line, final int level,
            final StringBuffer strbuf,
            final BlancoTextConverterSrcTxtStructure structure) {
        flushStringLine(strbuf, structure);

        String lineActual = line.substring(level);
        if (lineActual.startsWith("") || lineActual.startsWith("")
                || lineActual.startsWith("") || lineActual.startsWith("")) {
            lineActual = lineActual.substring(1);
        }

        final BlancoTextConverterSrcTxtChapterStructure chapter = new BlancoTextConverterSrcTxtChapterStructure();
        chapter.setLevel(level);
        chapter.setLine(lineActual);
        structure.getLineList().add(chapter);
    }

    private void flushStringLine(final StringBuffer strbuf,
            final BlancoTextConverterSrcTxtStructure structure) {
        if (strbuf.length() > 0) {
            structure.getLineList().add(strbuf.toString());
            strbuf.setLength(0);
        }
    }
}
