/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.text.converter;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

/**
 * u\[XeLXgvp[X܂B
 */
public abstract class BlancoTextConverterSrcTxtCmd {
    public final void execute(final Reader reader, final Writer writer)
            throws IOException {
        int startCounter = 0;
        for (;;) {
            final int iRead = reader.read();
            if (iRead < 0) {
                break;
            }

            if (iRead == '[') {
                startCounter++;
                if (startCounter >= 2) {
                    // R}hJnB
                    startCounter = 0;
                    parseCommand(reader, writer);
                } else {
                    // ȂB
                }
            } else {
                if (startCounter > 0) {
                    // ߂ĂAoB
                    for (; startCounter > 0; startCounter--) {
                        writer.write('[');
                    }
                }

                writer.write(iRead);
            }
        }
    }

    /**
     * [[ŃR}hJnꂽƔfƂɓĂ܂B
     * 
     * @param reader
     * @param writer
     * @throws IOException
     */
    private void parseCommand(final Reader reader, final Writer writer)
            throws IOException {
        final StringBuffer strbuf = new StringBuffer();
        int endCounter = 0;
        for (;;) {
            final int iRead = reader.read();
            if (iRead < 0) {
                break;
            }

            if (iRead == ']') {
                endCounter++;
                if (endCounter >= 2) {
                    // R}hIB
                    break;
                } else {
                    // ȂB
                }
            } else {
                if (endCounter > 0) {
                    // ߂ĂAoB
                    for (; endCounter > 0; endCounter--) {
                        strbuf.append(']');
                    }
                }
                strbuf.append((char) iRead);
            }
        }

        if (processCommand(strbuf, writer)) {
            // ̂Ō㑱͕svB
        } else {
            // oĂ߂܂B
            writer.write("[[");
            writer.write(strbuf.toString());
            writer.write("]]");
        }
    }

    /**
     * ̓IȏB
     * 
     * @param strbuf
     * @param writer
     * @return ̃R}htrueBȂfalseB
     * @throws IOException
     */
    abstract boolean processCommand(final StringBuffer strbuf,
            final Writer writer) throws IOException;
}
