/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xml.bind;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import blanco.xml.bind.valueobject.BlancoXmlDocument;

/**
 * XMLJavaIuWFNg𐶐܂B
 * 
 * ̃NX XML/o[IuWFNg}bsO (X/O}bsO) blancoXmlBinding ̈ꕔłB
 * 
 * @author IGA Tosiki
 */
public class BlancoXmlUnmarshaller {
    /**
     * XMLJavaIuWFNg𐶐܂B
     * 
     * Ql:
     * http://java.sun.com/webservices/docs/1.6/api/javax/xml/bind/Unmarshaller.html
     * 
     * @param fileInput
     *            XMLt@CB
     * @return blancoXmlƂẴIuWFNgB
     */
    public BlancoXmlDocument unmarshal(final File fileInput) {
        if (fileInput.exists() == false) {
            throw new IllegalArgumentException("BlancoXmlUnmarshaller: t@C["
                    + fileInput.getAbsolutePath() + "]͌܂B");
        }
        if (fileInput.isDirectory()) {
            throw new IllegalArgumentException("BlancoXmlUnmarshaller: t@C["
                    + fileInput.getAbsolutePath() + "]̓fBNgłB");
        }
        if (fileInput.canRead() == false) {
            throw new IllegalArgumentException("BlancoXmlUnmarshaller: t@C["
                    + fileInput.getAbsolutePath() + "]͓ǂݍ݂ł܂B");
        }

        InputStream inStream = null;

        try {
            inStream = new BufferedInputStream(new FileInputStream(fileInput));

            return unmarshal(inStream);
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshaller: ɓo͗O܂B" + e.toString());
        } finally {
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException(
                            "BlancoXmlUnmarshaller: ɓo͗O܂B"
                                    + e.toString());
                }
            }
        }
    }

    /**
     * XMLJavaIuWFNg𐶐܂B
     * 
     * Ql:
     * http://java.sun.com/webservices/docs/1.6/api/javax/xml/bind/Unmarshaller.html
     * 
     * @param inStream
     *            XML̓Xg[B
     * @return blancoXmlƂẴIuWFNgB
     */
    public BlancoXmlDocument unmarshal(final InputStream inStream) {
        if (inStream == null) {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshaller: ̓Xg[null^܂B");
        }

        final BlancoXmlUnmarshallerContentHandler handler = new BlancoXmlUnmarshallerContentHandler();

        // XMLReaderx[Xł JDK 1.4.2œ삵܂łB{v_Ngł̓gXtH[}[x[XƂ܂B
        final SAXResult result = new SAXResult(handler);
        result.setHandler(handler);
        result.setLexicalHandler(handler);

        try {
            final TransformerFactory tf = TransformerFactory.newInstance();
            final Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inStream), result);
        } catch (TransformerException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshaller: XMLϊO܂B" + e.toString());
        } finally {
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException(
                            "BlancoXmlUnmarshaller: ɓo͗O܂B"
                                    + e.toString());
                }
            }
        }

        return handler.getDocument();
    }
}
