/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;
import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;

public class BlancoEclipsePluginGenExpandWizardPage99 {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    public final void expand(final Element elementCommon,
            final NodeList listList, final File directoryTarget) {
        final String pluginName = BlancoXmlUtil.getTextContent(elementCommon,
                "name");
        final String displayName = BlancoXmlUtil.getTextContent(elementCommon,
                "displayName");

        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");

        final String className = "Abstract"
                + BlancoNameAdjuster.toClassName(pluginName) + "WizardPage99";

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(packageName + ".wizards",
                "̃\[XR[h blanco FrameworkɂĎĂ܂B");

        fCgClass = fCgFactory.createClass(className, "");
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.setAbstract(true);

        fCgClass.getExtendClassList().add(
                fCgFactory.createType("org.eclipse.jface.wizard.WizardPage"));

        fCgSourceFile.getImportList().add("org.eclipse.swt.SWT");
        fCgSourceFile.getImportList().add("org.eclipse.swt.layout.GridLayout");
        fCgSourceFile.getImportList().add("org.eclipse.swt.widgets.Label");

        fCgSourceFile.getImportList().add(
                packageName + "." + BlancoNameAdjuster.toClassName(pluginName)
                        + "PluginConstants");

        final BlancoCgField fieldSelection = fCgFactory.createField(
                "selection", "org.eclipse.jface.viewers.ISelection", "");
        fCgClass.getFieldList().add(fieldSelection);

        {
            final BlancoCgMethod method = fCgFactory
                    .createMethod(className, "");
            fCgClass.getMethodList().add(method);
            method.setConstructor(true);
            method.getParameterList().add(
                    fCgFactory.createParameter("selection",
                            "org.eclipse.jface.viewers.ISelection", ""));

            final List listLine = method.getLineList();

            listLine.add("super(\"wizardPage\");");
            listLine.add("setTitle(\"" + displayName + "vOCpxEBU[h̊\");");
            listLine.add("this.selection = selection;");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "createControl", "");
            fCgClass.getMethodList().add(method);

            method.getParameterList().add(
                    fCgFactory.createParameter("parent",
                            "org.eclipse.swt.widgets.Composite", ""));

            final List listLine = method.getLineList();

            listLine.add("GridLayout gridLayout = new GridLayout();");
            listLine.add("gridLayout.numColumns = 1;");
            listLine.add("");
            listLine
                    .add("Composite container = new Composite(parent, SWT.NULL);");
            listLine.add("container.setLayout(gridLayout);");
            listLine.add("");
            listLine.add("new Label(container, SWT.NONE).setText(\""
                    + displayName + "vOCpxEBU[h Ŋ܂B\");");
            listLine
                    .add("new Label(container, SWT.NONE).setText(\"  1.EBU[h u"
                            + displayName + "ݒt@C GfB^v\܂B\");");
            listLine
                    .add("new Label(container, SWT.NONE).setText(\"    ̉ʂ \" + "
                            + pluginName
                            + "PluginConstants.TARGET_FILENAME + \"t@C̃GfB^vOɑ܂B\");");
            listLine
                    .add("new Label(container, SWT.NONE).setText(\"  2.ʕ\ɏ]đi߂ĂB\");");
            listLine.add("");
            listLine.add("setControl(container);");
        }

        // \[XR[hۂɐ܂B
        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }
}
