/*********************************************************************
*
*      Copyright (C) 2002 Andrew Khan
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
***************************************************************************/
package jxl.biff.formula;
/**
 * This file is generated by JLex.  Do not alter the contents of this file
 * because changes will be overridden
 */
import jxl.biff.WorkbookMethods;


class Yylex {
	private final int YY_BUFFER_SIZE = 512;
	private final int YY_F = -1;
	private final int YY_NO_STATE = -1;
	private final int YY_NOT_ACCEPT = 0;
	private final int YY_START = 1;
	private final int YY_END = 2;
	private final int YY_NO_ANCHOR = 4;
	private final int YY_BOL = 65536;
	private final int YY_EOF = 65537;

  int getPos() { return yychar ; }

  private boolean emptyString;

  private ExternalSheet externalSheet;
  private WorkbookMethods nameTable;
  void setExternalSheet(ExternalSheet es)
  {
    externalSheet = es;
  }
  void setNameTable(WorkbookMethods nt)
  {
    nameTable = nt;
  }
	private java.io.BufferedReader yy_reader;
	private int yy_buffer_index;
	private int yy_buffer_read;
	private int yy_buffer_start;
	private int yy_buffer_end;
	private char yy_buffer[];
	private int yychar;
	private int yyline;
	private boolean yy_at_bol;
	private int yy_lexical_state;

	Yylex (java.io.Reader reader) {
		this ();
		if (null == reader) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(reader);
	}

	Yylex (java.io.InputStream instream) {
		this ();
		if (null == instream) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(new java.io.InputStreamReader(instream));
	}

	private Yylex () {
		yy_buffer = new char[YY_BUFFER_SIZE];
		yy_buffer_read = 0;
		yy_buffer_index = 0;
		yy_buffer_start = 0;
		yy_buffer_end = 0;
		yychar = 0;
		yyline = 0;
		yy_at_bol = true;
		yy_lexical_state = YYINITIAL;
	}

	private boolean yy_eof_done = false;
	private final int YYSTRING = 1;
	private final int YYINITIAL = 0;
	private final int yy_state_dtrans[] = {
		0,
		32
	};
	private void yybegin (int state) {
		yy_lexical_state = state;
	}
	private int yy_advance ()
		throws java.io.IOException {
		int next_read;
		int i;
		int j;

		if (yy_buffer_index < yy_buffer_read) {
			return yy_buffer[yy_buffer_index++];
		}

		if (0 != yy_buffer_start) {
			i = yy_buffer_start;
			j = 0;
			while (i < yy_buffer_read) {
				yy_buffer[j] = yy_buffer[i];
				++i;
				++j;
			}
			yy_buffer_end = yy_buffer_end - yy_buffer_start;
			yy_buffer_start = 0;
			yy_buffer_read = j;
			yy_buffer_index = j;
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}

		while (yy_buffer_index >= yy_buffer_read) {
			if (yy_buffer_index >= yy_buffer.length) {
				yy_buffer = yy_double(yy_buffer);
			}
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}
		return yy_buffer[yy_buffer_index++];
	}
	private void yy_move_end () {
		if (yy_buffer_end > yy_buffer_start &&
		    '\n' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
		if (yy_buffer_end > yy_buffer_start &&
		    '\r' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
	}
	private boolean yy_last_was_cr=false;
	private void yy_mark_start () {
		int i;
		for (i = yy_buffer_start; i < yy_buffer_index; ++i) {
			if ('\n' == yy_buffer[i] && !yy_last_was_cr) {
				++yyline;
			}
			if ('\r' == yy_buffer[i]) {
				++yyline;
				yy_last_was_cr=true;
			} else yy_last_was_cr=false;
		}
		yychar = yychar
			+ yy_buffer_index - yy_buffer_start;
		yy_buffer_start = yy_buffer_index;
	}
	private void yy_mark_end () {
		yy_buffer_end = yy_buffer_index;
	}
	private void yy_to_mark () {
		yy_buffer_index = yy_buffer_end;
		yy_at_bol = (yy_buffer_end > yy_buffer_start) &&
		            ('\r' == yy_buffer[yy_buffer_end-1] ||
		             '\n' == yy_buffer[yy_buffer_end-1] ||
		             2028/*LS*/ == yy_buffer[yy_buffer_end-1] ||
		             2029/*PS*/ == yy_buffer[yy_buffer_end-1]);
	}
	private java.lang.String yytext () {
		return (new java.lang.String(yy_buffer,
			yy_buffer_start,
			yy_buffer_end - yy_buffer_start));
	}
	private int yylength () {
		return yy_buffer_end - yy_buffer_start;
	}
	private char[] yy_double (char buf[]) {
		int i;
		char newbuf[];
		newbuf = new char[2*buf.length];
		for (i = 0; i < buf.length; ++i) {
			newbuf[i] = buf[i];
		}
		return newbuf;
	}
	private final int YY_E_INTERNAL = 0;
	private final int YY_E_MATCH = 1;
	private java.lang.String yy_error_string[] = {
		"Error: Internal error.\n",
		"Error: Unmatched input.\n"
	};
	private void yy_error (int code,boolean fatal) {
		java.lang.System.out.print(yy_error_string[code]);
		java.lang.System.out.flush();
		if (fatal) {
			throw new Error("Fatal Error.\n");
		}
	}
	private int[][] unpackFromString(int size1, int size2, String st) {
		int colonIndex = -1;
		String lengthString;
		int sequenceLength = 0;
		int sequenceInteger = 0;

		int commaIndex;
		String workString;

		int res[][] = new int[size1][size2];
		for (int i= 0; i < size1; i++) {
			for (int j= 0; j < size2; j++) {
				if (sequenceLength != 0) {
					res[i][j] = sequenceInteger;
					sequenceLength--;
					continue;
				}
				commaIndex = st.indexOf(',');
				workString = (commaIndex==-1) ? st :
					st.substring(0, commaIndex);
				st = st.substring(commaIndex+1);
				colonIndex = workString.indexOf(':');
				if (colonIndex == -1) {
					res[i][j]=Integer.parseInt(workString);
					continue;
				}
				lengthString =
					workString.substring(colonIndex+1);
				sequenceLength=Integer.parseInt(lengthString);
				workString=workString.substring(0,colonIndex);
				sequenceInteger=Integer.parseInt(workString);
				res[i][j] = sequenceInteger;
				sequenceLength--;
			}
		}
		return res;
	}
	private int yy_acpt[] = {
		/* 0 */ YY_NOT_ACCEPT,
		/* 1 */ YY_NO_ANCHOR,
		/* 2 */ YY_NO_ANCHOR,
		/* 3 */ YY_NO_ANCHOR,
		/* 4 */ YY_NO_ANCHOR,
		/* 5 */ YY_NO_ANCHOR,
		/* 6 */ YY_NO_ANCHOR,
		/* 7 */ YY_NO_ANCHOR,
		/* 8 */ YY_NO_ANCHOR,
		/* 9 */ YY_NO_ANCHOR,
		/* 10 */ YY_NO_ANCHOR,
		/* 11 */ YY_NO_ANCHOR,
		/* 12 */ YY_NO_ANCHOR,
		/* 13 */ YY_NO_ANCHOR,
		/* 14 */ YY_NO_ANCHOR,
		/* 15 */ YY_NO_ANCHOR,
		/* 16 */ YY_NO_ANCHOR,
		/* 17 */ YY_NO_ANCHOR,
		/* 18 */ YY_NO_ANCHOR,
		/* 19 */ YY_NO_ANCHOR,
		/* 20 */ YY_NO_ANCHOR,
		/* 21 */ YY_NO_ANCHOR,
		/* 22 */ YY_NO_ANCHOR,
		/* 23 */ YY_NO_ANCHOR,
		/* 24 */ YY_NO_ANCHOR,
		/* 25 */ YY_NO_ANCHOR,
		/* 26 */ YY_NO_ANCHOR,
		/* 27 */ YY_NO_ANCHOR,
		/* 28 */ YY_NO_ANCHOR,
		/* 29 */ YY_NO_ANCHOR,
		/* 30 */ YY_NO_ANCHOR,
		/* 31 */ YY_NO_ANCHOR,
		/* 32 */ YY_NO_ANCHOR,
		/* 33 */ YY_NO_ANCHOR,
		/* 34 */ YY_NOT_ACCEPT,
		/* 35 */ YY_NO_ANCHOR,
		/* 36 */ YY_NO_ANCHOR,
		/* 37 */ YY_NO_ANCHOR,
		/* 38 */ YY_NO_ANCHOR,
		/* 39 */ YY_NO_ANCHOR,
		/* 40 */ YY_NOT_ACCEPT,
		/* 41 */ YY_NO_ANCHOR,
		/* 42 */ YY_NOT_ACCEPT,
		/* 43 */ YY_NO_ANCHOR,
		/* 44 */ YY_NOT_ACCEPT,
		/* 45 */ YY_NO_ANCHOR,
		/* 46 */ YY_NOT_ACCEPT,
		/* 47 */ YY_NOT_ACCEPT,
		/* 48 */ YY_NOT_ACCEPT,
		/* 49 */ YY_NOT_ACCEPT,
		/* 50 */ YY_NOT_ACCEPT,
		/* 51 */ YY_NOT_ACCEPT,
		/* 52 */ YY_NOT_ACCEPT,
		/* 53 */ YY_NOT_ACCEPT,
		/* 54 */ YY_NOT_ACCEPT,
		/* 55 */ YY_NOT_ACCEPT,
		/* 56 */ YY_NOT_ACCEPT,
		/* 57 */ YY_NOT_ACCEPT,
		/* 58 */ YY_NOT_ACCEPT,
		/* 59 */ YY_NOT_ACCEPT,
		/* 60 */ YY_NOT_ACCEPT,
		/* 61 */ YY_NOT_ACCEPT,
		/* 62 */ YY_NOT_ACCEPT,
		/* 63 */ YY_NOT_ACCEPT,
		/* 64 */ YY_NOT_ACCEPT,
		/* 65 */ YY_NOT_ACCEPT,
		/* 66 */ YY_NOT_ACCEPT,
		/* 67 */ YY_NOT_ACCEPT,
		/* 68 */ YY_NOT_ACCEPT,
		/* 69 */ YY_NOT_ACCEPT,
		/* 70 */ YY_NOT_ACCEPT,
		/* 71 */ YY_NOT_ACCEPT,
		/* 72 */ YY_NOT_ACCEPT,
		/* 73 */ YY_NOT_ACCEPT,
		/* 74 */ YY_NOT_ACCEPT,
		/* 75 */ YY_NOT_ACCEPT,
		/* 76 */ YY_NOT_ACCEPT,
		/* 77 */ YY_NOT_ACCEPT,
		/* 78 */ YY_NOT_ACCEPT,
		/* 79 */ YY_NOT_ACCEPT,
		/* 80 */ YY_NOT_ACCEPT,
		/* 81 */ YY_NOT_ACCEPT,
		/* 82 */ YY_NOT_ACCEPT,
		/* 83 */ YY_NOT_ACCEPT,
		/* 84 */ YY_NOT_ACCEPT,
		/* 85 */ YY_NOT_ACCEPT,
		/* 86 */ YY_NO_ANCHOR,
		/* 87 */ YY_NOT_ACCEPT,
		/* 88 */ YY_NO_ANCHOR,
		/* 89 */ YY_NOT_ACCEPT,
		/* 90 */ YY_NOT_ACCEPT,
		/* 91 */ YY_NOT_ACCEPT,
		/* 92 */ YY_NOT_ACCEPT,
		/* 93 */ YY_NOT_ACCEPT,
		/* 94 */ YY_NOT_ACCEPT,
		/* 95 */ YY_NO_ANCHOR,
		/* 96 */ YY_NOT_ACCEPT
	};
	private int yy_cmap[] = unpackFromString(1,65538,
"14:8,25:3,14:21,25,15,36,28,11,14:2,13,26,27,3,1,8,2,10,4,33,9:9,16,14,7,6," +
"5,35,14,22,12:2,30,20,21,12:2,31,12:2,23,34,29,12:3,18,24,17,19,32,12:4,14:" +
"6,12:26,14:65413,0:2")[0];

	private int yy_rmap[] = unpackFromString(1,97,
"0,1:5,2,1,3,1,4,1:8,5,6,1,7,8,9,10,11,12,10,1,13,14,15,1,16,17,10,1:2,18,19" +
",20,21,22,23,24,7,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43," +
"44,9,45,46,47,48,49,50,11,51,52,53,54,55,56,57,58,59,60,14,61,62,63,64,65,6" +
"6,67,68,69,70,71")[0];

	private int yy_nxt[][] = unpackFromString(72,37,
"1,2,3,4,5,6,7,8,9,10,34,40,34,42,-1:2,11,87,34:3,96,34:3,12,13,14,44,34:4,1" +
"0,34,-1,15,-1:43,16,-1:35,17,18,-1:39,10,46,-1:22,10,-1:12,19,-1:6,90,-1:16" +
",19,-1:12,35,36,47,36,-1:2,48,49,36:8,-1,21,-1:2,36:4,35,36,-1:11,22,-1:23," +
"22,-1:13,37,-1,37,-1:4,37:8,-1:4,37:4,-1,37,-1:11,24,-1:23,24,-1:12,43,36,-" +
"1,36,-1:2,48,-1,36:8,-1,21,-1:2,36:4,43,36,-1:11,26,-1:23,26,-1:12,27,-1:6," +
"81,-1:16,27,-1:13,38,-1,38,-1:4,38:8,-1:4,38:4,-1,38,-1:11,31,-1:23,31,-1:3" +
",1,39:35,33,-1:9,19,20,47,20,-1:2,48,49,20:8,-1,21,-1:2,20:4,19,20,-1:11,35" +
",43,-1,43,-1:3,90,43:8,-1:4,43:4,35,43,-1:3,39:35,-1:11,50,-1,50,-1:4,50:8," +
"-1:4,50:4,-1,50,-1:11,43,36,-1,36,-1:2,48,-1,36:3,25,36:4,-1,21,-1:2,36:4,4" +
"3,36,-1:3,42:12,51,42:23,-1:9,43:2,-1,43,-1:4,43:8,-1:4,43:6,-1:20,52,-1:10" +
",53,54,-1,55,-1:13,43,36,-1,36,-1:2,48,-1,36:3,28,36:4,-1,21,-1:2,36:4,43,3" +
"6,-1:11,19,-1:23,19,-1:13,56,89,56,-1:4,56:8,-1:4,56:4,-1,56,-1:12,23,57,23" +
",-1:4,23:8,-1:4,23:4,-1,23,-1:11,19,58,47,58,-1:3,49,58:8,-1:4,58:4,19,58,-" +
"1:17,59,-1:41,60,-1:35,61,-1:2,62,-1:45,63,-1:27,64,-1:23,24,66,67,66,-1:4," +
"66:8,-1:4,66:4,24,66,-1:12,23,-1,23,-1:4,23:8,-1:4,23:4,-1,23,-1:11,19,-1,4" +
"7,-1:4,49,-1:16,19,-1:13,68,93,68,-1:4,68:8,-1:4,68:4,-1,68,-1:23,69,-1:38," +
"91,-1:10,69,-1:36,70,-1:34,71,-1:27,72,-1:22,26,73,74,73,-1:4,73:8,-1:4,73:" +
"4,26,73,-1:11,24,-1,67,-1:21,24,-1:12,27,75,76,75,-1:3,77,75:8,-1:4,75:4,27" +
",75,-1:17,29,-1:41,78,-1:20,79,-1:51,80,-1:26,26,-1,74,-1:21,26,-1:12,27,-1" +
",76,-1:4,77,-1:16,27,-1:12,27,-1:23,27,-1:13,30,82,30,-1:4,30:8,-1:4,30:4,-" +
"1,30,-1:37,29,-1:34,69,-1:23,69,-1:26,83,94,83,-1:4,83:8,-1:4,83:4,-1,83,-1" +
":12,30,-1,30,-1:4,30:8,-1:4,30:4,-1,30,-1:11,31,84,85,84,-1:4,84:8,-1:4,84:" +
"4,31,84,-1:11,31,-1,85,-1:21,31,-1:12,35,36,47,36,-1:2,48,49,36:2,41,36:5,-" +
"1,21,-1:2,36:4,35,36,-1:11,19,20,47,20,-1:2,48,49,20,86,20:6,-1,21,-1:2,20:" +
"4,19,20,-1:11,43,36,-1,36,-1:2,48,-1,36:7,45,-1,21,-1:2,36:4,43,36,-1:12,56" +
",-1,56,-1:4,56:8,-1:4,56:4,-1,56,-1:12,65,92,65,-1:4,65:8,-1:4,65:4,-1,65,-" +
"1:25,69,-1:23,65,-1,65,-1:4,65:8,-1:4,65:4,-1,65,-1:12,68,-1,68,-1:4,68:8,-" +
"1:4,68:4,-1,68,-1:12,83,-1,83,-1:4,83:8,-1:4,83:4,-1,83,-1:11,35,36,47,36,-" +
"1:2,48,49,36:6,88,36,-1,21,-1:2,36:4,35,36,-1:11,19,20,47,20,-1:2,48,49,20:" +
"5,95,20:2,-1,21,-1:2,20:4,19,20,-1:2");

	public ParseItem yylex ()
		throws java.io.IOException, 
 jxl.biff.formula.FormulaException

		{
		int yy_lookahead;
		int yy_anchor = YY_NO_ANCHOR;
		int yy_state = yy_state_dtrans[yy_lexical_state];
		int yy_next_state = YY_NO_STATE;
		int yy_last_accept_state = YY_NO_STATE;
		boolean yy_initial = true;
		int yy_this_accept;

		yy_mark_start();
		yy_this_accept = yy_acpt[yy_state];
		if (YY_NOT_ACCEPT != yy_this_accept) {
			yy_last_accept_state = yy_state;
			yy_mark_end();
		}
		while (true) {
			if (yy_initial && yy_at_bol) yy_lookahead = YY_BOL;
			else yy_lookahead = yy_advance();
			yy_next_state = YY_F;
			yy_next_state = yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];
			if (YY_EOF == yy_lookahead && true == yy_initial) {
				return null;
			}
			if (YY_F != yy_next_state) {
				yy_state = yy_next_state;
				yy_initial = false;
				yy_this_accept = yy_acpt[yy_state];
				if (YY_NOT_ACCEPT != yy_this_accept) {
					yy_last_accept_state = yy_state;
					yy_mark_end();
				}
			}
			else {
				if (YY_NO_STATE == yy_last_accept_state) {
					throw (new Error("Lexical Error: Unmatched Input."));
				}
				else {
					yy_anchor = yy_acpt[yy_last_accept_state];
					if (0 != (YY_END & yy_anchor)) {
						yy_move_end();
					}
					yy_to_mark();
					switch (yy_last_accept_state) {
					case 1:
						
					case -2:
						break;
					case 2:
						{ return new Plus() ;}
					case -3:
						break;
					case 3:
						{ return new Minus() ; }
					case -4:
						break;
					case 4:
						{ return new Multiply() ; }
					case -5:
						break;
					case 5:
						{ return new Divide() ; }
					case -6:
						break;
					case 6:
						{ return new GreaterThan() ; }
					case -7:
						break;
					case 7:
						{ return new Equal() ; }
					case -8:
						break;
					case 8:
						{ return new LessThan() ; }
					case -9:
						break;
					case 9:
						{ return new ArgumentSeparator() ; }
					case -10:
						break;
					case 10:
						{ return new IntegerValue(yytext()) ; }
					case -11:
						break;
					case 11:
						{ return new RangeSeparator(); }
					case -12:
						break;
					case 12:
						{}
					case -13:
						break;
					case 13:
						{ return new OpenParentheses() ;}
					case -14:
						break;
					case 14:
						{ return new CloseParentheses() ;}
					case -15:
						break;
					case 15:
						{emptyString = true; yybegin(YYSTRING);}
					case -16:
						break;
					case 16:
						{ return new GreaterEqual() ; }
					case -17:
						break;
					case 17:
						{ return new NotEqual() ; }
					case -18:
						break;
					case 18:
						{ return new LessEqual() ; }
					case -19:
						break;
					case 19:
						{ return new CellReference(yytext()) ; }
					case -20:
						break;
					case 20:
						{return new NameRange(yytext(), nameTable); }
					case -21:
						break;
					case 21:
						{ return new StringFunction(yytext()) ; }
					case -22:
						break;
					case 22:
						{ return new DoubleValue(yytext()) ; }
					case -23:
						break;
					case 23:
						{ return new ColumnRange(yytext()); }
					case -24:
						break;
					case 24:
						{return new CellReference3d(yytext(),externalSheet) ; }
					case -25:
						break;
					case 25:
						{return new BooleanValue(yytext());}
					case -26:
						break;
					case 26:
						{ return new Area(yytext()) ; }
					case -27:
						break;
					case 27:
						{return new CellReference3d(yytext(),externalSheet) ; }
					case -28:
						break;
					case 28:
						{return new BooleanValue(yytext());}
					case -29:
						break;
					case 29:
						{return new ErrorConstant(yytext());}
					case -30:
						break;
					case 30:
						{ return new ColumnRange3d(yytext(),externalSheet) ; }
					case -31:
						break;
					case 31:
						{ return new Area3d(yytext(),externalSheet) ; }
					case -32:
						break;
					case 32:
						{emptyString = false; return new StringValue(yytext()) ; }
					case -33:
						break;
					case 33:
						{yybegin(YYINITIAL); if (emptyString) return new StringValue("");}
					case -34:
						break;
					case 35:
						{ return new CellReference(yytext()) ; }
					case -35:
						break;
					case 36:
						{return new NameRange(yytext(), nameTable); }
					case -36:
						break;
					case 37:
						{ return new ColumnRange(yytext()); }
					case -37:
						break;
					case 38:
						{ return new ColumnRange3d(yytext(),externalSheet) ; }
					case -38:
						break;
					case 39:
						{emptyString = false; return new StringValue(yytext()) ; }
					case -39:
						break;
					case 41:
						{return new NameRange(yytext(), nameTable); }
					case -40:
						break;
					case 43:
						{return new NameRange(yytext(), nameTable); }
					case -41:
						break;
					case 45:
						{return new NameRange(yytext(), nameTable); }
					case -42:
						break;
					case 86:
						{return new NameRange(yytext(), nameTable); }
					case -43:
						break;
					case 88:
						{return new NameRange(yytext(), nameTable); }
					case -44:
						break;
					case 95:
						{return new NameRange(yytext(), nameTable); }
					case -45:
						break;
					default:
						yy_error(YY_E_INTERNAL,false);
					case -1:
					}
					yy_initial = true;
					yy_state = yy_state_dtrans[yy_lexical_state];
					yy_next_state = YY_NO_STATE;
					yy_last_accept_state = YY_NO_STATE;
					yy_mark_start();
					yy_this_accept = yy_acpt[yy_state];
					if (YY_NOT_ACCEPT != yy_this_accept) {
						yy_last_accept_state = yy_state;
						yy_mark_end();
					}
				}
			}
		}
	}
}
