/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.sample.task;

import java.io.IOException;
import java.math.BigDecimal;

import blanco.sample.task.valueobject.BlancoAntTaskSampleBatchProcessInput;

/**
 * ob`NX [BlancoAntTaskSampleBatchProcess]̒ېeNXB̃NX̓pbP[WANZXɌ肳Ă܂ (publicNXł͂܂)B
 *
 * ̃NXp [blanco.sample.task]pbP[W[BlancoAntTaskSampleBatchProcess]NX쐬Ďۂ̃ob`ĂB<br>
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.sample.task.BlancoAntTaskSampleBatchProcess -help
 * </code>
 */
abstract class AbstractBlancoAntTaskSampleBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        // ̉ӏŃRpCG[ꍇAAbstractBlancoAntTaskSampleBatchProcessNXp blanco.sample.taskpbP[W BlancoAntTaskSampleBatchProcessNX쐬邱Ƃɂłꍇ܂B
        final AbstractBlancoAntTaskSampleBatchProcess batchProcess = new BlancoAntTaskSampleBatchProcess();

        // ob`̈B
        final BlancoAntTaskSampleBatchProcessInput input = new BlancoAntTaskSampleBatchProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldAttr1Processed = false;
        boolean isFieldAttr3Processed = false;
        boolean isFieldAttr5Processed = false;
        boolean isFieldAttr7Processed = false;
        boolean isFieldAttr9Processed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-attr1=")) {
                input.setAttr1(arg.substring(7));
                isFieldAttr1Processed = true;
            } else if (arg.startsWith("-attr2=")) {
                input.setAttr2(arg.substring(7));
            } else if (arg.startsWith("-attr3=")) {
                try {
                    input.setAttr3(Integer.parseInt(arg.substring(7)));
                } catch (NumberFormatException e) {
                    System.out.println("BlancoAntTaskSampleBatchProcess: JnsB̓p[^[input]̃tB[h[attr3]𐔒l(int)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
                isFieldAttr3Processed = true;
            } else if (arg.startsWith("-attr4=")) {
                try {
                    input.setAttr4(Integer.parseInt(arg.substring(7)));
                } catch (NumberFormatException e) {
                    System.out.println("BlancoAntTaskSampleBatchProcess: JnsB̓p[^[input]̃tB[h[attr4]𐔒l(int)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
            } else if (arg.startsWith("-attr5=")) {
                try {
                    input.setAttr5(Long.parseLong(arg.substring(7)));
                } catch (NumberFormatException e) {
                    System.out.println("BlancoAntTaskSampleBatchProcess: JnsB̓p[^[input]̃tB[h[attr5]𐔒l(long)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
                isFieldAttr5Processed = true;
            } else if (arg.startsWith("-attr6=")) {
                try {
                    input.setAttr6(Long.parseLong(arg.substring(7)));
                } catch (NumberFormatException e) {
                    System.out.println("BlancoAntTaskSampleBatchProcess: JnsB̓p[^[input]̃tB[h[attr6]𐔒l(long)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
            } else if (arg.startsWith("-attr7=")) {
                try {
                    input.setAttr7(new BigDecimal(arg.substring(7)));
                } catch (NumberFormatException e) {
                    System.out.println("BlancoAntTaskSampleBatchProcess: JnsB̓p[^[input]̃tB[h[attr7]𐔒l(decimal)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
                isFieldAttr7Processed = true;
            } else if (arg.startsWith("-attr8=")) {
                try {
                    input.setAttr8(new BigDecimal(arg.substring(7)));
                } catch (NumberFormatException e) {
                    System.out.println("BlancoAntTaskSampleBatchProcess: JnsB̓p[^[input]̃tB[h[attr8]𐔒l(decimal)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
            } else if (arg.startsWith("-attr9=")) {
                input.setAttr9(Boolean.valueOf(arg.substring(7)).booleanValue());
                isFieldAttr9Processed = true;
            } else if (arg.startsWith("-attr10=")) {
                input.setAttr10(Boolean.valueOf(arg.substring(8)).booleanValue());
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoAntTaskSampleBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldAttr1Processed == false) {
            System.out.println("BlancoAntTaskSampleBatchProcess: JnsB̓p[^[input]̕K{tB[hl[attr1]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldAttr3Processed == false) {
            System.out.println("BlancoAntTaskSampleBatchProcess: JnsB̓p[^[input]̕K{tB[hl[attr3]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldAttr5Processed == false) {
            System.out.println("BlancoAntTaskSampleBatchProcess: JnsB̓p[^[input]̕K{tB[hl[attr5]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldAttr7Processed == false) {
            System.out.println("BlancoAntTaskSampleBatchProcess: JnsB̓p[^[input]̕K{tB[hl[attr7]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldAttr9Processed == false) {
            System.out.println("BlancoAntTaskSampleBatchProcess: JnsB̓p[^[input]̕K{tB[hl[attr9]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public abstract int process(final BlancoAntTaskSampleBatchProcessInput input) throws IOException, IllegalArgumentException;

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoAntTaskSampleBatchProcessInput input) throws IllegalArgumentException {
        try {
            // ̓p[^`FbN܂B
            validateInput(input);

            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoAntTaskSampleBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoAntTaskSampleBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoAntTaskSampleBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoAntTaskSampleBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoAntTaskSampleBatchProcess: Usage:");
        System.out.println("  java blanco.sample.task.BlancoAntTaskSampleBatchProcess -verbose=l1 -attr1=l2 -attr2=l3 -attr3=l4 -attr4=l5 -attr5=l6 -attr6=l7 -attr7=l8 -attr8=l9 -attr9=l10 -attr10=l11");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -attr1");
        System.out.println("      [iK{j]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -attr2");
        System.out.println("      [blanco:string]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[ftHg]");
        System.out.println("    -attr3");
        System.out.println("      [(int)(K{)]");
        System.out.println("      ^[l(int)]");
        System.out.println("      K{p[^");
        System.out.println("    -attr4");
        System.out.println("      [blanco:int]");
        System.out.println("      ^[l(int)]");
        System.out.println("      ftHgl[10]");
        System.out.println("    -attr5");
        System.out.println("      [(long)(K{)]");
        System.out.println("      ^[l(long)]");
        System.out.println("      K{p[^");
        System.out.println("    -attr6");
        System.out.println("      [blanco:long]");
        System.out.println("      ^[l(long)]");
        System.out.println("      ftHgl[100]");
        System.out.println("    -attr7");
        System.out.println("      [(decimal)(K{)]");
        System.out.println("      ^[l(decimal)]");
        System.out.println("      K{p[^");
        System.out.println("    -attr8");
        System.out.println("      [(decimal)]");
        System.out.println("      ^[l(decimal)]");
        System.out.println("      ftHgl[123.456]");
        System.out.println("    -attr9");
        System.out.println("      [^U(K{)]");
        System.out.println("      ^[^U]");
        System.out.println("      K{p[^");
        System.out.println("    -attr10");
        System.out.println("      [blanco:boolean]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[true]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoAntTaskSampleBatchProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getAttr1() == null) {
            throw new IllegalArgumentException("BlancoAntTaskSampleBatchProcess: JnsB̓p[^[input]̕K{tB[hl[attr1]ɒlݒ肳Ă܂B");
        }
        if (input.getAttr7() == null) {
            throw new IllegalArgumentException("BlancoAntTaskSampleBatchProcess: JnsB̓p[^[input]̕K{tB[hl[attr7]ɒlݒ肳Ă܂B");
        }
    }
}
