/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoResourceBundle]̃NX
 */
package blanco.resourcebundle.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.resourcebundle.task.valueobject.BlancoResourceBundleBatchProcessInput;

/**
 * Apache Ant^XN [BlancoResourceBundle]̃NXB
 *
 * BlancoResourceBundleAntTaskłB<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.resourcebundle.task]BlancoResourceBundleBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancoresourcebundle&quot; classname=&quot;blanco.resourcebundle.task.BlancoResourceBundleTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoResourceBundleTask extends Task {
    /**
     * BlancoResourceBundleAntTaskłB
     */
    private BlancoResourceBundleBatchProcessInput fInput = new BlancoResourceBundleBatchProcessInput();

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final String arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public String getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[metadir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^fBNg<br>
     *
     * @param arg Zbgl
     */
    public void setMetadir(final String arg) {
        fInput.setMetadir(arg);
    }

    /**
     * Ant^XN[metadir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^fBNg<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getMetadir() {
        return fInput.getMetadir();
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fInput.setTargetdir(arg);
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     * ftHgl[blanco]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fInput.getTargetdir();
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|tH_w肵܂Bw̏ꍇɂ́AJgtmpp܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTmpdir(final String arg) {
        fInput.setTmpdir(arg);
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|tH_w肵܂Bw̏ꍇɂ́AJgtmpp܂B<br>
     * ftHgl[tmp]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTmpdir() {
        return fInput.getTmpdir();
    }

    /**
     * Ant^XN[commenttimestamp]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 4<br>
     * vpeBt@C̐ɂāAvpeBt@C̃Rgɏo͂邩ǂtOB<br>
     *
     * @param arg Zbgl
     */
    public void setCommenttimestamp(final String arg) {
        fInput.setCommenttimestamp(arg);
    }

    /**
     * Ant^XN[commenttimestamp]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 4<br>
     * vpeBt@C̐ɂāAvpeBt@C̃Rgɏo͂邩ǂtOB<br>
     * ftHgl[true]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getCommenttimestamp() {
        return fInput.getCommenttimestamp();
    }

    /**
     * Ant^XN[failonmessageformaterror]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 5<br>
     * \[XohMessageFormatɂp[XsۂɁAO珈𒆒f邩ǂ̃tOBtrueȂ珈fėO𔭐܂BfalseȂ珈sAû͖Ƃ݂Ȃ܂BJavã\[XR[hۂȂǂɁA falseɐݒ肵ĔgʂƂł悤ɐ؂ւꍇ܂B<br>
     *
     * @param arg Zbgl
     */
    public void setFailonmessageformaterror(final String arg) {
        fInput.setFailonmessageformaterror(arg);
    }

    /**
     * Ant^XN[failonmessageformaterror]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 5<br>
     * \[XohMessageFormatɂp[XsۂɁAO珈𒆒f邩ǂ̃tOBtrueȂ珈fėO𔭐܂BfalseȂ珈sAû͖Ƃ݂Ȃ܂BJavã\[XR[hۂȂǂɁA falseɐݒ肵ĔgʂƂł悤ɐ؂ւꍇ܂B<br>
     * ftHgl[true]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getFailonmessageformaterror() {
        return fInput.getFailonmessageformaterror();
    }

    /**
     * Ant^XN[log]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 6<br>
     * Oo͂\[XR[hɊ܂߂邩ǂ̃tOB݂͕Wo݂͂̂ɑΉB<br>
     *
     * @param arg Zbgl
     */
    public void setLog(final String arg) {
        fInput.setLog(arg);
    }

    /**
     * Ant^XN[log]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 6<br>
     * Oo͂\[XR[hɊ܂߂邩ǂ̃tOB݂͕Wo݂͂̂ɑΉB<br>
     * ftHgl[false]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getLog() {
        return fInput.getLog();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    public final void execute() throws BuildException {
        System.out.println("BlancoResourceBundleTask begin.");

        // ڔԍ[1]AAgr[g[metadir]͕K{͂łB̓`FbNs܂B
        if (getMetadir() == null) {
            throw new BuildException("Agr[g[metadir]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[2]AAgr[g[targetdir]ɂ̓ftHgݒ肳Ă܂B͂null̏ꍇɂ̓ftHglZbg܂B
        if (getTargetdir() == null) {
            setTargetdir("blanco");
        }
        // ڔԍ[3]AAgr[g[tmpdir]ɂ̓ftHgݒ肳Ă܂B͂null̏ꍇɂ̓ftHglZbg܂B
        if (getTmpdir() == null) {
            setTmpdir("tmp");
        }
        // ڔԍ[4]AAgr[g[commenttimestamp]ɂ̓ftHgݒ肳Ă܂B͂null̏ꍇɂ̓ftHglZbg܂B
        if (getCommenttimestamp() == null) {
            setCommenttimestamp("true");
        }
        // ڔԍ[5]AAgr[g[failonmessageformaterror]ɂ̓ftHgݒ肳Ă܂B͂null̏ꍇɂ̓ftHglZbg܂B
        if (getFailonmessageformaterror() == null) {
            setFailonmessageformaterror("true");
        }
        // ڔԍ[6]AAgr[g[log]ɂ̓ftHgݒ肳Ă܂B͂null̏ꍇɂ̓ftHglZbg܂B
        if (getLog() == null) {
            setLog("false");
        }

        if ("true".equals(getVerbose())) {
            System.out.println("- verbose:[true]");
            System.out.println("- metadir:[" + getMetadir() + "]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
            System.out.println("- tmpdir:[" + getTmpdir() + "]");
            System.out.println("- commenttimestamp:[" + getCommenttimestamp() + "]");
            System.out.println("- failonmessageformaterror:[" + getFailonmessageformaterror() + "]");
            System.out.println("- log:[" + getLog() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            if (new BlancoResourceBundleBatchProcess().execute(fInput) != BlancoResourceBundleBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if ("true".equals(getVerbose())) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
