/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.mail.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;

import blanco.commons.util.BlancoStringUtil;
import blanco.log.BlancoLogBinaryLogger;
import blanco.mail.core.resourcebundle.BlancoMailCoreMessageResourceBundle;
import blanco.mail.core.valueobject.BlancoMailAddress;
import blanco.mail.core.valueobject.BlancoMailMessage;
import blanco.mail.core.valueobject.BlancoMailMessageAttachment;
import blanco.mail.core.valueobject.BlancoMailMessageHeader;
import blanco.mail.core.valueobject.BlancoMailSetting;
import blanco.mail.core.valueobject.BlancoMailStatistics;

/**
 * [MNXB
 * 
 * ȒPňSȃ[M邽߂̎QƎłB blancoMail RACûЂƂB
 * NX擾邽߂ɂ́ABlancoMailSenderFactory#getInstance 𗘗p܂B
 * 
 * ̃NXgėpʂz肵ANXANZX public NXƐݒ肵Ă܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoMailSenderImpl implements BlancoMailSender {
    /**
     * blancoMailCorebZ[WNXB
     */
    protected final BlancoMailCoreMessageResourceBundle fMsg = new BlancoMailCoreMessageResourceBundle();

    /**
     * vIuWFNgBftHgłnullZbgĂ_ɒӂĂB
     */
    protected BlancoMailStatistics fStatistics = null;

    /**
     * RXgN^͉B܂B
     * 
     * FactoryANZX\ɂȂ悤ɃpbP[WANZXeĂ܂B
     */
    BlancoMailSenderImpl() {
    }

    /**
     * [T[oɁA[𑗐M܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argMessage
     *            M[{̂킷o[IuWFNgB̃IuWFNgɃ[̖{∶Ȃǂ̏Ă܂B
     * @throws ConnectException
     *             [T[oւ̐ڑsɊւOB
     * @throws IOException
     *             [f[^MsɊւOB
     */
    public void send(final BlancoMailSetting argSetting,
            final BlancoMailMessage argMessage) throws ConnectException,
            IOException {
        // p[^`FbNB
        if (argSetting == null) {
            throw new IllegalArgumentException(fMsg.getMbmcs023());
        }
        if (argMessage == null) {
            throw new IllegalArgumentException(fMsg.getMbmcs024());
        }

        if (fStatistics == null) {
            // vIuWFNgݒ肳ĂȂꍇɂ ݒ肵܂B
            // ɂA\bhł fStatistics͏ɔnullł邱ƂۏႵ܂B
            fStatistics = new BlancoMailStatistics();
        }

        // BlancoMailSettingȇÓ̌؁B
        checkSetting(argSetting);

        // bZ[WIuWFNgȇÓ̌؁B
        checkMessage(argSetting, argMessage);

        final Properties props = new Properties();
        prepareSessionProperties(argSetting, props);

        prepareSessionPropertiesWithMessage(argSetting, argMessage, props);

        if (argSetting.getTestMode()) {
            new BlancoMailTestStub().send(argSetting, argMessage);
            // ۂ̃[M͎{܂B return܂B
            return;
        }

        // ʐMJn
        final long startTimeMillis = System.currentTimeMillis();

        final Session session = BlancoMailCoreUtil.getSendSession(argSetting,
                props);
        final ByteArrayOutputStream outWorkByteArrayOutputStream = BlancoMailCoreUtil
                .beginSessionLogOutputStream(argSetting, session);

        final Transport transport = connectTransport(argSetting, session);

        boolean isSuccessEnd = false;

        final MimeMessage mimeMessage = new MimeMessage(session);
        buildMessage(argSetting, argMessage, mimeMessage);

        try {
            // [MB
            transport.sendMessage(mimeMessage, mimeMessage.getAllRecipients());

            // ItOZbg܂B
            isSuccessEnd = true;

            // v̍XVB
            fStatistics.setSendCount(fStatistics.getSendCount() + 1);
            // v̂AMTCYXVB
            long sendSize = argMessage.getText().getBytes(
                    argSetting.getSendEncoding()).length;
            for (int index = 0; index < argMessage.getAttachmentList().size(); index++) {
                final BlancoMailMessageAttachment attachment = (BlancoMailMessageAttachment) argMessage
                        .getAttachmentList().get(index);
                sendSize += attachment.getData().length;
            }
            fStatistics.setSendSize(fStatistics.getSendSize() + sendSize);

        } catch (MessagingException e) {
            fStatistics.setSendErrorCount(fStatistics.getSendErrorCount() + 1);
            throw new IOException(fMsg.getMbmcs301(e.toString()));
        } finally {
            try {
                transport.close();
            } catch (MessagingException e) {
                // ڑN[YOɂẮA͗OƂ͂܂B
                // TODO MOVXeɂ́AOo͂ĂB
                System.out.println(fMsg.getMbmcs302(e.toString()));
            }

            // ʐMI
            final long endTimeMillis = System.currentTimeMillis();

            // MԂ̓vXVB
            fStatistics.setSendTime(fStatistics.getSendTime()
                    + (endTimeMillis - startTimeMillis));

            // [T[oƂ̈ÂƂZbVOt@Cɏo͂܂B

            String sessionLogDirectory = null;
            if (isSuccessEnd) {
                sessionLogDirectory = argSetting
                        .getSessionLogDirectorySuccess();
            } else {
                sessionLogDirectory = argSetting.getSessionLogDirectoryError();
            }

            if (BlancoStringUtil.null2Blank(sessionLogDirectory).length() > 0) {
                final BlancoLogBinaryLogger logger = new BlancoLogBinaryLogger(
                        sessionLogDirectory, "mail", "s", "log");
                try {
                    logger.log(outWorkByteArrayOutputStream.toByteArray());
                } catch (IOException e) {
                    throw new IOException(fMsg.getMbmcs305(e.toString()));
                }
            }
        }
    }

    /**
     * v擾̂߂̃o[IuWFNgZbg܂B
     * 
     * @param argStatistics
     *            vB
     */
    public void setStatistics(final BlancoMailStatistics argStatistics) {
        fStatistics = argStatistics;
    }

    /**
     * v擾̂߂̃o[IuWFNgQbg܂B
     * 
     * @return vB
     */
    public BlancoMailStatistics getStatistics() {
        return fStatistics;
    }

    /**
     * blancoMailCore API o[IuWFNg`̃[eƂɁAJavaMail API
     * bZ[WIuWFNgɃZbg܂B
     * 
     * ̑OBO checkMessage \bhĂяoAargMessageȇÓ`FbNĂ邱ƁB
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argMessage
     *            M[{̂킷o[IuWFNgB̃IuWFNg̓e͂Ƃ܂B
     * @param argJavaMailMessage
     *            JavaMail APĨbZ[WIuWFNgB
     * @throws IOException
     *             [f[^MsɊւOB
     */
    private void buildMessage(final BlancoMailSetting argSetting,
            final BlancoMailMessage argMessage,
            final MimeMessage argJavaMailMessage) throws IOException {
        if (argMessage == null) {
            throw new IllegalArgumentException(
                    "BlancoMailSender#buildMessage: \bh̃p[^(argMessage) nulln܂B̃IuWFNg nullłĂ͂Ȃ܂B");
        }
        if (argJavaMailMessage == null) {
            throw new IllegalArgumentException(
                    "BlancoMailSender#buildMessage: \bh̃p[^(argMimeMessage) nulln܂B̃IuWFNg nullłĂ͂Ȃ܂B");
        }

        // bZ[We̐ݒB
        try {
            // From̐ݒB
            final Address addrFrom = BlancoMailCoreUtil.toInternetAddress(
                    argSetting, argMessage.getFrom());
            argJavaMailMessage.setFrom(addrFrom);

            // To̐ݒB
            for (int index = 0; index < argMessage.getTo().size(); index++) {
                final Address addrTo = BlancoMailCoreUtil.toInternetAddress(
                        argSetting, (BlancoMailAddress) argMessage.getTo().get(
                                index));
                argJavaMailMessage.addRecipient(Message.RecipientType.TO,
                        addrTo);
            }

            // Cc̐ݒB
            for (int index = 0; index < argMessage.getCc().size(); index++) {
                final Address addrCc = BlancoMailCoreUtil.toInternetAddress(
                        argSetting, (BlancoMailAddress) argMessage.getCc().get(
                                index));
                argJavaMailMessage.addRecipient(Message.RecipientType.CC,
                        addrCc);
            }

            // Bcc̐ݒB
            for (int index = 0; index < argMessage.getBcc().size(); index++) {
                final Address addrBcc = BlancoMailCoreUtil.toInternetAddress(
                        argSetting, (BlancoMailAddress) argMessage.getBcc()
                                .get(index));
                argJavaMailMessage.addRecipient(Message.RecipientType.BCC,
                        addrBcc);
            }

            // ReplyTo̐ݒB
            if (argMessage.getReplyTo() != null) {
                // ReplyTo̎w肪ꍇɂ̂ݐݒ肵܂B
                final Address addrReplyTo = BlancoMailCoreUtil
                        .toInternetAddress(argSetting, argMessage.getReplyTo());
                argJavaMailMessage.setReplyTo(new Address[] { addrReplyTo });
            }

            // Subject̐ݒB
            argJavaMailMessage.setSubject(argMessage.getSubject(), argSetting
                    .getSendEncoding());

            // [{̐ݒB
            if (argMessage.getAttachmentList().size() == 0) {
                // Ytt@CȂ̏ꍇB
                // setText\bȟĂяoɂAContent-Type͎I[text/plain]ɂȂB

                argJavaMailMessage.setText(getActualMessageText(argSetting,
                        argMessage), argSetting.getSendEncoding());

                if (argSetting.getSendForthContentTransferEncoding7bit()) {
                    // setTextĂяoɁAwb_[ 7bitւƏ㏑܂B
                    // ́Aꕔ̃P[^C[ quoted-printable łȂƂւ̑΍ƂȂ܂B
                    argJavaMailMessage.setHeader("Content-Transfer-Encoding",
                            "7bit");
                }
            } else {
                // Ytt@C̏ꍇB

                // ́A}`p[g̃[{ƂȂ܂B
                final Multipart multipart = new MimeMultipart();

                // eLXg{B
                final MimeBodyPart textPart = new MimeBodyPart();

                textPart.setText(getActualMessageText(argSetting, argMessage),
                        argSetting.getSendEncoding());

                // [̃bZ[W{fBł邱Ƃ咣܂B
                textPart.setHeader("Content-Description", "Mail message body");

                if (argSetting.getSendForthContentTransferEncoding7bit()) {
                    // setTextĂяoɁAwb_[ 7bitւƏ㏑܂B
                    // ́Aꕔ̃P[^C[ quoted-printable łȂƂւ̑΍ƂȂ܂B
                    textPart.setHeader("Content-Transfer-Encoding", "7bit");
                }

                multipart.addBodyPart(textPart);

                // Ytt@C̐YtȂ܂B
                for (int indexAttachment = 0; indexAttachment < argMessage
                        .getAttachmentList().size(); indexAttachment++) {

                    final BlancoMailMessageAttachment attachment = (BlancoMailMessageAttachment) argMessage
                            .getAttachmentList().get(indexAttachment);

                    // Ytt@C
                    final BodyPart attachmentPart = new MimeBodyPart();
                    // ɃoCif[^ł̂Ƃăt@CYtB
                    attachmentPart.setDataHandler(new DataHandler(
                            new ByteArrayDataSource(attachment.getData(),
                                    attachment.getMimeType())));

                    // Ytt@CZbg
                    // MimeUtility.encodeText  Ytt@CasciiȊO̕ꍇ̑΍B
                    attachmentPart.setFileName(MimeUtility.encodeText(
                            attachment.getFileName(), argSetting
                                    .getSendEncoding(), null));

                    multipart.addBodyPart(attachmentPart);
                }

                argJavaMailMessage.setContent(multipart);
            }

            // [Uw̃wb_[Zbg܂B(addHeader\bhgāuǉv܂)
            for (int index = 0; index < argMessage.getHeaderList().size(); index++) {
                final BlancoMailMessageHeader header = (BlancoMailMessageHeader) argMessage
                        .getHeaderList().get(index);
                argJavaMailMessage.addHeader(header.getName(), header
                        .getValue());
            }

            // ̑̕tB
            argJavaMailMessage.addHeader("X-Mailer", argSetting
                    .getSendMailerName()
                    + " ("
                    + BlancoMailCoreConstants.PRODUCT_NAME
                    + " "
                    + BlancoMailCoreConstants.VERSION + ")");

            // Mtݒ
            argJavaMailMessage.setSentDate(argMessage.getSentDate());

        } catch (MessagingException e) {
            fStatistics.setSendErrorCount(fStatistics.getSendErrorCount() + 1);
            throw new IOException(fMsg.getMbmcs303(e.toString()));
        } catch (UnsupportedEncodingException e) {
            fStatistics.setSendErrorCount(fStatistics.getSendErrorCount() + 1);
            throw new IOException(fMsg.getMbmcs304(e.toString()));
        }
    }

    /**
     * bZ[WIuWFNgȇÓ؂܂B
     * 
     * 񂴂Ƃ̓`FbNn͂Ŏ܂B܂AKvɉ Œx̕sݒ荀ڂւ̒l̃Zbg{܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argMessage
     *            M[{̂킷o[IuWFNgB̃IuWFNg̓e`FbN܂B
     */
    private void checkMessage(final BlancoMailSetting argSetting,
            final BlancoMailMessage argMessage) {
        if (argMessage == null) {
            throw new IllegalArgumentException(
                    "BlancoMailSender#checkMessage: \bh̃p[^(argMessage) nulln܂B̃IuWFNg nullłĂ͂Ȃ܂B");
        }

        if (argMessage.getFrom() == null) {
            throw new IllegalArgumentException(fMsg.getMbmcs001());
        }
        if (BlancoStringUtil.null2Blank(argMessage.getFrom().getAddress())
                .length() == 0) {
            throw new IllegalArgumentException(fMsg.getMbmcs028(argMessage
                    .getFrom().toString()));
        }
        if (argMessage.getTo() == null) {
            throw new IllegalArgumentException(fMsg.getMbmcs002());
        }
        if (argMessage.getTo().size() == 0) {
            throw new IllegalArgumentException(fMsg.getMbmcs003());
        }
        if (argMessage.getTo().size() > argSetting.getSendMaxRecipientAddrTo()) {
            // Tǒ̌𒴂ꍇɂ̓G[ɂB
            throw new IllegalArgumentException(fMsg.getMbmcs004(String
                    .valueOf(argMessage.getTo().size()), String
                    .valueOf(argSetting.getSendMaxRecipientAddrTo())));
        }

        if (argMessage.getCc() == null) {
            // CcnullZbgĂꍇɂ́AK؂ɏB
            argMessage.setCc(new ArrayList());
        }
        if (argMessage.getCc().size() > argSetting.getSendMaxRecipientAddrCc()) {
            // Cč̌𒴂ꍇɂ̓G[ɂB
            throw new IllegalArgumentException(fMsg.getMbmcs005(String
                    .valueOf(argMessage.getCc().size()), String
                    .valueOf(argSetting.getSendMaxRecipientAddrCc())));
        }

        if (argMessage.getBcc() == null) {
            // BccnullZbgĂꍇɂ́AK؂ɏB
            argMessage.setBcc(new ArrayList());
        }
        // Bcč`FbN͎{܂BBcc ło^ł̂Ƃ܂B

        // Subject͓K؂ɐݒ肳ĂKv܂B
        if (argMessage.getSubject() == null) {
            throw new IllegalArgumentException(fMsg.getMbmcs009());
        }
        if (argMessage.getSubject().trim().length() == 0) {
            throw new IllegalArgumentException(fMsg.getMbmcs010());
        }

        if (argMessage.getText() == null) {
            // {Ԃ͗OƂ܂B
            throw new IllegalArgumentException(fMsg.getMbmcs006());
        }

        // [wb_[̃`FbNB
        if (argMessage.getHeaderList() == null) {
            throw new IllegalArgumentException(fMsg.getMbmcs007());
        }
        for (int index = 0; index < argMessage.getHeaderList().size(); index++) {
            final Object objLook = argMessage.getHeaderList().get(index);
            if (objLook instanceof BlancoMailMessageHeader == false) {
                throw new IllegalArgumentException(fMsg.getMbmcs008(objLook
                        .getClass().toString(), objLook.toString()));
            }
        }

        // [̃`FbNB

        final HashMap mapTo = new HashMap();
        for (int index = 0; index < argMessage.getTo().size(); index++) {
            final Object objLook = argMessage.getTo().get(index);
            if (objLook instanceof BlancoMailAddress == false) {
                throw new IllegalArgumentException(fMsg.getMbmcs011(objLook
                        .getClass().toString(), objLook.toString()));
            }

            final BlancoMailAddress addr = (BlancoMailAddress) objLook;
            if (BlancoStringUtil.null2Blank(addr.getAddress()).length() == 0) {
                throw new IllegalArgumentException(fMsg.getMbmcs025(addr
                        .toString()));
            }

            // Toɏd铯AhXȂǂ`FbNB
            if (mapTo.get(addr.getAddress()) != null) {
                throw new IllegalArgumentException(fMsg.getMbmcs012(addr
                        .getAddress(), addr.toString()));
            }
            mapTo.put(addr.getAddress(), addr);
        }

        final HashMap mapCc = new HashMap();
        for (int index = 0; index < argMessage.getCc().size(); index++) {
            final Object objLook = argMessage.getCc().get(index);
            if (objLook instanceof BlancoMailAddress == false) {
                throw new IllegalArgumentException(fMsg.getMbmcs013(objLook
                        .getClass().toString(), objLook.toString()));
            }

            final BlancoMailAddress addr = (BlancoMailAddress) objLook;
            if (BlancoStringUtil.null2Blank(addr.getAddress()).length() == 0) {
                throw new IllegalArgumentException(fMsg.getMbmcs026(addr
                        .toString()));
            }

            // Ccɏd铯AhXȂǂ`FbNB
            if (mapCc.get(addr.getAddress()) != null) {
                throw new IllegalArgumentException(fMsg.getMbmcs014(addr
                        .getAddress(), addr.toString()));
            }
            mapCc.put(addr.getAddress(), addr);
        }

        final HashMap mapBcc = new HashMap();
        for (int index = 0; index < argMessage.getBcc().size(); index++) {
            final Object objLook = argMessage.getBcc().get(index);
            if (objLook instanceof BlancoMailAddress == false) {
                throw new IllegalArgumentException(fMsg.getMbmcs015(objLook
                        .getClass().toString(), objLook.toString()));
            }

            final BlancoMailAddress addr = (BlancoMailAddress) objLook;
            if (BlancoStringUtil.null2Blank(addr.getAddress()).length() == 0) {
                throw new IllegalArgumentException(fMsg.getMbmcs027(addr
                        .toString()));
            }

            // Bccɏd铯AhXȂǂ`FbNB
            if (mapBcc.get(addr.getAddress()) != null) {
                throw new IllegalArgumentException(fMsg.getMbmcs016(addr
                        .getAddress(), addr.toString()));
            }
            mapBcc.put(addr.getAddress(), addr);
        }

        // bZ[WeɂĖݒtB[h l̒B
        if (argMessage.getSentDate() == null) {
            // Mtݒ̏ꍇɂ }VtZbg܂B
            argMessage.setSentDate(new Date());
        }

        // Ytt@C̓e`FbNȂ܂B
        if (argMessage.getAttachmentList() == null) {
            throw new IllegalArgumentException(fMsg.getMbmcs017());
        }
        // Ytt@C̃g[^TCYB
        long totalAttachmentSize = 0;
        for (int indexAttachment = 0; indexAttachment < argMessage
                .getAttachmentList().size(); indexAttachment++) {
            final Object objAttachment = argMessage.getAttachmentList().get(
                    indexAttachment);

            if (objAttachment instanceof BlancoMailMessageAttachment == false) {
                // objAttachment.toString()͌ĂяoȂ悤ɂĂ܂B
                throw new IllegalArgumentException(fMsg
                        .getMbmcs018(objAttachment.getClass().toString()));
            }

            final BlancoMailMessageAttachment attachment = (BlancoMailMessageAttachment) argMessage
                    .getAttachmentList().get(indexAttachment);

            if (attachment.getData() == null) {
                // objAttachment.toString()͌ĂяoȂ悤ɂĂ܂B
                throw new IllegalArgumentException(fMsg.getMbmcs019());
            }

            // Ytt@C̃TCYώZ܂B
            totalAttachmentSize += attachment.getData().length;

            if (BlancoStringUtil.null2Blank(attachment.getMimeType()).length() == 0) {
                // objAttachment.toString()͌ĂяoȂ悤ɂĂ܂B
                throw new IllegalArgumentException(fMsg.getMbmcs020());
            }
            if (BlancoStringUtil.null2Blank(attachment.getFileName()).length() == 0) {
                // objAttachment.toString()͌ĂяoȂ悤ɂĂ܂B
                throw new IllegalArgumentException(fMsg.getMbmcs021());
            }
        }
        if (totalAttachmentSize > argSetting.getSendMaxTotalAttachmentSize()) {
            // Ytt@C̃g[^TCYVXeƂĂ̍ő勖eTCY𒴂ĂꍇB
            throw new IllegalArgumentException(fMsg.getMbmcs022(String
                    .valueOf(totalAttachmentSize), String.valueOf(argSetting
                    .getSendMaxTotalAttachmentSize())));
        }
    }

    /**
     * BlancoMailSetting̓ȇÓ؂܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     */
    private void checkSetting(final BlancoMailSetting argSetting) {
        if (argSetting == null) {
            throw new IllegalArgumentException(
                    "BlancoMailSender#checkSetting: \bh̃p[^(argSetting) nulln܂B̃IuWFNg nullłĂ͂Ȃ܂B");
        }

        // BlancoMailSetting̓e`FbNB
        if (argSetting.getSendHost() == null) {
            throw new IllegalArgumentException(fMsg.getMbmcs101());
        }
        if (argSetting.getSendSmtpAuth()) {
            // SMTPF؂Lłꍇɂ̓[UEpX[h̐ݒ󋵂`FbNB
            if (argSetting.getSendUserName() == null) {
                throw new IllegalArgumentException(fMsg.getMbmcs102());
            }
            if (argSetting.getSendPassword() == null) {
                throw new IllegalArgumentException(fMsg.getMbmcs103());
            }
        }
        if (argSetting.getSendMailerName() == null) {
            throw new IllegalArgumentException(fMsg.getMbmcs104());
        }
        if (argSetting.getSendEncoding() == null) {
            throw new IllegalArgumentException(fMsg.getMbmcs105());
        }

        if (Charset.isSupported(argSetting.getSendEncoding()) == false) {
            throw new IllegalArgumentException(fMsg.getMbmcs106(argSetting
                    .getSendEncoding()));
        }

        // [Mŋʂ BlancoMailSetting̐ݒe`FbNB
        BlancoMailCoreUtil.checkSetting(argSetting);
    }

    /**
     * JavaMail API ZbVIuWFNgɕKvƂȂvpeBIuWFNg܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argProps
     *            ڑɊւvpeBIuWFNgB̃IuWFNgJavaMail APIĂяo̐ڑ񂪃Zbg܂B
     */
    private void prepareSessionProperties(final BlancoMailSetting argSetting,
            final Properties argProps) {
        if (argSetting == null) {
            throw new IllegalArgumentException(
                    "BlancoMailSender#prepareSessionProperties: \bh̃p[^(argSetting) nulln܂B̃IuWFNg nullłĂ͂Ȃ܂B");
        }
        if (argProps == null) {
            throw new IllegalArgumentException(
                    "BlancoMailSender#prepareSessionProperties: \bh̃p[^(argProps) nulln܂B̃IuWFNg nullłĂ͂Ȃ܂B");
        }

        // {B
        argProps.setProperty("mail.smtp.host", argSetting.getSendHost());
        if (argSetting.getSendPort() >= 0) {
            // |[gԍύXB
            argProps.setProperty("mail.smtp.port", String.valueOf(argSetting
                    .getSendPort()));
        }

        // ^CAEgݒ
        if (argSetting.getMailConnectionTimeout() > 0) {
            argProps.setProperty("mail.smtp.connectiontimeout", String
                    .valueOf(argSetting.getMailConnectionTimeout()));
        }
        if (argSetting.getMailTimeout() > 0) {
            argProps.setProperty("mail.smtp.timeout", String.valueOf(argSetting
                    .getMailTimeout()));
        }

        // F
        if (argSetting.getSendSmtpAuth()) {
            argProps.setProperty("mail.smtp.auth", "true");
        }

        if (argSetting.getSendUseSsl()) {
            // SSL֘Aݒ
            argProps.setProperty("mail.smtp.socketFactory.class", argSetting
                    .getSocketfactoryClass());
            argProps.setProperty("mail.smtp.socketFactory.fallback", String
                    .valueOf(argSetting.getSocketfactoryFallback()));
            if (argSetting.getSendPort() >= 0) {
                // |[gԍύXB
                argProps.setProperty("mail.smtp.socketFactory.port", String
                        .valueOf(argSetting.getSendPort()));
            }
        }

        if (BlancoStringUtil.null2Blank(argSetting.getSendLocalHost()).length() > 0) {
            // SMTPT[oɂẮA[JzXgɃhC܂܂ĂȂƐڑۂ݂̂悤łB
            // ̂悤ȏꍇɂ́A[JzXg𖾎IɎw肵ē삳KvoĂ܂B
            argProps.setProperty("mail.smtp.localhost", argSetting
                    .getSendLocalHost());
        }
    }

    /**
     * JavaMail API ZbVIuWFNgɕKvƂȂvpeBIuWFNgɂāAbZ[Wݒ肷ׂl܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argMessage
     *            M[{̂킷o[IuWFNgB̃IuWFNg̓e`FbN܂B
     * @param argProps
     *            ڑɊւvpeBIuWFNgB̃IuWFNgJavaMail APIĂяo̐ڑ񂪃Zbg܂B
     */
    private void prepareSessionPropertiesWithMessage(
            final BlancoMailSetting argSetting,
            final BlancoMailMessage argMessage, final Properties argProps) {
        if (argSetting == null) {
            throw new IllegalArgumentException(
                    "BlancoMailSender#prepareSessionPropertiesWithMessage: \bh̃p[^(argSetting) nulln܂B̃IuWFNg nullłĂ͂Ȃ܂B");
        }
        if (argMessage == null) {
            throw new IllegalArgumentException(
                    "BlancoMailSender#prepareSessionPropertiesWithMessage: \bh̃p[^(argMessage) nulln܂B̃IuWFNg nullłĂ͂Ȃ܂B");
        }
        if (argProps == null) {
            throw new IllegalArgumentException(
                    "BlancoMailSender#prepareSessionPropertiesWithMessage: \bh̃p[^(argProps) nulln܂B̃IuWFNg nullłĂ͂Ȃ܂B");
        }

        if (argSetting.getSendUseFromAddressAsMessageId()) {
            // FromAhXAMessage-ID̈ꕔɗp悤ɐݒ肵܂B
            // ̓Iɂ mail.from ɑ΂āuFromAhXvݒ肵܂B
            // FromAhX̃j[NMessage-IDւƊp@łB
            argProps
                    .setProperty("mail.from", argMessage.getFrom().getAddress());
        }
    }

    /**
     * JavaMail API oRăgX|[g([T[o)ɐڑ܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argSession
     *            JavaMail̃ZbVIuWFNgB
     * @return JavaMail̃gX|[gIuWFNgB
     * @throws ConnectException
     *             [T[oւ̐ڑsɊւOB
     */
    private Transport connectTransport(final BlancoMailSetting argSetting,
            final Session argSession) throws ConnectException {
        if (argSetting == null) {
            throw new IllegalArgumentException(
                    "BlancoMailSender#connectTransport: \bh̃p[^(argSetting) nulln܂B̃IuWFNg nullłĂ͂Ȃ܂B");
        }
        if (argSession == null) {
            throw new IllegalArgumentException(
                    "BlancoMailSender#connectTransport: \bh̃p[^(argSession) nulln܂B̃IuWFNg nullłĂ͂Ȃ܂B");
        }

        Transport transport = null;

        try {
            // w̃voC_̎擾Ɏsꍇ (gX|[gw̎擾)B
            transport = argSession.getTransport(argSetting.getSendProtocol());
        } catch (NoSuchProviderException e) {
            fStatistics.setSendErrorCount(fStatistics.getSendErrorCount() + 1);
            throw new ConnectException(fMsg.getMbmcs201(argSetting
                    .getSendProtocol(), e.toString()));
        }

        try {
            transport.connect();
        } catch (AuthenticationFailedException e) {
            // F؎s ɓ܂B
            fStatistics.setSendErrorCount(fStatistics.getSendErrorCount() + 1);
            throw new ConnectException(fMsg.getMbmcs202(argSetting
                    .getSendUserName(), e.toString()));
        } catch (MessagingException e) {
            // smtpT[oւ̐ڑs ɓ܂B
            fStatistics.setSendErrorCount(fStatistics.getSendErrorCount() + 1);
            throw new ConnectException(fMsg.getMbmcs203(argSetting
                    .getSendHost(), e.toString()));
        }

        return transport;
    }

    /**
     * ۂJavaMailɈnbZ[W{擾܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argMessage
     *            M[{̂킷o[IuWFNgB
     * @return H̃bZ[W{B(ݒlɏ]sǉ)
     */
    private String getActualMessageText(final BlancoMailSetting argSetting,
            final BlancoMailMessage argMessage) {
        if (argSetting.getSendForthNewlineAfterMessageText()) {
            // {̃[\tgɑΉ邽߂ɁA{eLXǧɋsPsǉĂ܂B
            // Ytt@CȂ[̏ꍇɂA肪邱Ƃ\h邽߂ɋsPsǉĂ܂B
            // Ytt@Ct[̏ꍇA{eLXǧɋsPs K؂ɓYtt@CoȂ[ւ̑ΉłB
            return argMessage.getText() + "\n";
        } else {
            return argMessage.getText();
        }
    }
}