/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.http;

import blanco.http.resourcebundle.BlancoHttpMethodSettingResourceBundle;
import blanco.http.valueobject.BlancoHttpMethodSetting;

/**
 * BlancoHttpMethodSetting̃CX^X́ÃNX擾ĂB
 *
 * o[IuWFNg[BlancoHttpMethodSetting]̃CX^XK؂ȃftHgltŎ擾邽߂̃NXB
 */
public class BlancoHttpMethodSettingFactory {
    /**
     * RXgN^͉B܂B
     */
    private BlancoHttpMethodSettingFactory() {
    }

    /**
     * o[IuWFNg[BlancoHttpMethodSetting]̃CX^X擾܂B
     *
     * \[Xoh(ꖼ:BlancoHttpMethodSetting, NX:BlancoHttpMethodSettingResourceBundle)ftHgl̓ǂݍ݂݂܂B
     *
     * @return ftHglς݂[BlancoHttpMethodSetting]o[IuWFNgB
     */
    public static BlancoHttpMethodSetting getInstance() {
        // ̃\bh̎sʂƂȂo[IuWFNgCX^XB
        final BlancoHttpMethodSetting result = new BlancoHttpMethodSetting();

        // o[IuWFNgɐݒ肷ftHgl̂߂̃f[^\[XCX^XB
        final BlancoHttpMethodSettingResourceBundle bundle = new BlancoHttpMethodSettingResourceBundle();

        // tB[h [PROXY_HOST]
        if (bundle.getProxyHost() != null && bundle.getProxyHost().length() > 0) {
            result.setProxyHost(bundle.getProxyHost());
        }

        // tB[h [PROXY_PORT]
        if (bundle.getProxyPort() != null && bundle.getProxyPort().length() > 0) {
            try {
                result.setProxyPort(Integer.parseInt(bundle.getProxyPort()));
            } catch (NumberFormatException e) {
                // ܂B
            }
        }

        // tB[h [PROXY_USER_NAME]
        if (bundle.getProxyUserName() != null && bundle.getProxyUserName().length() > 0) {
            result.setProxyUserName(bundle.getProxyUserName());
        }

        // tB[h [PROXY_PASSWORD]
        if (bundle.getProxyPassword() != null && bundle.getProxyPassword().length() > 0) {
            result.setProxyPassword(bundle.getProxyPassword());
        }

        // tB[h [CONNECTION_TIMEOUT]
        if (bundle.getConnectionTimeout() != null && bundle.getConnectionTimeout().length() > 0) {
            try {
                result.setConnectionTimeout(Integer.parseInt(bundle.getConnectionTimeout()));
            } catch (NumberFormatException e) {
                // ܂B
            }
        }

        // tB[h [CONNECTION_SO_TIMEOUT]
        if (bundle.getConnectionSoTimeout() != null && bundle.getConnectionSoTimeout().length() > 0) {
            try {
                result.setConnectionSoTimeout(Integer.parseInt(bundle.getConnectionSoTimeout()));
            } catch (NumberFormatException e) {
                // ܂B
            }
        }

        // tB[h [METHOD_RETRY_COUNT]
        if (bundle.getMethodRetryCount() != null && bundle.getMethodRetryCount().length() > 0) {
            try {
                result.setMethodRetryCount(Integer.parseInt(bundle.getMethodRetryCount()));
            } catch (NumberFormatException e) {
                // ܂B
            }
        }

        return result;
    }
}
