/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoStringUtil;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.util.BlancoDbCgUtilJava;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author tosiki iga
 */
public class PrepareStatementMethod2 extends BlancoDbAbstractMethod {
    public PrepareStatementMethod2(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                "prepareStatement", "^ꂽSQLăvRpC{(ISQL)܂B");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod
                .getParameterList()
                .add(
                        fCgFactory
                                .createParameter("query", "java.lang.String",
                                        "vRpC{SQLBISQL̏ꍇɂ́Äɂ͉Hꂽ̎s\SQL^܂B"));

        BlancoDbCgUtilJava.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        final List listDesc = cgMethod.getLangDoc().getDescriptionList();

        listDesc.add("Iɓeω悤SQLsKvꍇɂ̂݁Ã\bh𗘗p܂B<br>");

        listDesc
                .add("ł͂Ȃꍇɂ́Ã\bh̗p͔ prepareStatement()\bh (Ȃ)ĂяoĂB<br>");
        listDesc
                .add("ȂȂÃ\bhłSQL̂̂p[^Ƃė^邱ƂłĎRxASQLCWFNVƌĂ΂ZLeBz[\NĂ܂łB<br>");
        listDesc.add("IConnection.prepareStatementĂяo܂B<br>");

        if (BlancoStringUtil.null2Blank(fSqlInfo.getScroll()).length() == 0) {
            // w肪ꍇɂ́ALangDocɏo͂܂B
        } else if (fSqlInfo.getScroll().equals("forward_only")
                && fSqlInfo.getUpdatable() == false) {
            // J[\ŊXV\OFF̏ꍇɂ́ALangDocɏo͂܂B
        } else {
            listDesc.add("XN[: " + fSqlInfo.getScroll());
            if (fSqlInfo.getUpdatable()) {
                listDesc.add("XV\: L");
            }
        }

        final List listLine = cgMethod.getLineList();

        if (fDbSetting.getLogging()) {
            listLine.add("if (fLog.isDebugEnabled()) {");
            listLine.add("fLog.debug(\"" + cgMethod.getName()
                    + ": query = \" + query);");
            listLine.add("}");
            listLine.add("");
        }

        listLine.add("close();");

        if (BlancoStringUtil.null2Blank(fSqlInfo.getScroll()).length() == 0) {
            listLine.add("fStatement = fConnection.prepareStatement(query);");
        } else if (fSqlInfo.getScroll().equals("forward_only")
                && fSqlInfo.getUpdatable() == false) {
            // p[^̃oG[VPȏꍇɂ́APprepareStatementĂяoB
            listLine.add("fStatement = fConnection.prepareStatement(query);");
        } else {
            String resultSetType = "ResultSet.TYPE_FORWARD_ONLY";
            String resultSetConcurrency = "ResultSet.CONCUR_READ_ONLY";
            if (fSqlInfo.getScroll().equals("insensitive")) {
                resultSetType = "ResultSet.TYPE_SCROLL_INSENSITIVE";
            } else if (fSqlInfo.getScroll().equals("sensitive")) {
                resultSetType = "ResultSet.TYPE_SCROLL_SENSITIVE";
            }
            if (fSqlInfo.getUpdatable()) {
                resultSetConcurrency = "ResultSet.CONCUR_UPDATABLE";
            }
            listLine.add("fStatement = fConnection.prepareStatement(query, "
                    + resultSetType + ", " + resultSetConcurrency + ");");
        }

        if (fDbSetting.getStatementTimeout() >= 0) {
            listLine.add("// Xe[gg^CAEglɂăftHglZbg܂B");
            listLine.add("fStatement.setQueryTimeout("
                    + fDbSetting.getStatementTimeout() + ");");
        }
    }
}