/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.js;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.util.BlancoCgLineUtil;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgField\[XR[hւƓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgFieldJsSourceExpander {
    /**
     * ̃NXΏۂƂvO~OB
     */
    protected static final int TARGET_LANG = BlancoCgSupportedLang.JS;

    /**
     * ŃtB[hWJ܂B
     * 
     * @param cgClass
     *            ΏۂƂȂNXB
     * @param cgField
     *            ΏۂƂȂtB[hB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            o͐sXgB
     */
    public void transformField(final BlancoCgClass cgClass,
            final BlancoCgField cgField,
            final BlancoCgSourceFile argSourceFile, final List argSourceLines) {
        if (BlancoStringUtil.null2Blank(cgField.getName()).length() == 0) {
            throw new IllegalArgumentException("tB[h̖OɓK؂Ȓlݒ肳Ă܂B");
        }
        if (BlancoStringUtil.null2Blank(cgField.getType().getName()).length() == 0) {
            throw new IllegalArgumentException("tB[h[" + cgField.getName()
                    + "]̌^K؂Ȓlݒ肳Ă܂B");
        }

        // L킳st^܂B
        argSourceLines.add("");

        // ŏɃtB[hLangDocɓWJB
        if (cgField.getLangDoc() == null) {
            // LangDocw̏ꍇɂ͂瑤ŃCX^X𐶐B
            cgField.setLangDoc(new BlancoCgLangDoc());
        }
        if (cgField.getLangDoc().getTitle() == null) {
            cgField.getLangDoc().setTitle(cgField.getDescription());
        }

        if (BlancoStringUtil.null2Blank(cgField.getAccess()).equals("private")
                || BlancoStringUtil.null2Blank(cgField.getAccess()).equals(
                        "protected")) {
            // protected ܂ private ̏ꍇɂ̂݃XR[v\WJ܂B
            cgField.getLangDoc().getTagList().add(
                    BlancoCgObjectFactory.getInstance().createLangDocTag(
                            cgField.getAccess(), null, ""));
        }

        if (BlancoStringUtil.null2Blank(cgField.getType().getName()).length() > 0
                || BlancoStringUtil.null2Blank(cgField.getType().getName())
                        .equals("void") == false) {
            cgField.getLangDoc().getTagList().add(
                    BlancoCgObjectFactory.getInstance().createLangDocTag(
                            "type", null, cgField.getType().getName()));
        }

        //  LangDoc\[XR[h`ɓWJB
        new BlancoCgLangDocJsSourceExpander().transformLangDoc(cgField
                .getLangDoc(), argSourceLines);

        final StringBuffer buf = new StringBuffer();

        if (cgField.getStatic()) {
            // NXtB[h (staticȃtB[h)́AL̂悤ɃNX.tB[hŒړWJ܂B
            buf.append(cgClass.getName() + ".");
        } else {
            // ʏ̃tB[hϐ this.tB[h ̂悤ɓWJ܂B
            buf.append("this.");
        }

        // tB[h̖{̕WJ܂B
        buf.append(cgField.getName());

        // ftHgl̎w肪ꍇɂ͂WJ܂B
        if (BlancoStringUtil.null2Blank(cgField.getDefault()).length() > 0) {
            buf.append(" = " + cgField.getDefault()
                    + BlancoCgLineUtil.getTerminator(TARGET_LANG));
        } else {
            buf.append(" = null"
                    + BlancoCgLineUtil.getTerminator(TARGET_LANG));
        }

        argSourceLines.add(buf.toString());

        // importɌ^ǉB
        argSourceFile.getImportList().add(cgField.getType().getName());
    }
}
