/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.test.valueobject.method;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.test.valueobject.resourcebundle.BlancoValueObjectTestResourceBundle;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

/**
 * String^̃tB[ĥ߂JUnitpJava\[XR[h܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectXml2JUnitPrimitiveShortMethod {
    private final BlancoValueObjectTestResourceBundle fBundleTest = new BlancoValueObjectTestResourceBundle();

    /**
     * \bhWJ܂B
     * 
     * @param methodName
     *            \bhB
     * @param classInfo
     *            ͂ƂȂNXB
     * @param fieldInfo
     *            ͂ƂȂtB[hB
     * @param isNameAdjust
     *            Oό`sǂB
     * @param argFactory
     *            blancoCgt@NgB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argClass
     *            o͐NXB
     */
    public void expand(final String methodName,
            final BlancoValueObjectClassStructure classInfo,
            final BlancoValueObjectFieldStructure field,
            final boolean argNameAdjust,
            final BlancoCgObjectFactory argFactory,
            final BlancoCgSourceFile argSourceFile, final BlancoCgClass argClass) {
        final BlancoCgMethod method = argFactory.createMethod(methodName,
                fBundleTest.getMethodJavadoc001(field.getName()));
        argClass.getMethodList().add(method);

        method.getThrowList().add(
                argFactory.createException("java.lang.Exception", ""));

        method.getLangDoc().getDescriptionList().add(
                fBundleTest.getMethodJavadoc002(classInfo.getName(), field
                        .getName(), field.getType()));

        final List listLine = method.getLineList();

        final String fieldNameAdjustered = (argNameAdjust == false ? field
                .getName() : BlancoNameAdjuster.toClassName(field.getName()));

        listLine.add(fBundleTest.getMethodPrimitiveShortB01L01());
        listLine.add(fBundleTest.getMethodPrimitiveShortB01L02(classInfo
                .getName()));
        listLine.add(fBundleTest.getMethodPrimitiveShortB01L03());

        if (field.getDefault() == null) {
            listLine.add(fBundleTest.getMethodPrimitiveShortB02L01());
            listLine.add(fBundleTest.getMethodPrimitiveShortB02L02(classInfo
                    .getName(), field.getName(), fieldNameAdjustered));
        } else {
            listLine.add(fBundleTest.getMethodPrimitiveShortB03L01());
            listLine.add(fBundleTest.getMethodPrimitiveShortB03L02(classInfo
                    .getName(), field.getName(), field.getDefault(),
                    BlancoJavaSourceUtil.escapeStringAsJavaSource(field
                            .getDefault()), fieldNameAdjustered));
        }
        listLine.add(fBundleTest.getMethodPrimitiveShortB03L03());

        listLine.add(fBundleTest.getMethodPrimitiveShortB04L01());
        listLine.add(fBundleTest
                .getMethodPrimitiveShortB04L02(fieldNameAdjustered));
        listLine.add(fBundleTest.getMethodPrimitiveShortB04L03(classInfo
                .getName(), field.getName(), fieldNameAdjustered));
        listLine.add(fBundleTest.getMethodPrimitiveShortB04L04());

        listLine.add(fBundleTest.getMethodPrimitiveShortB05L01());
        listLine.add(fBundleTest
                .getMethodPrimitiveShortB05L02(fieldNameAdjustered));
        listLine.add(fBundleTest.getMethodPrimitiveShortB05L03(classInfo
                .getName(), field.getName(), fieldNameAdjustered));
        listLine.add(fBundleTest.getMethodPrimitiveShortB05L04());

        listLine.add(fBundleTest.getMethodPrimitiveShortB06L01());
        listLine.add(fBundleTest
                .getMethodPrimitiveShortB06L02(fieldNameAdjustered));
        listLine.add(fBundleTest.getMethodPrimitiveShortB06L03(classInfo
                .getName(), field.getName(), fieldNameAdjustered));
        listLine.add(fBundleTest.getMethodPrimitiveShortB06L04());
    }
}
