/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.db.resourcebundle;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[BlancoDb]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoDbResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoDbResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoDb]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoDbResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoDb");
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AftHg̃P[AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoDbResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoDb]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoDbResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoDb", locale);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AP[[" + locale.toString() + "]AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoDbResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoDb]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoDbResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoDb", locale, loader);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AP[[" + locale.toString() + "]Aw̃NX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * bundle[BlancoDb], key[METAFILE_DISPLAYNAME]
     *
     * [SQL`] (ja)<br>
     *
     * @return key[METAFILE_DISPLAYNAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMetafileDisplayname() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SQL`";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("METAFILE_DISPLAYNAME");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[METAFILE_DISPLAYNAME]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[META2XML.ELEMENT_COMMON]
     *
     * [blancodb-common] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_COMMON]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementCommon() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancodb-common";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_COMMON");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[META2XML.ELEMENT_COMMON]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[SELECT.SCROLL]
     *
     * [forward_only] (ja)<br>
     *
     * @return key[SELECT.SCROLL]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSelectScroll() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "forward_only";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SELECT.SCROLL");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[SELECT.SCROLL]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[SELECT_ALL.SCROLL]
     *
     * [insensitive] (ja)<br>
     *
     * @return key[SELECT_ALL.SCROLL]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSelectAllScroll() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "insensitive";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SELECT_ALL.SCROLL");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[SELECT_ALL.SCROLL]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[SELECT_UPDATABLE.SCROLL]
     *
     * [insensitive] (ja)<br>
     *
     * @return key[SELECT_UPDATABLE.SCROLL]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSelectUpdatableScroll() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "insensitive";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SELECT_UPDATABLE.SCROLL");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[SELECT_UPDATABLE.SCROLL]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[TYPE_MAPPING.FAIL_ON_ERROR]
     *
     * [true] (ja)<br>
     *
     * @return key[TYPE_MAPPING.FAIL_ON_ERROR]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTypeMappingFailOnError() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "true";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TYPE_MAPPING.FAIL_ON_ERROR");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TYPE_MAPPING.FAIL_ON_ERROR]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[TYPE_MAPPING.ERR001]
     *
     * [^}bsOƂăT|[gȂJDBC^({0,number}/{1})܂Bf܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.math.BigDecimal^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[TYPE_MAPPING.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTypeMappingErr001(final BigDecimal arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "^}bsOƂăT|[gȂJDBC^({0,number}/{1})܂Bf܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TYPE_MAPPING.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TYPE_MAPPING.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoDb], key[SIMPLE.COL.BINARY_ASCII.SELECT.SINGLEROW]
     *
     * [false] (ja)<br>
     *
     * @return key[SIMPLE.COL.BINARY_ASCII.SELECT.SINGLEROW]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getSimpleColBinaryAsciiSelectSinglerow() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "false";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("SIMPLE.COL.BINARY_ASCII.SELECT.SINGLEROW");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[SIMPLE.COL.BINARY_ASCII.SELECT.SINGLEROW]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[XML2JAVACLASS.ERR001]
     *
     * [SQL`ID[{0}]́uSQLv擾ł܂łBSQLK؂ɋLڂĂ邱ƂmFĂB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SQL`ID[{0}]́uSQLv擾ł܂łBSQLK؂ɋLڂĂ邱ƂmFĂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[XML2JAVACLASS.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoDb], key[XML2JAVACLASS.ERR002]
     *
     * [SQL`ID[{0}]ɂSQLO܂BSQL`ID[{0}]SQLSQL̓p[^Ɍ肪܂܂ĂȂׂĂBSQLState[{1}] G[R[h[{2,number}] bZ[W[{3}]] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.math.BigDecimal^^ĂB
     * @param arg3 u{3}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr002(final String arg0, final String arg1, final BigDecimal arg2, final String arg3) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SQL`ID[{0}]ɂSQLO܂BSQL`ID[{0}]SQLSQL̓p[^Ɍ肪܂܂ĂȂׂĂBSQLState[{1}] G[R[h[{2,number}] bZ[W[{3}]";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR002");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[XML2JAVACLASS.ERR002]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2, arg3}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoDb], key[XML2JAVACLASS.ERR003]
     *
     * [SQL`ID[{0}]ɂāBĂĂ͂ȂoHɓ܂BT|[gȂ^[{1}]ɗ^܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr003(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SQL`ID[{0}]ɂāBĂĂ͂ȂoHɓ܂BT|[gȂ^[{1}]ɗ^܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR003");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[XML2JAVACLASS.ERR003]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoDb], key[XML2JAVACLASS.ERR004]
     *
     * [SQL`ID[{0}]SQL̓p[^{1}ɂāAp[^IDw肳Ȃ^[{2}]o܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr004(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SQL`ID[{0}]SQL̓p[^{1}ɂāAp[^IDw肳Ȃ^[{2}]o܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR004");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[XML2JAVACLASS.ERR004]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoDb], key[XML2JAVACLASS.ERR005]
     *
     * [SQL`ID[{0}]SQL̓p[^{1}ɂāAp[^ID[{2}]̌^w肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR005]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr005(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SQL`ID[{0}]SQL̓p[^{1}ɂāAp[^ID[{2}]̌^w肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR005");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[XML2JAVACLASS.ERR005]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoDb], key[XML2JAVACLASS.ERR006]
     *
     * [SQL`ID[{0}]SQLo̓p[^{1}ɂāAp[^IDw肳Ȃ^[{2}]o܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR006]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr006(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SQL`ID[{0}]SQLo̓p[^{1}ɂāAp[^IDw肳Ȃ^[{2}]o܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR006");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[XML2JAVACLASS.ERR006]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoDb], key[XML2JAVACLASS.ERR007]
     *
     * [SQL`ID[{0}]SQLo̓p[^{1}ɂāAp[^ID[{2}]̌^w肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR007]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr007(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SQL`ID[{0}]SQLo̓p[^{1}ɂāAp[^ID[{2}]̌^w肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR007");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[XML2JAVACLASS.ERR007]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoDb], key[XML2JAVACLASS.ERR008]
     *
     * [SQL`ID[{0}]́uďo^vłȂ̂SQLo̓p[^{1}Ap[^ID[{2}]w肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR008]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr008(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SQL`ID[{0}]́uďo^vłȂ̂SQLo̓p[^{1}Ap[^ID[{2}]w肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR008");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[XML2JAVACLASS.ERR008]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoDb], key[XML2JAVACLASS.ERR009]
     *
     * [SQL`ID[{0}]ɂ uSQLvтĂȂSQL̓p[^[{1}]܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR009]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr009(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SQL`ID[{0}]ɂ uSQLvтĂȂSQL̓p[^[{1}]܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR009");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[XML2JAVACLASS.ERR009]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoDb], key[TASK.ERR001]
     *
     * [SQLO܂Bf܂B] (ja)<br>
     *
     * @return key[TASK.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTaskErr001() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SQLO܂Bf܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TASK.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TASK.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[TASK.ERR002]
     *
     * [NX܂BNXpX̐ݒȂǂmFĂB] (ja)<br>
     *
     * @return key[TASK.ERR002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTaskErr002() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "NX܂BNXpX̐ݒȂǂmFĂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TASK.ERR002");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TASK.ERR002]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[TASK.ERR003]
     *
     * [z肳ȂSAXO܂Bf܂B] (ja)<br>
     *
     * @return key[TASK.ERR003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTaskErr003() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "z肳ȂSAXO܂Bf܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TASK.ERR003");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TASK.ERR003]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[TASK.ERR004]
     *
     * [z肳Ȃo͗O܂Bf܂B] (ja)<br>
     *
     * @return key[TASK.ERR004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTaskErr004() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "z肳Ȃo͗O܂Bf܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TASK.ERR004");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TASK.ERR004]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[TASK.ERR005]
     *
     * [z肳ȂXMLp[TO܂Bf܂B] (ja)<br>
     *
     * @return key[TASK.ERR005]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTaskErr005() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "z肳ȂXMLp[TO܂Bf܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TASK.ERR005");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TASK.ERR005]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[TASK.ERR006]
     *
     * [z肳ȂXMLgXtH[}[O܂Bf܂B] (ja)<br>
     *
     * @return key[TASK.ERR006]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTaskErr006() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "z肳ȂXMLgXtH[}[O܂Bf܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TASK.ERR006");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TASK.ERR006]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }
}
