/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import blanco.db.definition.QueryIterator;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class ExecuteQueryMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    public ExecuteQueryMethod(final BlancoDbObjectStorage storage,
            final QueryIterator iterator) {
        super("executeQuery");
        this.storage = storage;
    }

    public void setupSignature() {
        // ^CpbP[W̕ωɑΉB
        String runtimePackage = storage.getSetting().getRootNameSpace();
        if (storage.getSetting().getRuntimePackage() != null) {
            runtimePackage = storage.getSetting().getRuntimePackage();
        }

        final Type deadlockException = new Type(runtimePackage
                + ".exception.DeadlockException");
        getJavaDoc().addException(deadlockException, "f[^x[XfbhbNꍇB");
        addException(deadlockException);

        final Type timeoutException = new Type(runtimePackage
                + ".exception.TimeoutException");
        getJavaDoc().addException(timeoutException, "f[^x[X^CAEgꍇB");
        addException(timeoutException);

        getJavaDoc().addException(new Type("java.sql.SQLException"),
                "SQLOꍇB");
        addException(new Type("java.sql.SQLException"));

        getJavaDoc().addLine("^NGs܂B<br>");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        // statementmۂł΂AIprepareStatementĂяo܂B
        implementor.addLine("if (fStatement == null) {");
        implementor
                .addLine("// PreparedStatement擾̏ԂȂ̂ŁAPreparedStatement.executeQuery()sɐ旧prepareStatement()\bhĂяoĎ擾܂B");
        implementor.addStatement("prepareStatement()");
        implementor.addLine("}");

        // resultSetԂł΁Acloses܂B
        implementor.addLine("if (fResultSet != null) {");
        implementor.addLine("// ǑʃZbg(ResultSet)cĂ̂ŁAUJ܂B");
        implementor.addLine("fResultSet.close();");
        implementor.addLine("fResultSet = null;");
        implementor.addLine("}");

        implementor.addLine("");
        implementor.addLine("try {");
        implementor.addLine("fResultSet = fStatement.executeQuery();");
        implementor.addLine("} catch (SQLException ex) {");
        implementor.addLine("throw BlancoDbUtil.convertToBlancoException(ex);");
        implementor.addLine("}");
    }
}