/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.definition;

import java.util.Iterator;

import blanco.db.conf.SelectQuery;

/**
 * @author Yasuo Nakanishi
 */
public class QueryIterator {

    private SelectQuery _selectQuery = null;

    public QueryIterator(final SelectQuery selectQuery) {
        _selectQuery = selectQuery;
    }

    public int getFieldCount() {
        return _selectQuery.getInParameterList().size();
    }

    public QueryField getField(final int index) {
        return (QueryField) _selectQuery.getInParameterList().get(index);
    }

    public Iterator getFieldIterator() {
        return _selectQuery.getFieldIterator();
    }

    public String getName() {
        return _selectQuery.getName();
    }

    public Iterator getInParameterIterator() {
        return _selectQuery.getInParameterIterator();
    }

    public String getQuery() {
        return _selectQuery.getQuery();
    }

    public void setQuery(final String query) {
        _selectQuery.setQuery(query);
    }

    public String getScrollInterface() {
        return _selectQuery.getScrollInterface();
    }

    public boolean isEnableUpdatableInterface() {
        return _selectQuery.isEnableUpdatableInterface();
    }

    public boolean isSingle() {
        return _selectQuery.isSingle();
    }
}