/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.test.valueobject.method;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.ig.expander.Type;
import blanco.ig.expander.method.MethodExpander;
import blanco.test.valueobject.resourcebundle.BlancoValueObjectTestResourceBundle;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

/**
 * boolean^̃tB[ĥ߂JUnitpJava\[XR[h܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectXml2JUnitBooleanMethod extends MethodExpander {
    private final BlancoValueObjectTestResourceBundle bundle = new BlancoValueObjectTestResourceBundle();

    /**
     * tB[h⃁\bh̖Oό`sǂB
     */
    private boolean fNameAdjust = true;

    private BlancoValueObjectClassStructure classInfo = null;

    private BlancoValueObjectFieldStructure field = null;

    /**
     * String^̃tB[h邽߂̃\bhNX̃RXgN^
     * 
     * @param arg
     *            \bh
     * @param classStructure
     *            ݏ̃NX\
     * @param fieldInfo
     *            ݏ̃tB[h
     * @param isNameAdjust
     *            Oό`sǂB
     */
    public BlancoValueObjectXml2JUnitBooleanMethod(final String arg,
            final BlancoValueObjectClassStructure classStructure,
            final BlancoValueObjectFieldStructure fieldInfo,
            final boolean isNameAdjust) {
        super(arg);
        classInfo = classStructure;
        field = fieldInfo;
        fNameAdjust = isNameAdjust;
    }

    /**
     * \bh̃VOj`w
     */
    public void setupSignature() {
        addException(new Type("java.lang.Exception"));
        getJavaDoc().addLine(bundle.getMethodJavadoc001(field.getName()));
        getJavaDoc().addLine(
                bundle.getMethodJavadoc002(classInfo.getName(),
                        field.getName(), field.getType()));
    }

    /**
     * \bh̎
     */
    public void implement() {
        final String fieldNameAdjustered = (fNameAdjust == false ? field
                .getName() : BlancoNameAdjuster.toClassName(field.getName()));

        getData().addLine(bundle.getMethodBooleanB01L01());
        getData().addLine(bundle.getMethodBooleanB01L02(classInfo.getName()));
        getData().addLine(bundle.getMethodBooleanB01L03());

        if (field.getDefault() == null) {
            getData().addLine(bundle.getMethodBooleanB02L01());
            getData().addLine(
                    bundle.getMethodBooleanB02L02(classInfo.getName(), field
                            .getName(), fieldNameAdjustered));
        } else {
            getData().addLine(bundle.getMethodBooleanB03L01());
            getData().addLine(
                    bundle.getMethodBooleanB03L02(classInfo.getName(), field
                            .getName(), field.getDefault(),
                            BlancoJavaSourceUtil.escapeStringAsJavaSource(field
                                    .getDefault()), fieldNameAdjustered));
        }
        getData().addLine(bundle.getMethodBooleanB03L03());

        getData().addLine(bundle.getMethodBooleanB04L01());
        getData().addLine(bundle.getMethodBooleanB04L02(fieldNameAdjustered));
        getData().addLine(
                bundle.getMethodBooleanB04L03(classInfo.getName(), field
                        .getName(), fieldNameAdjustered));
        getData().addLine(bundle.getMethodBooleanB04L04());

        getData().addLine(bundle.getMethodBooleanB05L01());
        getData().addLine(bundle.getMethodBooleanB05L02(fieldNameAdjustered));
        getData().addLine(
                bundle.getMethodBooleanB05L03(classInfo.getName(), field
                        .getName(), fieldNameAdjustered));
        getData().addLine(bundle.getMethodBooleanB05L04());

        getData().addLine(bundle.getMethodBooleanB06L01());
        getData().addLine(bundle.getMethodBooleanB06L02());
        getData().addLine(bundle.getMethodBooleanB06L03(fieldNameAdjustered));
        getData().addLine(
                bundle.getMethodBooleanB06L04(classInfo.getName(), field
                        .getName(), fieldNameAdjustered));
        getData().addLine(bundle.getMethodBooleanB06L05());
    }
}
