/*
 * blancoCodeGenerator
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.field;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgField;
import blanco.commons.util.BlancoStringUtil;
import blanco.ig.expander.BlancoCodeGeneratorUtil;
import blanco.ig.expander.Expander;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.javadoc.MethodJavaDoc;

/**
 * blancoCodeGenerator̃tB[h킷NXłB
 * 
 * @author Yasuo Nakanishi (1st version)
 * @author IGA Tosiki (2nd version)
 */
public class FieldExpander extends Expander {
    /**
     * blanco Framework̃IuWFNgt@NgB
     */
    private final BlancoCgObjectFactory fCgFactory = BlancoCgObjectFactory
            .getInstance();

    /**
     * blancoCgField\B
     */
    private BlancoCgField fCgField = null;

    /**
     * blancoCodeGeneratorIɕێ JavaDocB
     */
    private final MethodJavaDoc fJavaDoc = new MethodJavaDoc();

    /**
     * blancoCodeGeneratorƂĂ̌^B
     */
    private Type fType = null;

    /**
     * blancoCodeGeneratorƂĂfield\𐶐܂B
     * 
     * @param argType
     *            blancoCodeGeneratorƂĂ̌^B
     * @param argName
     *            OB
     */
    public FieldExpander(final Type argType, final String argName) {
        fType = argType;

        final String type = BlancoCodeGeneratorUtil.normalizeTypeName(argType
                .getFullName());
        fCgField = fCgFactory.createField(argName, type, "");
        if (argType.getFullName().endsWith("[]")) {
            fCgField.getType().setArray(true);
        }
    }

    /**
     * IɕێĂ blancoCg\擾܂B
     * 
     * @return field\B
     */
    public final BlancoCgField getCgField() {
        return fCgField;
    }

    /**
     * tB[h̓ftHgprivateXR[vƂ܂B
     * 
     * @return
     */
    protected Scope getScope() {
        return Scope.PRIVATE;
    }

    /**
     * tB[h\WJ܂B
     */
    public final void expand() {
        fCgField.setAccess(getScope().get());
        fCgField.setStatic(isStatic());
        fCgField.setFinal(isFinal());

        if (BlancoStringUtil.null2Blank(fType.getGenerics()).length() > 0) {
            // WFlNXڑ܂B
            fCgField.getType().setGenerics(fType.getGenerics());
        }

        // LangDoc̈ڑB
        for (int index = 0; index < fJavaDoc.getList().size(); index++) {
            final Object objLook = fJavaDoc.getList().get(index);
            if (objLook instanceof String) {
                fCgField.getLangDoc().getDescriptionList()
                        .add((String) objLook);
            } else {
                throw new IllegalArgumentException("FieldExpander: JavaDoc["
                        + objLook + "]̌^[" + objLook.getClass().getName()
                        + "]͏ł܂B");
            }
        }
    }

    /**
     * blancoCodeGeneratorƂĂJavaDoc\擾܂B
     * 
     * @return
     */
    public final MethodJavaDoc getJavaDoc() {
        return fJavaDoc;
    }

    /**
     * ftHgƂȂlݒ肵܂B
     * 
     * @param argStatement
     */
    public final void setDefaultStatement(final Statement argStatement) {
        fCgField.setDefault(argStatement.getLine());
    }

    /**
     * ftHgƂȂlݒ肵܂B
     * 
     * ^(java.lang.String)Ăꍇɂ́Aȓ܂B
     * 
     * @param argLiteral
     *            ftHgB
     */
    public final void setLiteralValue(final String argLiteral) {
        String strLiteral = argLiteral;
        if (fType.getFullName().equals("java.lang.String")
                || fType.getFullName().equals("String")) {
            strLiteral = "\"" + strLiteral + "\"";
        }

        fCgField.setDefault(strLiteral);
    }
}
