/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xsd;

import java.io.File;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.method.MethodExpander;
import blanco.ig.generator.GeneratorSetting;
import blanco.ig.generator.ImplementGenerator;
import blanco.xsd.parser.BlancoXsdParser;
import blanco.xsd.parser.ComplexTypeFieldStructure;
import blanco.xsd.parser.ComplexTypeStructure;

/**
 * ͗pXML͂ċۉSAXC^[̃eXgNX𐶐܂B<br>
 * ̃NXł́AConcreteSaxSerializer𐶐܂B<br>
 * <br>
 * ͂͗pXMLt@ĆAӓIȂ̂܂B_ł ȂIȂ̂ɂȂ܂B<br>
 * 1: ͗pXML̃Agr[gׂ͂Ďw肳ė̂Ɖ肵܂B<br>
 * 2: قȂKwɂēÕGeBeB݂Ȃ̂Ɖ肵܂B<br>
 * Ql:http://java.sun.com/j2se/1.5.0/ja/docs/ja/api/org/xml/sax/ContentHandler.html<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoXsdXsd2CastorTest {

    /**
     * \[XR[hs܂B
     * 
     * @param sourceFile
     * @param targetDirectory
     * @param packageName
     * @param className
     * @throws Exception
     */
    public void process(final File sourceFile, final File fileXsdSource,
            final String targetDirectory) throws Exception {
        // xsdp[X܂B
        BlancoXsdParser parser = new BlancoXsdParser();
        if (fileXsdSource.getName().endsWith(".xsd") == false) {
            // ӁF.xsdŃt@C͏IƉ肵Ă܂B
            throw new IllegalArgumentException("t@C.xsdŏÎw肵ĂB:"
                    + fileXsdSource.getName());
        }
        final ComplexTypeStructure type = parser.process(fileXsdSource,
                fileXsdSource.getName().substring(0,
                        fileXsdSource.getName().length() - 4));

        // Java\[XR[h𐶐̂߂̐ݒ
        GeneratorSetting setting = new GeneratorSetting();
        // o͐fBNgݒ肵܂B
        setting.setWorkDirectory(targetDirectory);
        ImplementGenerator implementGenerator = new ImplementGenerator(setting);
        // 쐬NXo^܂B
        implementGenerator.addTest(getClassExpander(sourceFile, type, type
                .getPackageOfJava(), BlancoNameAdjuster.toClassName(type
                .getName())));
        // ۂɃ\[XR[hs܂B
        implementGenerator.generate();
        // System.out.println("\[XR[h܂B");
    }

    /**
     * ̃NXWJs܂B
     * 
     * @param sourceFile
     * @param packageName
     * @param className
     * @return
     */
    private ClassExpander getClassExpander(final File sourceFile,
            final ComplexTypeStructure type, final String packageName,
            final String className) {
        return new ClassExpander(new Type(packageName, BlancoNameAdjuster
                .toClassName(className)
                + "Test")) {
            protected void expandClassStruct() {
                addFileComment(className + " CastoreXgNX<br>");
                getJavaDoc().addLine(className + " CastoreXgNX<br>");
                setSuperClass(new Type("junit.framework.TestCase"));

                addMethod(new MethodExpander("testMarshaller") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        addUsingType(new Type("java.io.BufferedInputStream"));
                        addUsingType(new Type("java.io.BufferedWriter"));
                        addUsingType(new Type("java.io.FileInputStream"));
                        addUsingType(new Type("java.io.FileOutputStream"));
                        addUsingType(new Type("java.io.IOException"));
                        addUsingType(new Type("java.io.InputStream"));
                        addUsingType(new Type("java.io.OutputStreamWriter"));
                        addUsingType(new Type("java.util.Date"));

                        addUsingType(new Type(
                                "org.exolab.castor.mapping.Mapping"));
                        addUsingType(new Type(
                                "org.exolab.castor.xml.Marshaller"));

                        for (int index = 0; index < type.getListField().size(); index++) {
                            final ComplexTypeFieldStructure field = (ComplexTypeFieldStructure) type
                                    .getListField().get(index);
                            addUsingType(new Type(field.getTypeStructure()
                                    .getTypeOfJavaWithoutArray()));
                        }

                        addUsingType(new Type("org.xml.sax.InputSource"));

                        addException(new Type("java.lang.Exception"));
                    }

                    public void implement() {
                        getData().addLine("BufferedWriter writer = null;");
                        getData().addLine("InputStream inStreamMap = null;");
                        getData().addLine("try {");
                        getData()
                                .addLine(
                                        "writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(\"tmp/"
                                                + BlancoNameAdjuster
                                                        .toClassName(className)
                                                + "TestOutput.xml\"), \"UTF-8\"));");
                        getData()
                                .addLine(
                                        "inStreamMap = new BufferedInputStream(new FileInputStream(\"tmp/soap/xsd/"
                                                + BlancoNameAdjuster
                                                        .toClassName(type
                                                                .getName())
                                                + ".castorxml\"));");
                        getData().addLine("Mapping mapping = new Mapping();");
                        getData()
                                .addLine(
                                        "mapping.loadMapping(new InputSource(inStreamMap));");
                        getData()
                                .addLine(
                                        "Marshaller marshaller = new Marshaller(writer);");
                        getData().addLine("marshaller.setMapping(mapping);");
                        getData().addLine(
                                BlancoNameAdjuster.toClassName(type.getName())
                                        + " input = new "
                                        + BlancoNameAdjuster.toClassName(type
                                                .getName()) + "();");

                        for (int index = 0; index < type.getListField().size(); index++) {
                            final ComplexTypeFieldStructure field = (ComplexTypeFieldStructure) type
                                    .getListField().get(index);
                            String line = "input.set"
                                    + BlancoNameAdjuster.toClassName(field
                                            .getFieldName()) + "(";
                            // TODO: getTypeOfJavaWithoutArray̑ΉΉłB
                            if (field.getTypeStructure().getTypeOfJava()
                                    .equals("java.lang.String")) {
                                line += "\"\"";
                            } else if (field.getTypeStructure().getTypeOfJava()
                                    .equals("int")
                                    || field.getTypeStructure().getTypeOfJava()
                                            .equals("java.lang.Integer")) {
                                line += "123";
                            } else if (field.getTypeStructure().getTypeOfJava()
                                    .equals("long")
                                    || field.getTypeStructure().getTypeOfJava()
                                            .equals("java.lang.Long")) {
                                line += "1234567890";
                            } else if (field.getTypeStructure().getTypeOfJava()
                                    .equals("boolean")
                                    || field.getTypeStructure().getTypeOfJava()
                                            .equals("java.lang.Boolean")) {
                                line += "true";
                            } else if (field.getTypeStructure().getTypeOfJava()
                                    .equals("java.util.Date")) {
                                line += "new Date()";
                            } else {
                                // _ł͑ΉĂȂ^łB
                                getData().addLine(
                                        "// ^["
                                                + field.getTypeStructure()
                                                        .getTypeOfJava()
                                                + "]͌_ł͖T|[głB");
                                line += "new "
                                        + field.getTypeStructure()
                                                .getTypeOfJava() + "()";
                            }
                            line += ");";
                            getData().addLine(line);
                        }

                        // Ōɕۑ{
                        getData().addLine("// ݒ肳ꂽWriterɕۑ܂B");
                        getData().addLine("marshaller.marshal(input);");
                        getData().addLine("} finally {");
                        getData().addLine("if (inStreamMap != null) {");
                        getData().addLine("try {");
                        getData().addLine("inStreamMap.close();");
                        getData().addLine("} catch (IOException e) {");
                        getData().addLine("e.printStackTrace();");
                        getData().addLine("}");
                        getData().addLine("}");
                        getData().addLine("if (writer != null) {");
                        getData().addLine("try {");
                        getData().addLine("writer.close();");
                        getData().addLine("} catch (IOException e) {");
                        getData().addLine("e.printStackTrace();");
                        getData().addLine("}");
                        getData().addLine("}");
                        getData().addLine("}");
                    }
                });
            }
        };
    }
}
