/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.resourcebundle.expand;

import java.io.File;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoBigDecimalUtil;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.method.Constructor;
import blanco.ig.expander.method.MethodExpander;
import blanco.resourcebundle.BlancoResourceBundleConstants;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;

/**
 * XMLt@C vpeBt@C𐶐鏈̓łB
 * 
 * ̃\[XR[hblancoResourceBundlëꕔłB<br>
 * XMLDOMGg͂Ƃăt@Co͂܂B <br>
 * 
 * ̑O:BlancoResourceBundleXmlValidatorNXŎOɃ`FbNĂ̂Ƒz肵܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleExpandResourceBundle {
    /**
     * \[XohANZT̃CX^XB
     */
    private final BlancoResourceBundleResourceBundle bundle = new BlancoResourceBundleResourceBundle();

    /**
     * w̏\[XR[hɓWJ܂B
     * 
     * \[XR[ho̓tOɂāA\[XR[ho͂邩ǂ؂ւ܂B
     * 
     * @param elementSheet
     *            V[g̃GgB
     * @param elementCommon
     *            ʏ̃GgB
     * @param directoryTarget
     *            o͐̃^[QbgfBNgB
     * @param isFailOnMessageFormatError
     *            bZ[WMessageFormatɂp[Xsۂ̗O珈𒆒f邩ǂ̃tOݒ肵܂B
     */
    public void expand(final Element elementSheet, final Element elementCommon,
            final File directoryTarget, final boolean isFailOnMessageFormatError) {
        final String baseName = BlancoXmlUtil.getTextContent(elementCommon,
                BlancoResourceBundleConstants.BASE_NAME);
        final String suffix = BlancoXmlUtil.getTextContent(elementCommon,
                BlancoResourceBundleConstants.SUFFIX);
        // NX͖Oό`܂B
        final String className = BlancoNameAdjuster.toClassName(baseName)
                + (suffix == null ? "" : suffix);
        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                BlancoResourceBundleConstants.PACKAGE_NAME);
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                BlancoResourceBundleConstants.DESCRIPTION);

        final ArrayList listKnownLocale = new ArrayList();
        final HashMap mapBundle = new HashMap();
        // ^ꂽpbP[Ŵ܂ܗp܂B
        final ClassExpander classExpander = new ClassExpander(new Type(
                packageName, className)) {

            protected void expandClassStruct() {
                addFileComment(bundle.getExpandresourceSrc001());
                getJavaDoc().addLine(
                        bundle
                                .getExpandresourceSrc011(baseName
                                        + (description == null ? "" : "/"
                                                + description)));
                getJavaDoc().addLine(bundle.getExpandresourceSrc012());

                {
                    final NodeList listCommonList = elementSheet
                            .getElementsByTagName("blancoresourcebundle-common");
                    if (listCommonList == null
                            || listCommonList.getLength() == 0) {
                        // commonꍇɂ̓XLbv܂B
                        return;
                    }

                    final NodeList listLocale = ((Element) listCommonList
                            .item(0)).getElementsByTagName("locale");
                    if (listLocale == null || listLocale.getLength() == 0) {
                        return;
                    }

                    final int sizeListLocale = listLocale.getLength();
                    if (sizeListLocale > 0) {
                        getJavaDoc().addLine(bundle.getExpandresourceSrc013());
                        getJavaDoc().addLine("<UL>");
                        for (int indexLocale = 0; indexLocale < sizeListLocale; indexLocale++) {
                            final Element elementLocale = (Element) listLocale
                                    .item(indexLocale);
                            final String locale = BlancoStringUtil
                                    .null2Blank(BlancoXmlUtil
                                            .getTextContent(elementLocale));
                            listKnownLocale.add(locale);
                            getJavaDoc().addLine("<LI>" + locale);
                        }
                        getJavaDoc().addLine("</UL>");
                    }
                }

                final FieldExpander field1 = new FieldExpander(new Type(
                        "java.util.ResourceBundle"), "fResourceBundle");
                field1.getJavaDoc().addLine(bundle.getExpandresourceSrc014());
                field1.getJavaDoc().addLine(bundle.getExpandresourceSrc015());
                addField(field1);

                addMethod(new Constructor(className) {
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                bundle.getExpandresourceSrc021(className));
                        getJavaDoc().addLine(
                                bundle.getExpandresourceSrc022(baseName));
                    }

                    public void implement() {
                        // ɃC|[gKvłB
                        addUsingType(new Type(
                                "java.util.MissingResourceException"));

                        getData().addLine("try {");
                        getData().addLine(
                                "fResourceBundle = ResourceBundle.getBundle(\""
                                        + baseName + "\");");
                        getData().addLine(
                                "} catch (MissingResourceException ex) {");
                        getData()
                                .addLine(
                                        "final String message = \""
                                                + bundle
                                                        .getExpandresourceSrc023(baseName)
                                                + "\" + ex.toString();");
                        getData().addLine("System.out.println(message);");
                        getData().addLine("}");
                    }
                });

                addMethod(new Constructor(className) {
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                bundle.getExpandresourceSrc031(className));
                        getJavaDoc().addLine(
                                bundle.getExpandresourceSrc032(baseName));
                        getJavaDoc().addParameter("locale",
                                bundle.getExpandresourceSrc033());
                        addArgument(new Value(new Type("java.util.Locale"),
                                "locale"));
                    }

                    public void implement() {
                        getData().addLine("try {");
                        getData().addLine(
                                "fResourceBundle = ResourceBundle.getBundle(\""
                                        + baseName + "\", locale);");
                        getData().addLine(
                                "} catch (MissingResourceException ex) {");
                        getData()
                                .addLine(
                                        "final String message = \""
                                                + bundle
                                                        .getExpandresourceSrc034(baseName)
                                                + "\" + ex.toString();");
                        getData().addLine("System.out.println(message);");
                        getData().addLine("}");
                    }
                });

                addMethod(new Constructor(className) {
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                bundle.getExpandresourceSrc041(className));
                        getJavaDoc().addLine(
                                bundle.getExpandresourceSrc042(baseName));
                        getJavaDoc().addParameter("locale",
                                bundle.getExpandresourceSrc043());
                        getJavaDoc().addParameter("loader",
                                bundle.getExpandresourceSrc044());
                        addArgument(new Value(new Type("java.util.Locale"),
                                "locale"));
                        addArgument(new Value(
                                new Type("java.lang.ClassLoader"), "loader"));
                    }

                    public void implement() {
                        getData().addLine("try {");
                        getData().addLine(
                                "fResourceBundle = ResourceBundle.getBundle(\""
                                        + baseName + "\", locale, loader);");
                        getData().addLine(
                                "} catch (MissingResourceException ex) {");
                        getData()
                                .addLine(
                                        "final String message = \""
                                                + bundle
                                                        .getExpandresourceSrc045(baseName)
                                                + "\" + ex.toString();");
                        getData().addLine("System.out.println(message);");
                        getData().addLine("}");
                    }
                });

                final NodeList listResourceList = elementSheet
                        .getElementsByTagName("blancoresourcebundle-resourceList");
                if (listResourceList == null
                        || listResourceList.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    return;
                }

                final NodeList listResource = ((Element) listResourceList
                        .item(0)).getElementsByTagName("resource");
                if (listResource == null || listResource.getLength() == 0) {
                    return;
                }

                final int sizeListResource = listResource.getLength();
                for (int indexResource = 0; indexResource < sizeListResource; indexResource++) {
                    final Element elementResource = (Element) listResource
                            .item(indexResource);

                    final String fieldResourceId = BlancoStringUtil
                            .null2Blank(BlancoXmlUtil.getTextContent(
                                    elementResource,
                                    BlancoResourceBundleConstants.RESOURCE_KEY));
                    addMethod(new MethodExpander("get"
                            + BlancoNameAdjuster.toClassName(fieldResourceId)) {
                        public void setupSignature() {
                            getJavaDoc().addLine(
                                    "bundle[" + baseName + "], key["
                                            + fieldResourceId + "]<br>");
                            getJavaDoc().addLine("<br>");

                            final NodeList nodeListResourceString = elementResource
                                    .getElementsByTagName(BlancoResourceBundleConstants.RESOURCE_STRING);
                            if (nodeListResourceString == null
                                    || nodeListResourceString.getLength() == 0) {
                                return;
                            }

                            final HashMap mapProcessedLocale = new HashMap();
                            for (int indexResourceString = 0; indexResourceString < nodeListResourceString
                                    .getLength(); indexResourceString++) {
                                if (nodeListResourceString
                                        .item(indexResourceString) instanceof Element == false) {
                                    continue;
                                }

                                final Element elementResourceString = (Element) nodeListResourceString
                                        .item(indexResourceString);
                                final String resourceString = BlancoStringUtil
                                        .null2Blank(BlancoXmlUtil
                                                .getTextContent(elementResourceString));
                                final String locale = BlancoStringUtil
                                        .null2Blank(elementResourceString
                                                .getAttribute("locale"));
                                getJavaDoc()
                                        .addLine(
                                                "["
                                                        + BlancoJavaSourceUtil
                                                                .escapeStringAsJavaDoc(resourceString)
                                                        + "] (" + locale
                                                        + ")<br>");

                                // ς݂̃P[ł邱ƂL܂B
                                mapProcessedLocale.put(locale, locale);
                                if (mapBundle.get(fieldResourceId) == null) {
                                    mapBundle.put(fieldResourceId,
                                            resourceString);
                                }

                                // tH[}bgO͔邱Ƃ͑z肵܂BȂȂ玖O`FbNɂɉĂ邩łB
                                final Format[] formatList = getFormatsByArgumentIndex(
                                        resourceString,
                                        isFailOnMessageFormatError);
                                for (int indexFormat = 0; indexFormat < formatList.length; indexFormat++) {
                                    String strArgType = "java.lang.String";
                                    if (formatList[indexFormat] == null) {
                                        // tH[}bgȂ:
                                        // java.lang.Stringւ̃}bvÓ
                                        strArgType = "java.lang.String";
                                    } else if (formatList[indexFormat] instanceof java.text.NumberFormat) {
                                        // java.math.BigDecimalւ̃}bvÓ
                                        strArgType = "java.math.BigDecimal";
                                    } else if (formatList[indexFormat] instanceof java.text.DateFormat) {
                                        // java.util.Dateւ̃}bvÓ
                                        strArgType = "java.util.Date";
                                    } else if (formatList[indexFormat] instanceof java.text.ChoiceFormat) {
                                        // intւ̃}bvÓ
                                        strArgType = "int";
                                    } else {
                                        strArgType = "java.lang.String";
                                    }
                                    if (indexResourceString == 0) {
                                        // ̂݃\bh𐶐
                                        getJavaDoc()
                                                .addParameter(
                                                        "arg" + indexFormat,
                                                        bundle
                                                                .getExpandresourceSrc101(
                                                                        BlancoBigDecimalUtil
                                                                                .toBigDecimal(indexFormat),
                                                                        strArgType));
                                        addArgument(new Value(new Type(
                                                strArgType), "arg"
                                                + indexFormat));
                                    }
                                }
                                getJavaDoc()
                                        .addReturn(
                                                bundle
                                                        .getExpandresourceSrc102(fieldResourceId));
                            }

                            // P[SđĂ邩ǂ̃`FbNs܂B
                            for (int indexCheck = 0; indexCheck < listKnownLocale
                                    .size(); indexCheck++) {
                                final String localeCheck = (String) listKnownLocale
                                        .get(indexCheck);
                                final Object objCheck = mapProcessedLocale
                                        .get(localeCheck);
                                if (objCheck == null) {
                                    // ĂȂꍇłĂAJavaDocւ̌xo͂ɂƂǂ߂܂B
                                    getJavaDoc()
                                            .addLine(
                                                    bundle
                                                            .getExpandresourceSrc103(localeCheck));
                                }
                            }

                            setReturnType(new Type("java.lang.String"));
                        }

                        public void implement() {
                            final String resourceString = (String) mapBundle
                                    .get(fieldResourceId);

                            getData().addLine(
                                    "// " + bundle.getExpandresourceSrc104());
                            getData()
                                    .addLine(
                                            "String strFormat = \""
                                                    + BlancoJavaSourceUtil
                                                            .escapeStringAsJavaSource(resourceString)
                                                    + "\";");
                            getData().addLine("try {");
                            getData().addLine("if (fResourceBundle != null) {");
                            getData()
                                    .addLine(
                                            "strFormat = fResourceBundle.getString(\""
                                                    + BlancoJavaSourceUtil
                                                            .escapeStringAsJavaSource(bundle
                                                                    .getKeyPrefix()
                                                                    + fieldResourceId)
                                                    + "\");");
                            getData().addLine("}");
                            getData().addLine(
                                    "} catch (MissingResourceException ex) {");
                            getData().addLine(
                                    "final String message = \""
                                            + bundle.getExpandresourceSrc105(
                                                    baseName, bundle
                                                            .getKeyPrefix()
                                                            + fieldResourceId)
                                            + "\" + ex.toString();");
                            getData().addLine("System.out.println(message);");
                            getData().addLine("}");

                            final Format[] formatList = getFormatsByArgumentIndex(
                                    resourceString, isFailOnMessageFormatError);
                            if (formatList.length > 0) {
                                String strArgForFormat = "";
                                for (int index = 0; index < formatList.length; index++) {
                                    if (index != 0) {
                                        strArgForFormat += ", ";
                                    }
                                    strArgForFormat += ("arg" + index);
                                }

                                addUsingType(new Type("java.text.MessageFormat"));
                                getData()
                                        .addLine(
                                                "final MessageFormat messageFormat = new MessageFormat(strFormat);");
                                getData()
                                        .addLine(
                                                "final StringBuffer strbuf = new StringBuffer();");
                                getData()
                                        .addLine(
                                                "// "
                                                        + bundle
                                                                .getExpandresourceSrc106());
                                getData().addLine(
                                        "messageFormat.format(new Object[] {"
                                                + strArgForFormat
                                                + "}, strbuf, null);");

                                getData().addLine("return strbuf.toString();");
                            } else {
                                getData()
                                        .addLine(
                                                "// "
                                                        + bundle
                                                                .getExpandresourceSrc107());
                                getData().addLine("return strFormat;");
                            }
                        }
                    });

                }
            }
        };

        // \[XR[hۂɐ܂B
        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }

    /**
     * MessageFormattH[}bg擾܂B
     * 
     * ̃\bh blancoResourceBundleIɂ̂ݗp邱Ƃz肵Ă܂B
     * 
     * @param resourceString
     *            \[X
     * @param isFailOnMessageFormatError
     *            MessageFormatƂăp[XꍇɃG[ƂĈǂB
     * @return ͌̃tH[}bgzB
     */
    public static final Format[] getFormatsByArgumentIndex(
            final String resourceString,
            final boolean isFailOnMessageFormatError) {
        try {
            final MessageFormat messageFormat = new MessageFormat(
                    resourceString);
            return messageFormat.getFormatsByArgumentIndex();

        } catch (IllegalArgumentException ex) {
            if (isFailOnMessageFormatError) {
                throw ex;
            }

            // G[𖳎āAȂ̂ƂU܂B
            return new Format[0];
        }
    }
}