/*
 * blancoCodeGenerator
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.implementor;

import java.util.List;

import blanco.ig.expander.Type;
import blanco.ig.expander.Value;

/**
 * blancoCodeGenerator̎R[hǉ邽߂̃bp[NXB
 * 
 * @deprecated ̃NX̗p͐܂B݊̂߂ɎcĂ邾łB
 * @author Yasuo Nakanishi (1st version)
 * @author IGA Tosiki (2nd version)
 */
public class Implementor {
    /**
     * ۂ̏o͐ImplementDataIuWFNgB
     */
    private ImplementData _data = null;

    private List _usingTypeList;

    /**
     * ImplementDataIuWFNg𔺂ăNX܂B
     * 
     * @param argData
     *            ۂ̏o͐ImplementDataIuWFNgB
     */
    public Implementor(final ImplementData data) {
        _data = data;
        _usingTypeList = data.getUsingTypeList();
    }

    /**
     * so͂܂B
     * 
     * @param argLine
     *            o͂sB
     */
    public void addLine(final String argLine) {
        _data.addLine(argLine);
    }

    public void addThrow(final Call call) {
        addUsingTypeList(call.getUsingTypeList());
        addStatement("throw " + call.toString());
    }

    public void addThrow(final Value exception) {
        addStatement("throw " + exception.getName());
    }

    public void declare(final Value value, final Statement defaultStatement) {
        addUsingType(value.getType());
        addUsingTypeList(defaultStatement.getUsingTypeList());

        final StringBuffer sb = new StringBuffer();
        sb.append(value.getType().getName());
        sb.append(" ");
        sb.append(value.getName());
        sb.append(" = ");
        sb.append(defaultStatement.toString());

        addStatement(sb.toString());
    }

    public void declare(final Value value) {
        addUsingType(value.getType());

        final StringBuffer sb = new StringBuffer();
        sb.append(value.getType().getName());
        sb.append(" ");
        sb.append(value.getName());

        addStatement(sb.toString());
    }

    public void declareByDefault(final Value value) {
        addUsingType(value.getType());

        final StringBuffer sb = new StringBuffer();
        sb.append(value.getType().getName());
        sb.append(" ");
        sb.append(value.getName());
        sb.append(" = ");
        sb.append(getDefault(value.getType()));

        addStatement(sb.toString());
    }

    private Statement getDefault(final Type type) {
        Statement result = null;
        if (type.equals(int.class) || type.equals(short.class)) {
            result = new Statement("0");
        } else if (type.equals(String.class)) {
            result = new StringLiteral("");
        } else if (!type.isPrimitive()) {
            result = new Statement(Value.NULL);
        } else {
            String message = "T|[gǑ^łBType:" + type.getFullName();
            throw new RuntimeException(message);
        }
        return result;
    }

    public void assign(final Value value, final Statement statement) {
        final StringBuffer sb = new StringBuffer();
        sb.append(value.getName());
        sb.append(" = ");
        sb.append(statement.toString());

        addStatement(sb.toString());
        addUsingTypeList(statement.getUsingTypeList());

    }

    public void assign(final Value value, final Value assignValue) {
        assign(value, new Statement(assignValue));
    }

    public void emptyLine() {
        addLine("");
    }

    public void openIf(final String expresstion) {
        _data.pushBlock(Block.IF);
        addLine("if (" + expresstion + ") {");
    }

    public void openFor(final Statement left, final Statement center,
            final Statement right) {
        _data.pushBlock(Block.FOR);
        final StringBuffer sb = new StringBuffer();
        sb.append("for (");
        sb.append(left.toString());
        sb.append("; ");
        sb.append(center.toString());
        sb.append("; ");
        sb.append(right.toString());
        sb.append(") {");
        addLine(sb.toString());
    }

    public void openFor(final Value counter, final Statement loop) {
        _data.pushBlock(Block.FOR);
        final StringBuffer sb = new StringBuffer();
        sb.append("for (");
        sb.append("int ");
        sb.append(counter.getName());
        sb.append(" = 0; ");
        sb.append(loop.toString());
        sb.append("; ");
        sb.append(counter.getName());
        sb.append("++) {");
        addLine(sb.toString());
    }

    public void openWhile(final String expresstion) {
        _data.pushBlock(Block.WHILE);
        addLine("while (" + expresstion + ") {");
    }

    public void openWhile(final Statement expresstion) {
        addUsingTypeList(expresstion.getUsingTypeList());
        openWhile(expresstion.toString());
    }

    public void openIf(final Statement statement) {
        openIf(statement.toString());
        addUsingTypeList(statement.getUsingTypeList());
    }

    public void openTry() {
        _data.pushBlock(Block.TRY);
        addLine("try {");
    }

    public void addElseIf(final String expresstion) {
        addLine("} else if (" + expresstion + ") {");
    }

    public void addElseIf(final Statement expresstion) {
        addUsingTypeList(expresstion.getUsingTypeList());
        addLine("} else if (" + expresstion.toString() + ") {");
    }

    public void addCatch(final Value value) {
        addUsingType(value.getType());
        addLine("} catch (" + value.getType().getName() + " " + value.getName()
                + ") {");
    }

    public void addElse() {
        addLine("} else {");
    }

    public void addFinally() {
        addLine("} finally {");
    }

    public void closeIf() {
        _data.popBlock();
        addLine("}");
    }

    public void closeTry() {
        _data.popBlock();
        addLine("}");
    }

    public void closeWhile() {
        _data.popBlock();
        addLine("}");
    }

    public void closeFor() {
        _data.popBlock();
        addLine("}");
    }

    public void addStatement(String line) {
        addLine(line + ";");
    }

    public void addStatement(Statement statement) {
        addStatement(statement.toString());
        getUsingTypeList().addAll(statement.getUsingTypeList());
    }

    public List getImplementList() {
        return _data.getImplementList();
    }

    public void addReturn(String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("return ");
        sb.append(value);
        sb.append(";");

        addLine(new String(sb));
    }

    public void addReturn(Value value) {
        addReturn(value.getName());
    }

    public void addReturn(Statement statement) {
        addReturn(statement.toString());
        addUsingTypeList(statement.getUsingTypeList());
    }

    public void addReturn() {
        addLine("return;");
    }

    public int getUsingTypeCount() {
        return _usingTypeList.size();
    }

    public void addUsingType(Type type) {
        _usingTypeList.add(type);
    }

    public void addUsingTypeList(List typeList) {
        _usingTypeList.addAll(typeList);
    }

    public Type getUsingType(int index) {
        return (Type) _usingTypeList.get(index);
    }

    public List getUsingTypeList() {
        return _usingTypeList;
    }
}
