/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.soap.actions;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import blanco.commons.io.File2StreamWrapper;
import blanco.commons.util.BlancoNameUtil;
import blanco.plugin.soap.BlancoSOAPPlugin;
import blanco.plugin.soap.editors.BlancoSOAPPluginUtil;
import blanco.plugin.soap.resourcebundle.BlancoSOAPPluginResourceBundle;
import blanco.soap.BlancoSoapDotNetWsdlExe;
import blanco.soap.BlancoSoapWsdl2CsClass;
import blanco.xsd.BlancoXsdXsdValidator;

/**
 * XSD쓮ANV
 * 
 * @author IGA Tosiki
 */
public class BlancoXsd2CsSourceGenerateAction {
    private static final BlancoSOAPPluginResourceBundle bundle = new BlancoSOAPPluginResourceBundle();

    /**
     * GUIfobOp̒ᑬ[hBʏfalseŉ^p܂B
     */
    private static final boolean IS_DEBUG_SLOW = false;

    /**
     * blancoSOAP\[XR[hs܂B
     * 
     * @param ifile
     *            ΏۂƂȂt@CB
     * @param shell
     *            eVFB
     * @param workbenchMonitor
     *            [Nx`j^B
     * @param metaDir
     *            ^fBNgB
     * @param isRunWsdkExe
     *            wsdl.exes邩ǂB
     * @param dotNetSdkDir
     *            .NET Framework SDK̃fBNgB
     * @throws InvocationTargetException
     *             sOꍇB
     * @throws InterruptedException
     *             荞ݗOꍇB
     */
    public static final void process(final IFile ifile, final Shell shell,
            final IProgressMonitor workbenchMonitor, final String metaDir,
            final boolean isRunWsdkExe, final String dotNetSdkDir)
            throws InvocationTargetException, InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask("blancoXsd\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_쐬: blanco.cstH_");

                                final IFolder folderDirBlanco = ifile
                                        .getProject().getFolder("blanco.cs");
                                folderDirBlanco.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);
                                if (folderDirBlanco.exists() == false) {
                                    folderDirBlanco.create(true, true,
                                            workbenchMonitor);
                                }

                                monitor.subTask("tH_쐬: blanco.cs/maintH_");
                                final IFolder folderDirBlancoMain = folderDirBlanco
                                        .getFolder("main");
                                // XV͕sv
                                if (folderDirBlancoMain.exists() == false) {
                                    folderDirBlancoMain.create(true, true,
                                            workbenchMonitor);
                                }

                                monitor.subTask("fBNg: e|tH_̒");

                                // e|tH_U폜܂B
                                BlancoSOAPPluginUtil.deleteFolder(ifile,
                                        workbenchMonitor, "tmp/soap/xsd");
                                BlancoSOAPPluginUtil.createFolder(ifile,
                                        workbenchMonitor, "tmp/soap/xsd");

                                final IFolder folderDirSoapXsd = BlancoSOAPPluginUtil
                                        .findFolder(ifile, workbenchMonitor,
                                                "tmp/soap/xsd");
                                folderDirSoapXsd.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                final IFolder folderDirMetaDir = BlancoSOAPPluginUtil
                                        .findFolder(ifile, workbenchMonitor,
                                                metaDir);
                                folderDirMetaDir.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);
                                final IResource[] resourcesMetaFiles = folderDirMetaDir
                                        .members();
                                for (int index = 0; index < resourcesMetaFiles.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesMetaFiles[index] instanceof IFile) {
                                        final IFile fileLookMetaFile = (IFile) resourcesMetaFiles[index];
                                        if (fileLookMetaFile.getFileExtension()
                                                .equals("xsd")) {
                                            monitor
                                                    .subTask("C#.NET\[XR[h쐬: t@C["
                                                            + fileLookMetaFile
                                                                    .getName()
                                                            + "]̑Ó`FbN܂ ("
                                                            + (index + 1)
                                                            + "/"
                                                            + resourcesMetaFiles.length
                                                            + ")");
                                            final String fileName = BlancoNameUtil
                                                    .trimFileExtension(fileLookMetaFile
                                                            .getName());
                                            if (fileName == null) {
                                                throw new IllegalArgumentException(
                                                        "̉ߒŉH̃t@CnullɂȂĂ܂܂BHÕt@C["
                                                                + fileName
                                                                + "]");
                                            }
                                            try {
                                                // XSDt@C̑Ó؂s܂B
                                                new File2StreamWrapper(
                                                        fileLookMetaFile
                                                                .getLocation()
                                                                .toFile(), null) {
                                                    protected void process(
                                                            InputStream inStream,
                                                            OutputStream outStreamIgnore)
                                                            throws Exception {
                                                        new BlancoXsdXsdValidator()
                                                                .process(
                                                                        inStream,
                                                                        fileName);
                                                    }
                                                }.run();
                                            } catch (IllegalArgumentException ex) {
                                                BlancoSOAPPlugin.log(ex);
                                                throw new IllegalArgumentException(

                                                        "t@C["
                                                                + fileLookMetaFile
                                                                        .getName()
                                                                + "]ValueObjectɃG[܂B𒆒f܂B\n\n"
                                                                + ex.toString());
                                            }
                                        } else if (fileLookMetaFile
                                                .getFileExtension().equals(
                                                        "wsdl")) {
                                            monitor
                                                    .subTask("C#.NET\[XR[h쐬: t@C["
                                                            + fileLookMetaFile
                                                                    .getName()
                                                            + "]̏Ȃ܂ ("
                                                            + (index + 1)
                                                            + "/"
                                                            + resourcesMetaFiles.length
                                                            + ")");
                                            try {
                                                new BlancoSoapWsdl2CsClass()
                                                        .process(
                                                                fileLookMetaFile
                                                                        .getLocation()
                                                                        .toFile(),
                                                                folderDirBlanco
                                                                        .getLocation()
                                                                        .toFile());

                                                if (isRunWsdkExe) {
                                                    final BlancoSoapDotNetWsdlExe wsdlexe = new BlancoSoapDotNetWsdlExe();
                                                    wsdlexe
                                                            .setDotNetSdkDir(dotNetSdkDir);
                                                    wsdlexe.setServer(true);
                                                    wsdlexe
                                                            .process(
                                                                    fileLookMetaFile
                                                                            .getLocation()
                                                                            .toFile(),
                                                                    folderDirBlanco
                                                                            .getLocation()
                                                                            .toFile());
                                                }
                                            } catch (IllegalArgumentException ex) {
                                                BlancoSOAPPlugin.log(ex);
                                                throw new IllegalArgumentException(

                                                        "t@C["
                                                                + fileLookMetaFile
                                                                        .getName()
                                                                + "]ValueObjectɃG[܂B𒆒f܂B\n\n"
                                                                + ex.toString());
                                            }
                                        }
                                        if (IS_DEBUG_SLOW) {
                                            Thread.sleep(1000);
                                        }
                                    }
                                }

                                monitor.subTask("C#.NET\[XR[h쐬");
                                monitor.worked(1);

                                monitor.subTask("tH_XV: blanco.cstH_XV");
                                monitor.worked(1);

                                folderDirBlanco.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                folderDirSoapXsd.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                if (IS_DEBUG_SLOW) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoSOAPPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        }
    }
}