/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.wsdl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.wsdl.concretesax.BlancoWsdlXml2WsdlOutputSerializer;
import blanco.wsdl.resourcebundle.BlancoWsdlResourceBundle;
import blanco.wsdl.valueobject.BlancoWsdlWebService;
import blanco.wsdl.valueobject.BlancoWsdlWebServiceOperation;
import blanco.xsd.parser.BlancoXsdParser;
import blanco.xsd.parser.ComplexTypeStructure;

/**
 * blancoWsdl̒XMLt@C`ꂽ^t@C͂ƂāAWSDLt@C𐶐܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoWsdlXml2Wsdl {
    /**
     * \[XohIuWFNgB
     */
    private final BlancoWsdlResourceBundle bundle = new BlancoWsdlResourceBundle();

    /**
     * WSDLL邽߂̃XgB
     */
    private final ArrayList listWsdl = new ArrayList();

    /**
     * ^ꂽXMLt@C`ꂽ^t@Cǂݍ݂܂B
     * 
     * ̉ߒ xsdt@C̃fBNgɗ\ߊi[ĂKv܂B
     * 
     * @param fileMetaFileXml
     *            XML`ꂽ^t@C
     * @param directoryXsd
     *            XSDt@Ci[ĂfBNg
     * @throws IOException
     *             o͗Oꍇ
     * @throws TransformerException
     *             XMLϊOꍇ
     * @throws SAXException
     *             SAXOꍇ
     */
    public void parse(final File fileMetaFileXml, final File directoryXsd)
            throws IOException, TransformerException, SAXException {
        final DOMResult result = new DOMResult();
        InputStream inStream = null;
        try {
            inStream = new FileInputStream(fileMetaFileXml);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inStream), result);
        } finally {
            if (inStream != null) {
                inStream.close();
                inStream = null;
            }
        }

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();

            // ܂uŏ́vd`A
            // EFuT[rXIDȂǂ擾B
            for (int index = 0; index < sizeListSheet; index++) {
                BlancoWsdlWebService wsdl = new BlancoWsdlWebService();
                final BlancoWsdlWebServiceOperation wsdlOperation = new BlancoWsdlWebServiceOperation();

                final Element elementSheet = (Element) listSheet.item(index);
                // System.out.println("V[g[" + elementSheet.getAttribute("name")
                // + "]");

                final NodeList listTelegramProcess = elementSheet
                        .getElementsByTagName("blancotelegramprocess-common");
                if (listTelegramProcess.getLength() == 0) {
                    continue;
                }

                final Element elementCommon = (Element) listTelegramProcess
                        .item(0);

                // dID擾܂B
                wsdlOperation.setName(BlancoXmlUtil.getTextContent(
                        elementCommon, "telegramProcessId"));
                if (wsdlOperation.getName() == null) {
                    // telegramProcessId`͖̂̂ɃXLbv܂B
                    continue;
                }

                // vdID擾܂B
                wsdlOperation.setTelegramRequestId(BlancoXmlUtil
                        .getTextContent(elementCommon, "telegramRequestId"));
                if (wsdlOperation.getTelegramRequestId() == null) {
                    throw new IllegalArgumentException(bundle
                            .getXml2wsdlCheck001(wsdlOperation.getName()));
                }

                // dID擾܂B
                wsdlOperation.setTelegramResponseId(BlancoXmlUtil
                        .getTextContent(elementCommon, "telegramResponseId"));
                if (wsdlOperation.getTelegramResponseId() == null) {
                    throw new IllegalArgumentException(bundle
                            .getXml2wsdlCheck002(wsdlOperation.getName()));
                }

                // WebT[rXID擾܂B
                wsdl.setWebServiceId(BlancoXmlUtil.getTextContent(
                        elementCommon, "webServiceId"));
                if (wsdl.getWebServiceId() == null) {
                    throw new IllegalArgumentException(bundle
                            .getXml2wsdlCheck003(wsdlOperation.getName()));
                }

                // OԂ擾܂B
                wsdl.setNamespace(BlancoXmlUtil.getTextContent(elementCommon,
                        "telegramProcessNamespace"));
                if (wsdl.getNamespace() == null) {
                    throw new IllegalArgumentException(bundle
                            .getXml2wsdlCheck004(wsdlOperation.getName()));
                }

                // pbP[W擾܂B
                wsdl.setPackage(BlancoXmlUtil.getTextContent(elementCommon,
                        "packageName"));

                // P[V擾܂B
                wsdl.setLocation(BlancoXmlUtil.getTextContent(elementCommon,
                        "location"));
                if (wsdl.getLocation() == null) {
                    throw new IllegalArgumentException(bundle
                            .getXml2wsdlCheck005(wsdlOperation.getName()));
                }

                // eX̃Iy[VɂĂ̖OԂ肵܂B
                // ̌̂߂ɂ XSDǂݍޕKv܂B
                // ܂ŏɗvd̖OԂm肵܂B
                wsdlOperation
                        .setNamespace(getNamespaceFromXsd(new File(directoryXsd
                                .getAbsolutePath()
                                + "/"
                                + wsdlOperation.getTelegramRequestId()
                                + ".xsd"), wsdlOperation.getName(),
                                wsdlOperation.getTelegramRequestId()));
                // `FbN̖ړIŉd̖OԂ擾܂B
                final String xsdNamespaceResponse = getNamespaceFromXsd(
                        new File(directoryXsd.getAbsolutePath() + "/"
                                + wsdlOperation.getTelegramResponseId()
                                + ".xsd"), wsdlOperation.getName(),
                        wsdlOperation.getTelegramResponseId());
                // vd̖OԂƉd̖OԂYĂُ͈̂툵Ƃ܂B
                if (wsdlOperation.getNamespace().equals(xsdNamespaceResponse) == false) {
                    throw new IllegalArgumentException(bundle
                            .getXml2wsdlCheck006(wsdlOperation.getName(),
                                    wsdlOperation.getTelegramRequestId(),
                                    wsdlOperation.getNamespace(), wsdlOperation
                                            .getTelegramResponseId(),
                                    xsdNamespaceResponse));
                }

                boolean isWsdlExist = false;
                for (int indexWsdl = 0; indexWsdl < listWsdl.size(); indexWsdl++) {
                    final BlancoWsdlWebService wsdlLook = (BlancoWsdlWebService) listWsdl
                            .get(indexWsdl);
                    if (wsdlLook.getWebServiceId().equals(
                            wsdl.getWebServiceId())) {
                        // WSDL̓o^܂B
                        if (wsdlLook.getLocation().equals(wsdl.getLocation()) == false) {
                            throw new IllegalArgumentException(bundle
                                    .getXml2wsdlCheck007(wsdlOperation
                                            .getName(), wsdl.getWebServiceId(),
                                            wsdl.getLocation(), wsdlLook
                                                    .getLocation()));
                        }

                        // d̖OԂYĂُ͈̂툵Ƃ܂B
                        if (wsdlLook.getNamespace().equals(wsdl.getNamespace()) == false) {
                            throw new IllegalArgumentException(bundle
                                    .getXml2wsdlCheck008(wsdlOperation
                                            .getName(), wsdl.getWebServiceId(),
                                            wsdl.getNamespace(), wsdlLook
                                                    .getNamespace()));
                        }

                        // pbP[WYĂꍇُ͈툵Ƃ܂B

                        // ̏ɂ͒ӂׂ_܂B
                        // dlƂāAEFuT[rXIDɂāApbP[W̔rȂ
                        // pbP[WĂꍇɈُI@\܂B
                        // ̔rɍۂāApbP[Ww̏ꍇɂ́AOԂ瓱opbP[W
                        // rsdlĔrsĂ܂B(o[WɂăpbP[Ŵ݂̕ɂĔrĂ܂B)
                        String lookPackage = BlancoStringUtil
                                .null2Blank(wsdlLook.getPackage());
                        if (lookPackage.length() == 0) {
                            lookPackage = BlancoNameUtil
                                    .uri2JavaPackage(wsdlLook.getNamespace());
                        }
                        String myPackage = BlancoStringUtil.null2Blank(wsdl
                                .getPackage());
                        if (myPackage.length() == 0) {
                            myPackage = BlancoNameUtil.uri2JavaPackage(wsdl
                                    .getNamespace());
                        }
                        if (myPackage.equals(lookPackage) == false) {
                            throw new IllegalArgumentException(bundle
                                    .getXml2wsdlCheck010(wsdlOperation
                                            .getName(), wsdl.getWebServiceId(),
                                            myPackage, wsdl.getNamespace(),
                                            lookPackage, wsdlLook
                                                    .getNamespace()));
                        }

                        // ̂ŏ㏑s܂B
                        isWsdlExist = true;
                        wsdl = wsdlLook;
                        break;
                    }
                }

                // WSDL OperationWSDL\̂ɒǉ܂B
                wsdl.getOperationList().add(wsdlOperation);
                if (isWsdlExist == false) {
                    listWsdl.add(wsdl);
                }
            }
        }
    }

    /**
     * w肳ꂽfBNgWSDLt@C𐶐܂B
     * 
     * @param targetDirectory
     *            WSDLo͂fBNg
     * @throws SAXException
     *             SAXOꍇ
     * @throws TransformerConfigurationException
     *             XMLϊOꍇ
     * @throws IOException
     *             o͗Oꍇ
     */
    public void generate(final File targetDirectory) throws SAXException,
            TransformerConfigurationException, IOException {
        // ۂWSDLt@C𐶐܂B
        for (int indexWsdl = 0; indexWsdl < listWsdl.size(); indexWsdl++) {
            final BlancoWsdlWebService wsdl = (BlancoWsdlWebService) listWsdl
                    .get(indexWsdl);
            // t@ĆAdID + .wsdl ̂悤ɂȂ܂B
            final OutputStream outStream = new BufferedOutputStream(
                    new FileOutputStream(targetDirectory.getAbsolutePath()
                            + "/" + wsdl.getWebServiceId() + ".wsdl"));
            try {
                final BlancoWsdlXml2WsdlOutputSerializer serializer = new BlancoWsdlXml2WsdlOutputSerializer(
                        outStream);
                serializer.startDocument();
                {
                    // startElementWsdlDefinitions蓮ŏo͂܂B
                    final AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute("http://www.w3.org/2000/xmlns/",
                            "tns", "xmlns:tns", "CDATA", wsdl.getNamespace());
                    attributes.addAttribute("http://www.w3.org/2000/xmlns/",
                            "wsdl", "xmlns:wsdl", "CDATA",
                            "http://schemas.xmlsoap.org/wsdl/");
                    attributes.addAttribute("http://www.w3.org/2000/xmlns/",
                            "xsd", "xmlns:xsd", "CDATA",
                            "http://www.w3.org/2001/XMLSchema");
                    attributes.addAttribute("http://www.w3.org/2000/xmlns/",
                            "http", "xmlns:http", "CDATA",
                            "http://schemas.xmlsoap.org/wsdl/http/");
                    attributes.addAttribute("http://www.w3.org/2000/xmlns/",
                            "soap", "xmlns:soap", "CDATA",
                            "http://schemas.xmlsoap.org/wsdl/soap/");
                    attributes.addAttribute("http://www.w3.org/2000/xmlns/",
                            "mime", "xmlns:mime", "CDATA",
                            "http://schemas.xmlsoap.org/wsdl/mime/");
                    attributes.addAttribute("", "jxb", "xmlns:jxb", "CDATA",
                            "http://java.sun.com/xml/ns/jaxb");

                    for (int indexOperation = 0; indexOperation < wsdl
                            .getOperationList().size(); indexOperation++) {
                        final BlancoWsdlWebServiceOperation wsdlOperation = (BlancoWsdlWebServiceOperation) wsdl
                                .getOperationList().get(indexOperation);
                        attributes.addAttribute(
                                "http://www.w3.org/2000/xmlns/", "impl"
                                        + indexOperation, "xmlns:impl"
                                        + indexOperation, "CDATA",
                                wsdlOperation.getNamespace());
                    }
                    attributes.addAttribute("", "targetNamespace",
                            "targetNamespace", "CDATA", wsdl.getNamespace());
                    // JDK̃o[Wɂ苓ɕωƍlA
                    // ڃVACYew肵ē삳܂B
                    serializer.getTransformerHandler().startElement(
                            "http://schemas.xmlsoap.org/wsdl/", "definitions",
                            "wsdl:definitions", attributes);
                }

                serializer.characters("\n  ");
                serializer.startElementWsdlTypes();
                serializer.characters("\n    ");

                // JDK1.5ł ͂PɂȂ܂BJDK1.4.2ł͈RɂȂ܂B
                serializer.startElementXsdSchema(wsdl.getNamespace());

                for (int indexOperation = 0; indexOperation < wsdl
                        .getOperationList().size(); indexOperation++) {
                    final BlancoWsdlWebServiceOperation wsdlOperation = (BlancoWsdlWebServiceOperation) wsdl
                            .getOperationList().get(indexOperation);
                    serializer.characters("\n      ");
                    serializer.startElementXsdInclude(wsdlOperation
                            .getTelegramRequestId()
                            + ".xsd");
                    serializer.endElementXsdInclude();
                    serializer.characters("\n      ");
                    serializer.startElementXsdInclude(wsdlOperation
                            .getTelegramResponseId()
                            + ".xsd");
                    serializer.endElementXsdInclude();
                    serializer.characters("\n      ");
                    serializer.startElementXsdElement(wsdlOperation
                            .getTelegramRequestId(), "impl" + indexOperation
                            + ":" + wsdlOperation.getTelegramRequestId());
                    serializer.endElementXsdElement();
                    serializer.characters("\n      ");
                    serializer.startElementXsdElement(wsdlOperation
                            .getTelegramResponseId(), "impl" + indexOperation
                            + ":" + wsdlOperation.getTelegramResponseId());
                    serializer.endElementXsdElement();
                }

                serializer.characters("\n    ");
                serializer.endElementXsdSchema();
                serializer.characters("\n  ");
                serializer.endElementWsdlTypes();

                for (int indexOperation = 0; indexOperation < wsdl
                        .getOperationList().size(); indexOperation++) {
                    final BlancoWsdlWebServiceOperation wsdlOperation = (BlancoWsdlWebServiceOperation) wsdl
                            .getOperationList().get(indexOperation);
                    serializer.characters("\n  ");
                    serializer.startElementWsdlMessage(wsdlOperation
                            .getTelegramRequestId());
                    serializer.characters("\n    ");
                    serializer.startElementWsdlPart("input", "tns:"
                            + wsdlOperation.getTelegramRequestId());
                    serializer.endElementWsdlPart();
                    serializer.characters("\n  ");
                    serializer.endElementWsdlMessage();
                    serializer.characters("\n  ");
                    serializer.startElementWsdlMessage(wsdlOperation
                            .getTelegramResponseId());
                    serializer.characters("\n    ");
                    serializer.startElementWsdlPart("output", "tns:"
                            + wsdlOperation.getTelegramResponseId());
                    serializer.endElementWsdlPart();
                    serializer.characters("\n  ");
                    serializer.endElementWsdlMessage();
                }

                serializer.characters("\n  ");
                serializer.startElementWsdlPortType(wsdl.getWebServiceId());
                for (int indexOperation = 0; indexOperation < wsdl
                        .getOperationList().size(); indexOperation++) {
                    final BlancoWsdlWebServiceOperation wsdlOperation = (BlancoWsdlWebServiceOperation) wsdl
                            .getOperationList().get(indexOperation);
                    serializer.characters("\n    ");
                    serializer.startElementWsdlOperation(wsdlOperation
                            .getName());
                    serializer.characters("\n      ");
                    serializer.startElementWsdlInput("tns:"
                            + wsdlOperation.getTelegramRequestId());
                    serializer.endElementWsdlInput();
                    serializer.characters("\n      ");
                    serializer.startElementWsdlOutput("tns:"
                            + wsdlOperation.getTelegramResponseId());
                    serializer.endElementWsdlOutput();
                    serializer.characters("\n    ");
                    serializer.endElementWsdlOperation();
                }
                serializer.characters("\n  ");
                serializer.endElementWsdlPortType();

                serializer.characters("\n  ");
                serializer.startElementWsdlBinding(wsdl.getWebServiceId()
                        + "Binding", "tns:" + wsdl.getWebServiceId());
                serializer.characters("\n    ");
                serializer.startElementSoapBinding("document",
                        "http://schemas.xmlsoap.org/soap/http");
                serializer.endElementSoapBinding();

                for (int indexOperation = 0; indexOperation < wsdl
                        .getOperationList().size(); indexOperation++) {
                    final BlancoWsdlWebServiceOperation wsdlOperation = (BlancoWsdlWebServiceOperation) wsdl
                            .getOperationList().get(indexOperation);
                    serializer.characters("\n    ");
                    serializer.startElementWsdlOperation(wsdlOperation
                            .getName());
                    serializer.characters("\n      ");
                    serializer.startElementSoapOperation();
                    serializer.endElementSoapOperation();
                    serializer.characters("\n      ");
                    serializer.startElementWsdlInput(null);
                    serializer.characters("\n        ");
                    serializer.startElementSoapBody("literal");
                    serializer.endElementSoapBody();
                    serializer.characters("\n      ");
                    serializer.endElementWsdlInput();
                    serializer.characters("\n      ");
                    serializer.startElementWsdlOutput(null);
                    serializer.characters("\n        ");
                    serializer.startElementSoapBody("literal");
                    serializer.endElementSoapBody();
                    serializer.characters("\n        ");
                    serializer.endElementWsdlOutput();
                    serializer.characters("\n      ");
                    serializer.endElementWsdlOperation();
                }

                serializer.characters("\n    ");
                serializer.endElementWsdlBinding();
                serializer.characters("\n  ");
                serializer.startElementWsdlService(wsdl.getWebServiceId()
                        + "Service");
                serializer.characters("\n    ");

                if (BlancoStringUtil.null2Blank(wsdl.getPackage()).length() > 0) {
                    // pbP[W̏annotationƂďo͂܂B
                    serializer.startElementXsdAnnotation();
                    serializer.characters("\n      ");
                    serializer.startElementXsdAppinfo();
                    serializer.characters("\n        ");
                    serializer.startElementJxbSchemaBindings();
                    serializer.characters("\n          ");
                    serializer.startElementJxbPackage(wsdl.getPackage());
                    serializer.endElementJxbPackage();
                    serializer.characters("\n        ");
                    serializer.endElementJxbSchemaBindings();
                    serializer.characters("\n      ");
                    serializer.endElementXsdAppinfo();
                    serializer.characters("\n    ");
                    serializer.endElementXsdAnnotation();
                    serializer.characters("\n    ");
                }

                serializer.startElementWsdlPort(wsdl.getWebServiceId(), "tns:"
                        + wsdl.getWebServiceId() + "Binding");
                serializer.characters("\n      ");
                serializer.startElementSoapAddress(wsdl.getLocation());
                serializer.endElementSoapAddress();
                serializer.characters("\n    ");
                serializer.endElementWsdlPort();
                serializer.characters("\n  ");
                serializer.endElementWsdlService();
                serializer.characters("\n");
                serializer.endElementWsdlDefinitions();
                serializer.endDocument();
                outStream.flush();
            } finally {
                outStream.close();
            }
        }
    }

    /**
     * XSD̖OԂ擾܂B<br>
     * ̃\bh́AI BlancoNameUtilĂяoĂ܂B
     * 
     * @param fileXsd
     *            xsdt@C
     * @param targetName
     *            ^[QbgƂȂ閼O
     * @return
     * @throws IOException
     * @throws TransformerException
     */
    private final String getNamespaceFromXsd(final File fileXsd,
            final String telegramProcessId, final String targetName)
            throws IOException, TransformerException, SAXException {
        if (fileXsd.exists() == false) {
            throw new IllegalArgumentException(bundle.getXml2wsdlCheck009(
                    telegramProcessId, targetName));
        }
        final InputStream inStream = new BufferedInputStream(
                new FileInputStream(fileXsd));
        try {
            final BlancoXsdParser parser = new BlancoXsdParser();
            final ComplexTypeStructure type = parser.process(inStream,
                    targetName);
            return type.getTargetNamespace();
        } finally {
            inStream.close();
        }
    }
}