/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherRecord;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.EscherStream;

public class EscherDisplay {
    private EscherStream stream;

    public EscherDisplay(EscherStream s) {
        this.stream = s;
    }

    public void display() {
        EscherRecordData er = new EscherRecordData(this.stream, 0);
        EscherContainer ec = new EscherContainer(er);
        this.displayContainer(ec, 0);
    }

    private void displayContainer(EscherContainer ec, int level) {
        this.displayRecord(ec, level);
        ++level;
        EscherRecord[] children = ec.getChildren();
        for (int i = 0; i < children.length; ++i) {
            EscherRecord er = children[i];
            if (er.data.isContainer()) {
                this.displayContainer((EscherContainer)er, level);
                continue;
            }
            this.displayRecord(er, level);
        }
    }

    private void displayRecord(EscherRecord er, int level) {
        this.indent(level);
        EscherRecordType type = er.getType();
        System.out.print(Integer.toString(type.getValue(), 16));
        System.out.print(" - ");
        if (type == EscherRecordType.DGG_CONTAINER) {
            System.out.println("Dgg Container");
        } else if (type == EscherRecordType.BSTORE_CONTAINER) {
            System.out.println("BStore Container");
        } else if (type == EscherRecordType.DG_CONTAINER) {
            System.out.println("Dg Container");
        } else if (type == EscherRecordType.SPGR_CONTAINER) {
            System.out.println("Spgr Container");
        } else if (type == EscherRecordType.SP_CONTAINER) {
            System.out.println("Sp Container");
        } else if (type == EscherRecordType.DGG) {
            System.out.println("Dgg");
        } else if (type == EscherRecordType.BSE) {
            System.out.println("Bse");
        } else if (type == EscherRecordType.DG) {
            System.out.println("Dg");
        } else if (type == EscherRecordType.SPGR) {
            System.out.println("Spgr");
        } else if (type == EscherRecordType.SP) {
            System.out.println("Sp");
        } else if (type == EscherRecordType.OPT) {
            System.out.println("Opt");
        } else if (type == EscherRecordType.CLIENT_ANCHOR) {
            System.out.println("Client Anchor");
        } else if (type == EscherRecordType.CLIENT_DATA) {
            System.out.println("Client Data");
        } else if (type == EscherRecordType.CLIENT_TEXT_BOX) {
            System.out.println("Client Text Box");
        } else if (type == EscherRecordType.SPLIT_MENU_COLORS) {
            System.out.println("Split Menu Colors");
        } else {
            System.out.println("???");
        }
    }

    private void indent(int level) {
        for (int i = 0; i < level * 2; ++i) {
            System.out.print(' ');
        }
    }
}

