/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.method.MethodExpander;
import blanco.valueobject.resourcebundle.BlancoValueObjectResourceBundle;
import blanco.valueobject.util.BlancoValueObjectUtil;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

/**
 * blancoValueObject̎傽NXB
 * 
 * blancoValueObject\XMLt@C Java\[XR[h܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectXml2JavaClass {
    private final BlancoValueObjectResourceBundle bundle = new BlancoValueObjectResourceBundle();

    /**
     * ValueObject\XMLt@C Java\[XR[h܂B
     * 
     * @param metaXmlSourceFile
     *            ValueObjectɊւ郁^񂪊܂܂ĂXMLt@C
     * @param directoryTarget
     *            \[XR[hfBNg
     * @throws IOException
     *             o͗Oꍇ
     */
    public void process(final File metaXmlSourceFile, final File directoryTarget)
            throws IOException {

        final DOMResult result = BlancoXmlUtil
                .transformFile2Dom(metaXmlSourceFile);

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);

                NodeList listCommon = elementSheet
                        .getElementsByTagName("blancovalueobject-common");
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                Element elementCommon = (Element) listCommon.item(0);
                final String name = BlancoXmlUtil.getTextContent(elementCommon,
                        "name");
                if (name == null || name.trim().length() == 0) {
                    continue;
                }

                final BlancoValueObjectClassStructure objClassStructure = new BlancoValueObjectClassStructure();
                expandSheet(elementSheet, objClassStructure);

                /**
                 * ꂽ񂩂Java\[XR[h𐶐܂B
                 */
                processJavaSource(objClassStructure, directoryTarget);
            }
        }
    }

    public void expandSheet(final Element elementSheet,
            BlancoValueObjectClassStructure objClassStructure) {
        NodeList listCommon = elementSheet
                .getElementsByTagName("blancovalueobject-common");
        final Element elementCommon = (Element) listCommon.item(0);
        objClassStructure.setName(BlancoXmlUtil.getTextContent(elementCommon,
                "name"));
        objClassStructure.setPackage(BlancoXmlUtil.getTextContent(
                elementCommon, "package"));
        objClassStructure.setJavadoc(BlancoXmlUtil.getTextContent(
                elementCommon, "description"));
        objClassStructure.setFilecomment(BlancoXmlUtil.getTextContent(
                elementCommon, "fileDescription"));
        objClassStructure.setListField(new ArrayList());

        if (objClassStructure.getPackage() == null) {
            throw new IllegalArgumentException(bundle
                    .getXml2javaclassErr001(objClassStructure.getName()));
        }

        final NodeList listList = elementSheet
                .getElementsByTagName("blancovalueobject-list");
        final Element elementListRoot = (Element) listList.item(0);
        final NodeList listChildNodes = elementListRoot.getChildNodes();
        for (int index = 0; index < listChildNodes.getLength(); index++) {
            if (listChildNodes.item(index) instanceof Element == false) {
                continue;
            }
            final Element elementList = (Element) listChildNodes.item(index);
            final BlancoValueObjectFieldStructure fieldStructure = new BlancoValueObjectFieldStructure();

            fieldStructure.setNo(BlancoXmlUtil
                    .getTextContent(elementList, "no"));
            fieldStructure.setName(BlancoXmlUtil.getTextContent(elementList,
                    "name"));
            if (fieldStructure.getName() == null
                    || fieldStructure.getName().trim().length() == 0) {
                continue;
            }

            fieldStructure.setType(BlancoXmlUtil.getTextContent(elementList,
                    "type"));
            fieldStructure.setJavadoc(BlancoXmlUtil.getTextContent(elementList,
                    "description"));
            fieldStructure.setDefault(BlancoXmlUtil.getTextContent(elementList,
                    "default"));
            fieldStructure.setMinLength(BlancoXmlUtil.getTextContent(
                    elementList, "minLength"));
            fieldStructure.setMaxLength(BlancoXmlUtil.getTextContent(
                    elementList, "maxLength"));
            fieldStructure.setLength(BlancoXmlUtil.getTextContent(elementList,
                    "length"));
            fieldStructure.setMinInclusive(BlancoXmlUtil.getTextContent(
                    elementList, "minInclusive"));
            fieldStructure.setMaxInclusive(BlancoXmlUtil.getTextContent(
                    elementList, "maxInclusive"));
            fieldStructure.setPattern(BlancoXmlUtil.getTextContent(elementList,
                    "pattern"));

            if (fieldStructure.getType() == null
                    || fieldStructure.getType().trim().length() == 0) {
                throw new IllegalArgumentException(bundle
                        .getXml2javaclassErr002(objClassStructure.getName(),
                                fieldStructure.getName()));
            }

            objClassStructure.getListField().add(fieldStructure);
        }
    }

    /**
     * ^ꂽNXƂJava\[XR[h܂B
     * 
     * @param classInfo
     *            NX
     * @param directoryTarget
     *            Java\[XR[h̏o͐fBNg
     * @throws IOException
     *             o͗OꍇB
     */
    private void processJavaSource(
            final BlancoValueObjectClassStructure classInfo,
            final File directoryTarget) throws IOException {
        final ClassExpander classExpander = new ClassExpander(new Type(
                classInfo.getPackage(), classInfo.getName())) {
            protected void expandClassStruct() {
                if (classInfo.getFilecomment() != null) {
                    String[] lines = BlancoValueObjectUtil
                            .escapeStringAsJavaDocWithNewLine(classInfo
                                    .getFilecomment());
                    for (int index = 0; index < lines.length; index++) {
                        addFileComment(lines[index]);
                    }
                }

                if (classInfo.getJavadoc() != null) {
                    final String[] lines = BlancoValueObjectUtil
                            .escapeStringAsJavaDocWithNewLine(classInfo
                                    .getJavadoc());
                    for (int index = 0; index < lines.length; index++) {
                        getJavaDoc().addLine(lines[index]);
                    }
                }

                for (int indexField = 0; indexField < classInfo.getListField()
                        .size(); indexField++) {
                    final BlancoValueObjectFieldStructure field = (BlancoValueObjectFieldStructure) classInfo
                            .getListField().get(indexField);

                    if (field.getName() == null) {
                        throw new IllegalArgumentException(bundle
                                .getXml2javaclassErr003(classInfo.getName()));
                    }
                    if (field.getType() == null) {
                        throw new IllegalArgumentException(bundle
                                .getXml2javaclassErr004(classInfo.getName(),
                                        field.getName()));
                    }

                    final String fieldNameAdjustered = BlancoNameAdjuster
                            .toClassName(field.getName());

                    final FieldExpander field1 = new FieldExpander(new Type(
                            field.getType()), "f" + fieldNameAdjustered);
                    field1.getJavaDoc().addLine(
                            bundle.getXml2javaclassFieldName(field.getName()));
                    field1.getJavaDoc().addLine(
                            bundle.getXml2javaclassFieldType(field.getType()));
                    if (field.getDefault() != null) {
                        field1.getJavaDoc().addLine(
                                bundle.getXml2javaclassFieldDefault(field
                                        .getDefault()));
                        if (field.getType().equals("java.lang.String")) {
                            field1.setDefaultStatement(new Statement("\""
                                    + BlancoJavaSourceUtil
                                            .escapeStringAsJavaSource(field
                                                    .getDefault()) + "\""));
                        } else if (field.getType().equals("boolean")
                                || field.getType().equals("short")
                                || field.getType().equals("int")
                                || field.getType().equals("long")) {
                            field1.setDefaultStatement(new Statement(field
                                    .getDefault()));
                        } else if (field.getType().equals("java.lang.Boolean")
                                || field.getType().equals("java.lang.Integer")
                                || field.getType().equals("java.lang.Long")) {
                            field1.setDefaultStatement(new Statement("new "
                                    + BlancoNameUtil.trimJavaPackage(field
                                            .getType()) + "("
                                    + field.getDefault() + ")"));
                        } else if (field.getType().equals("java.lang.Short")) {
                            field1.setDefaultStatement(new Statement("new "
                                    + BlancoNameUtil.trimJavaPackage(field
                                            .getType()) + "((short) "
                                    + field.getDefault() + ")"));
                        } else if (field.getType().equals(
                                "java.math.BigDecimal")) {
                            addImport(new Type("java.math.BigDecimal"));
                            field1.setDefaultStatement(new Statement(
                                    "new BigDecimal(\"" + field.getDefault()
                                            + "\")"));
                        } else if (field.getType()
                                .equals("java.util.ArrayList")) {
                            // ArrayList̏ꍇɂ́A^ꂽ̂܂܍̗p܂B
                            addImport(new Type("java.util.ArrayList"));
                            field1.setDefaultStatement(new Statement(field
                                    .getDefault()));
                        } else {
                            throw new IllegalArgumentException(bundle
                                    .getXml2javaclassErr005(
                                            classInfo.getName(), field
                                                    .getName(), field
                                                    .getDefault(), field
                                                    .getType()));
                        }
                    }
                    if (field.getJavadoc() != null) {
                        final String[] lines = BlancoValueObjectUtil
                                .escapeStringAsJavaDocWithNewLine(field
                                        .getJavadoc());
                        for (int index = 0; index < lines.length; index++) {
                            field1.getJavaDoc().addLine(lines[index]);
                        }
                    }
                    addField(field1);

                    addMethod(new MethodExpander("set" + fieldNameAdjustered) {
                        // \bh̃VOj`w
                        public void setupSignature() {
                            getJavaDoc().addLine(
                                    bundle.getXml2javaclassSetJavadoc01(field
                                            .getName()));
                            getJavaDoc().addLine(
                                    bundle.getXml2javaclassSetJavadoc02(field
                                            .getType()));
                            if (field.getJavadoc() != null) {
                                final String[] lines = BlancoValueObjectUtil
                                        .escapeStringAsJavaDocWithNewLine(field
                                                .getJavadoc());
                                for (int index = 0; index < lines.length; index++) {
                                    getJavaDoc().addLine(lines[index]);
                                }
                            }

                            getJavaDoc().addParameter(
                                    "arg" + fieldNameAdjustered,
                                    bundle.getXml2javaclassSetArgJavadoc(field
                                            .getName()));
                            addArgument(new Value(new Type(field.getType()),
                                    "arg" + fieldNameAdjustered));
                        }

                        // \bh̎
                        public void implement() {
                            getData().addLine(
                                    "f" + fieldNameAdjustered + " = " + "arg"
                                            + fieldNameAdjustered + ";");
                        }
                    });

                    addMethod(new MethodExpander("get" + fieldNameAdjustered) {
                        // \bh̃VOj`w
                        public void setupSignature() {
                            getJavaDoc().addLine(
                                    bundle.getXml2javaclassGetJavadoc01(field
                                            .getName()));
                            getJavaDoc().addLine(
                                    bundle.getXml2javaclassGetJavadoc02(field
                                            .getType()));
                            if (field.getDefault() != null) {
                                getJavaDoc()
                                        .addLine(
                                                bundle
                                                        .getXml2javaclassGetArgJavadoc(field
                                                                .getDefault()));
                            }
                            if (field.getJavadoc() != null) {
                                final String[] lines = BlancoValueObjectUtil
                                        .escapeStringAsJavaDocWithNewLine(field
                                                .getJavadoc());
                                for (int index = 0; index < lines.length; index++) {
                                    getJavaDoc().addLine(lines[index]);
                                }
                            }

                            getJavaDoc()
                                    .addReturn(
                                            bundle
                                                    .getXml2javaclassGetReturnJavadoc(field
                                                            .getName()));
                            setReturnType(new Type(field.getType()));
                        }

                        // \bh̎
                        public void implement() {
                            getData().addLine(
                                    "return f" + fieldNameAdjustered + ";");
                        }
                    });
                }

                addMethod(new MethodExpander("toString") {
                    public void setupSignature() {
                        getJavaDoc().addLine("̃o[IuWFNg̕\擾܂B");
                        getJavaDoc().addLine("");
                        getJavaDoc().addLine(
                                "IuWFNg̃V[͈͂łtoStringȂ_ɒӂėpĂB");
                        getJavaDoc().addReturn("o[IuWFNg̕\B");
                        setReturnType(new Type("java.lang.String"));
                    }

                    public void implement() {
                        getData().addLine(
                                "final StringBuffer buf = new StringBuffer();");
                        getData().addLine(
                                "buf.append(\"" + classInfo.getPackage() + "."
                                        + classInfo.getName() + "[\");");
                        for (int indexField = 0; indexField < classInfo
                                .getListField().size(); indexField++) {
                            final BlancoValueObjectFieldStructure field = (BlancoValueObjectFieldStructure) classInfo
                                    .getListField().get(indexField);
                            if (field.getType().endsWith("[]") == false) {
                                getData().addLine(
                                        "buf.append(\""
                                                + (indexField == 0 ? "" : ",")
                                                + field.getName()
                                                + "=\" + f"
                                                + BlancoNameAdjuster
                                                        .toClassName(field
                                                                .getName())
                                                + ");");
                            } else {
                                // z̏ꍇɂ̓fB[vtoString܂B
                                getData().addLine(
                                        "for (int index = 0; index < f"
                                                + BlancoNameAdjuster
                                                        .toClassName(field
                                                                .getName())
                                                + ".length; index++) {");
                                getData()
                                        .addLine(
                                                "buf.append("
                                                        // 0Ԗڂ̍ڂłꍇɂ̂݁AZJo܂B
                                                        + (indexField == 0 ? "(index == 0 ? \"\" : \",\") + \""
                                                                :
                                                                // 0Ԗڂł͂Ȃꍇɂ́AɃJ}t^܂B
                                                                "\",")
                                                        + field.getName()
                                                        + "=\" + f"
                                                        + BlancoNameAdjuster
                                                                .toClassName(field
                                                                        .getName())
                                                        + "[index]);");
                                getData().addLine("}");
                            }
                        }
                        getData().addLine("buf.append(\"]\");");
                        getData().addLine("return buf.toString();");
                    }
                });
            }
        };

        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
