/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.resourcebundle.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import org.apache.tools.ant.BuildException;

import blanco.constants.BlancoConstantsXml2JavaClass;
import blanco.resourcebundle.BlancoResourceBundleMeta2Xml;
import blanco.resourcebundle.BlancoResourceBundleXml2CombinedXml;
import blanco.resourcebundle.BlancoResourceBundleXml2ConstantsXml;
import blanco.resourcebundle.BlancoResourceBundleXml2JavaClass;
import blanco.resourcebundle.BlancoResourceBundleXml2Properties;
import blanco.resourcebundle.BlancoResourceBundleXmlValidator;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;

/**
 * \[Xoh`vpeBt@CуANZTJava\[XR[h𐶐 Apache Ant^XNłB
 * 
 * ̃\[XR[hblancoResourceBundlëꕔłB<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleTask extends AbstractBlancoResourceBundleTask {
    /**
     * \[XohANZT̃CX^XB
     */
    private final BlancoResourceBundleResourceBundle bundle = new BlancoResourceBundleResourceBundle();

    /**
     * \[Xoh`vpeBt@CуANZTJava\[XR[h𐶐 Apache Ant^XNłB
     */
    protected void process() throws IllegalArgumentException {
        try {
            final File blancoTmpResourceBundleDirectory = new File(getTmpdir()
                    + "/resourcebundle");
            blancoTmpResourceBundleDirectory.mkdirs();

            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new BuildException(bundle.getTaskErr001(getMetadir()));
            }

            // xlst@Cxmlt@Cւƕϊ܂B
            new BlancoResourceBundleMeta2Xml().processDirectory(fileMetadir,
                    blancoTmpResourceBundleDirectory.getAbsolutePath());

            // e|tH_XMLt@Cgݑւ combinedxmlt@C𐶐܂B
            final File[] fileMeta = blancoTmpResourceBundleDirectory
                    .listFiles();
            for (int index = 0; index < fileMeta.length; index++) {
                if (fileMeta[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                final File fileTmpTargetCombine = new File(
                        blancoTmpResourceBundleDirectory + "/"
                                + fileMeta[index].getName() + ".combinedxml");
                // XMLt@C̑gݑւs܂B
                new BlancoResourceBundleXml2CombinedXml().process(
                        fileMeta[index], fileTmpTargetCombine);
            }

            final File[] fileTmp = blancoTmpResourceBundleDirectory.listFiles();
            for (int index = 0; index < fileTmp.length; index++) {
                if (fileTmp[index].getName().endsWith(".combinedxml")) {
                    final BlancoResourceBundleXmlValidator xmlValidator = new BlancoResourceBundleXmlValidator();
                    xmlValidator.setFailOnMessageFormatError("true"
                            .equals(getFailonmessageformaterror()));
                    xmlValidator.process(fileTmp[index], new File(
                            getTargetdir()));

                    if ("true".equals(bundle.getGenerateBundleSource())) {
                        final BlancoResourceBundleXml2JavaClass xml2javaclass = new BlancoResourceBundleXml2JavaClass();
                        // \[XohANZT̃\[XR[h𐶐邩ǂtOZbgB
                        // MessageFormatp[XɃG[ꍇɏf邩ǂtOZbgB
                        xml2javaclass.setFailOnMessageFormatError("true"
                                .equals(getFailonmessageformaterror()));
                        // ۂ̃\[XR[hsB
                        xml2javaclass.process(fileTmp[index], new File(
                                getTargetdir()));
                    }

                    if ("true".equals(bundle.getGenerateConstantsSource())) {
                        // 萔NX̐[hONłB
                        // \[XohXMLt@C͂ɁA萔NX̒XMLt@C𐶐܂B
                        new BlancoResourceBundleXml2ConstantsXml().process(
                                fileTmp[index],
                                blancoTmpResourceBundleDirectory);
                    }
                } else if (fileTmp[index].getName().endsWith(".xml")) {
                    final BlancoResourceBundleXml2Properties xml2properties = new BlancoResourceBundleXml2Properties();
                    xml2properties.setCommentTimestamp("true"
                            .equals(getCommenttimestamp()));
                    xml2properties.process(fileTmp[index], new File(
                            getTargetdir() + "/main"));
                }
            }

            if ("true".equals(bundle.getGenerateConstantsSource())) {
                // 萔NX̐[hONłB
                // 萔NX̒XMLt@CA萔NX𐶐܂B
                final File[] fileTmpConstants = new File(
                        blancoTmpResourceBundleDirectory.getAbsolutePath()
                                + "/constants").listFiles();
                for (int index = 0; index < fileTmpConstants.length; index++) {
                    if (fileTmpConstants[index].getName().endsWith(
                            ".constantsxml")) {
                        new BlancoConstantsXml2JavaClass().process(
                                fileTmpConstants[index], new File(
                                        getTargetdir()));
                    }
                }
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (TransformerException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }
}
