package blanco.xsd;

import junit.framework.TestCase;

public class BlancoXsdUtilTest extends TestCase {
    public void testMinOccurs2Int() {
        assertEquals(3, BlancoXsdUtil.minOccurs2Int("3"));
        try {
            assertEquals(Integer.MAX_VALUE, BlancoXsdUtil
                    .minOccurs2Int(BlancoXsdUtil.MAX_OCCURS_UNBOUNDED));
            fail("minOccurs2IntɂunboundedpłȂƂ̊mF");
        } catch (NumberFormatException ex) {
            // minOccursɂunbounded͎wł܂B
            // ꂪn
        }
        try {
            BlancoXsdUtil.minOccurs2Int("abc");
            fail("minOccurs2Intɂ͔Cӂ̕񂪗płȂƂ̊mF");
        } catch (NumberFormatException ex) {
            // ꂪnBabcȂĕ͎wł܂B
        }
        try {
            BlancoXsdUtil.minOccurs2Int("-1");
            fail("minOccurs2Intɂ͕̒lpłȂƂ̊mF");
        } catch (IllegalArgumentException ex) {
            // ꂪnB̒l^Kv܂B
        }
    }

    public void testMaxOccurs2Int() {
        assertEquals(3, BlancoXsdUtil.maxOccurs2Int("3"));
        assertEquals(Integer.MAX_VALUE, BlancoXsdUtil
                .maxOccurs2Int(BlancoXsdUtil.MAX_OCCURS_UNBOUNDED));
        try {
            BlancoXsdUtil.maxOccurs2Int("abc");
            fail("maxOccurs2Intɂ͕񂪗płȂƂ̊mF");
        } catch (NumberFormatException ex) {
            // ꂪnBabcȂĕ͓͂łȂ̂łB
        }
        try {
            BlancoXsdUtil.maxOccurs2Int("-1");
            fail("maxOccurs2Intɂ͕̒lpłȂƂ̊mF");
        } catch (IllegalArgumentException ex) {
            // ꂪnB0ȏ̒l^ȂƂ܂B
        }
    }

    public void testIsMaxOccursArray() {
        assertEquals("unbounded͔zƂĔ肳邱ƂmF", true, BlancoXsdUtil
                .isMaxOccursArray(BlancoXsdUtil.MAX_OCCURS_UNBOUNDED));
        assertEquals("null^ꂽꍇɂ͔zł͂ȂƔ肳邱ƂmF", false, BlancoXsdUtil
                .isMaxOccursArray(null));
        assertEquals("0̕񂪗^ꂽꍇɂ͔zł͂ȂƔ肳邱ƂmF", false, BlancoXsdUtil
                .isMaxOccursArray(""));
        assertEquals(false, BlancoXsdUtil.isMaxOccursArray("0"));
        assertEquals(false, BlancoXsdUtil.isMaxOccursArray("1"));
        assertEquals(true, BlancoXsdUtil.isMaxOccursArray("2"));
    }
}
