/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xsd;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.xsd.parser.AbstractTypeStructure;
import blanco.xsd.parser.BlancoXsdParser;
import blanco.xsd.parser.ComplexTypeFieldStructure;
import blanco.xsd.parser.ComplexTypeStructure;
import blanco.xsd.resourcebundle.BlancoXsdResourceBundle;

/**
 * ^ꂽXSDt@CAblancoSOAPƂĊ҂ XML Schema (xsd) ̌`ɂȂĂ邩ǂ̑Ó؂s܂B
 * 
 * ̃NXblancoSOAP҂`xsdt@C邱Ƃł܂B<br>
 *  blancoSOAPŗL̃of[V`FbNčs܂B<br>
 * xsdƂĐł͂ȂblancoƂĖ]܂pł邩ǂ`FbNĂ_ɒڂĂB
 * 
 * @author IGA Tosiki
 */
public class BlancoXsdXsdValidator {
    /**
     * fobO[hœ삳邩ǂB
     */
    private static final boolean IS_DEBUG = false;

    /**
     * \[XohIuWFNgB
     */
    private final BlancoXsdResourceBundle bundle = new BlancoXsdResourceBundle();

    /**
     * `FbNς݂̌^̃}bvB
     */
    private HashMap checkedType = new HashMap();

    /**
     * ^ꂽxsd̑Ó؂܂B<br>
     * łblancoL̎dl܂߂Ó`FbNs܂B
     * 
     * @param inStream
     * @param targetName
     * @return
     * @throws IOException
     * @throws TransformerException
     * @throws SAXException
     */
    public ComplexTypeStructure process(final InputStream inStream,
            final String targetName) throws IOException, TransformerException,
            SAXException {
        // xsdp[X܂B
        BlancoXsdParser parser = new BlancoXsdParser();
        final ComplexTypeStructure type = parser.process(inStream, targetName);

        // [gm[hɌJԂڂȂ`FbN
        checkChildComplexTypeOfRoot(type);

        // ^̂ڂĂă`FbNs܂B
        expandComplexType(type);

        checkUnprocessedType(parser.getAllKnownTypes());

        return type;
    }

    /**
     * [gm[hɌJԂڂȂ`FbN܂B
     * 
     * [gƂȂ镡^ɂ́AuMaxv2ȏ(邢unbounded)̍ڒ`sƂ͂ł܂B
     * 
     * @param type
     * @throws SAXException
     * @throws IOException
     * @throws TransformerConfigurationException
     */
    private void checkChildComplexTypeOfRoot(final ComplexTypeStructure type)
            throws SAXException, IOException, TransformerConfigurationException {

        if (IS_DEBUG) {
            System.out.println("[g̕^[" + type.getName() + "]`FbN܂");
        }

        for (int index = 0; index < type.getListField().size(); index++) {
            final ComplexTypeFieldStructure field = (ComplexTypeFieldStructure) type
                    .getListField().get(index);

            if (BlancoXsdUtil.isMaxOccursArray(field.getMaxOccurs())) {
                throw new IllegalArgumentException(bundle
                        .getXsdValidatorErr003(type.getName(), field
                                .getTypeStructure().getName()));
            }
        }
    }

    /**
     * ^ꂽ^̑Ó`FbN܂B
     * 
     * @param type
     * @throws SAXException
     * @throws IOException
     * @throws TransformerConfigurationException
     */
    private void expandComplexType(final ComplexTypeStructure type)
            throws SAXException, IOException, TransformerConfigurationException {

        if (checkedType.get(type.getName()) != null) {
            // ̌^ɂẮAς݂łB߂܂B
            // ͎ȂElement̐錾sꍇȂǂɔԂłB
            return;
        }

        checkedType.put(type.getName(), type);

        // ܂ɎQƂĂNXWJ܂B
        for (int index = 0; index < type.getListField().size(); index++) {
            final ComplexTypeFieldStructure field = (ComplexTypeFieldStructure) type
                    .getListField().get(index);

            if (field.getTypeStructure() instanceof ComplexTypeStructure) {
                expandComplexType((ComplexTypeStructure) field
                        .getTypeStructure());
            } else {
                // if (IS_DEBUG) {
                // System.out.println("^[" + field.getFieldName()
                // + "]܂B");
                // }
            }
        }

        if (IS_DEBUG) {
            System.out.println("^[" + type.getName() + "]`FbN܂");
        }

        AbstractTypeStructure typeStructureFound = null;
        for (int index = 0; index < type.getListField().size(); index++) {
            final ComplexTypeFieldStructure field = (ComplexTypeFieldStructure) type
                    .getListField().get(index);

            if (BlancoXsdUtil.isMaxOccursArray(field.getMaxOccurs())) {
                // ̏ꍇɂ͔z񈵂܂B
                typeStructureFound = field.getTypeStructure();
                if (IS_DEBUG) {
                    System.out.println("^["
                            + field.getFieldName()
                            + "]͌^["
                            + field.getTypeStructure()
                                    .getTypeOfJavaWithoutArray() + "]̔złB");
                }
            } else {
                if (IS_DEBUG) {
                    System.out
                            .println("^[" + field.getFieldName() + "]͕ʂ̌^["
                                    + field.getTypeStructure().getTypeOfJava()
                                    + "]łB");
                }
            }
            checkedType.put(field.getFieldName(), field.getTypeStructure());
        }

        if (type.getListField().size() > 1 && typeStructureFound != null) {
            throw new IllegalArgumentException(bundle.getXsdValidatorErr001(
                    type.getName(), typeStructureFound.getName()));
        }
    }

    /**
     * ̕^݂Ȃǂ`FbN܂B
     * 
     * ̕^ꂽꍇɂ͗O𔭐܂B
     * 
     * @param allKnownTypes
     */
    private void checkUnprocessedType(final LinkedHashMap allKnownTypes) {
        for (Iterator ite = allKnownTypes.values().iterator(); ite.hasNext();) {
            final AbstractTypeStructure typeLook = (AbstractTypeStructure) ite
                    .next();
            if (typeLook instanceof ComplexTypeStructure) {
                if (checkedType.get(typeLook.getName()) == null) {
                    throw new IllegalArgumentException(bundle
                            .getXsdValidatorErr002(typeLook.getName()));
                }
            }
        }
    }
}