/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.test.db.ddl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import blanco.commons.util.BlancoNameUtil;

/**
 * {vOblancoDb̎ڂ̂AP\Ɋւ鎎{邽߂̃[eBeBłB
 * 
 * 1̗񂪊܂܂ꂽ\ΏۂƂȂ܂B<br>
 * ̃vO SQL Server 2005pDDL𐶐܂B
 */
public class SimpleTableSQLServer2005SingleColumnDDL {
    /**
     * DDL̏o̓C^B
     */
    private PrintWriter fWriter = null;

    /**
     * DDL̍쐬s܂B
     * 
     * @param args
     *            Bw肳ꂽe͖܂B
     */
    public static void main(final String[] args) {
        try {
            new SimpleTableSQLServer2005SingleColumnDDL().generate();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private final void generate() throws IOException {
        final File fileTargetDirectory = new File("./sqlserver2005/ddl");
        if (fileTargetDirectory.exists() == false) {
            fileTargetDirectory.mkdirs();
        }

        fWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(
                fileTargetDirectory.getAbsolutePath()
                        + "/"
                        + BlancoNameUtil.trimJavaPackage(this.getClass()
                                .getName()) + ".txt")));
        try {
            fWriter.println("------------------------------------------");
            fWriter.println("-- 폜GAłB --");
            fWriter.println("------------------------------------------");

            generateDeleteSingleColumnPrimary();
            generateDeleteSingleColumnNonPrimary();
            generateDeleteSingleColumnPrimaryNullable();
            generateDeleteSingleColumnNonPrimaryNullable();

            fWriter.println("------------------------------------------");
            fWriter.println("-- 琶GAłB --");
            fWriter.println("------------------------------------------");

            generateSingleColumnPrimary();
            generateSingleColumnNonPrimary();
            generateSingleColumnPrimaryNullable();
            generateSingleColumnNonPrimaryNullable();
        } finally {
            fWriter.close();
        }
    }

    private final void generateSingleColumnPrimary() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 1̃vC}L[ɂ\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                fWriter.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                fWriter.println("");
                continue;
            }

            fWriter.println("/*1̃vC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            fWriter.println("CREATE TABLE TEST_SINGLE_COLUMN_PRIMARY_"
                    + (index + 1) + " (");
            fWriter.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index] + " NOT NULL");
            fWriter.println(", PRIMARY KEY (FIELD_" + fieldName + ")");
            fWriter.println(");");
            fWriter.println("");
        }
    }

    private final void generateSingleColumnPrimaryNullable() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 1NULLeȃvC}L[ɂ\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                fWriter.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                fWriter.println("");
                continue;
            }

            fWriter.println("/*1̃vC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            fWriter.println("CREATE TABLE TEST_SINGLE_COLUMN_PRIMARY_"
                    + (index + 1) + "_NULLABLE (");
            fWriter.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index]);
            fWriter.println(", PRIMARY KEY (FIELD_" + fieldName + ")");
            fWriter.println(");");
            fWriter.println("");
        }
    }

    private final void generateSingleColumnNonPrimary() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 1̗ɂ\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println("/*1̔vC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            fWriter.println("CREATE TABLE TEST_SINGLE_COLUMN_NONPRIMARY_"
                    + (index + 1) + " (");
            fWriter.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index] + " NOT NULL");
            fWriter.println(");");
            fWriter.println("");
        }
    }

    private final void generateSingleColumnNonPrimaryNullable() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 1NULLeȗɂ\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println("/*1̔vC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            fWriter.println("CREATE TABLE TEST_SINGLE_COLUMN_NONPRIMARY_"
                    + (index + 1) + "_NULLABLE (");
            fWriter.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index]);
            fWriter.println(");");
            fWriter.println("");
        }
    }

    // ͍폜GAłB
    // 폜pDDL𐶐܂B

    private final void generateDeleteSingleColumnPrimary() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 1̃vC}L[ɂ\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                fWriter.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                fWriter.println("");
                continue;
            }

            fWriter.println("DROP TABLE TEST_SINGLE_COLUMN_PRIMARY_"
                    + (index + 1) + ";");
        }
    }

    private final void generateDeleteSingleColumnPrimaryNullable() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 1NULLeȃvC}L[ɂ\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                fWriter.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                fWriter.println("");
                continue;
            }

            fWriter.println("DROP TABLE TEST_SINGLE_COLUMN_PRIMARY_"
                    + (index + 1) + "_NULLABLE;");
        }
    }

    private final void generateDeleteSingleColumnNonPrimary() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 1̗ɂ\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println("DROP TABLE TEST_SINGLE_COLUMN_NONPRIMARY_"
                    + (index + 1) + ";");
        }
    }

    private final void generateDeleteSingleColumnNonPrimaryNullable() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 1NULLeȗɂ\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println("DROP TABLE TEST_SINGLE_COLUMN_NONPRIMARY_"
                    + (index + 1) + "_NULLABLE;");
        }
    }

}
