/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.test.db.ddl;

/**
 * {vOblancoDb̎ڂ̂AP\Ɋւ鎎{邽߂̃[eBeBłB
 * 
 * 1̗񂪊܂܂ꂽ\ΏۂƂȂ܂B<br>
 * ̃vO SQL Server 2000pDDL𐶐܂B
 */
public class SimpleTableSQLServer2000DoubleColumnDDL {
    /**
     * DDL̍쐬s܂B
     * 
     * @param args
     *            Bw肳ꂽe͖܂B
     */
    public static void main(final String[] args) {
        System.out.println("------------------------------------------");
        System.out.println("-- 폜GAłB --");
        System.out.println("------------------------------------------");

        generateDeleteDoubleColumnPrimary1();
        generateDeleteDoubleColumnPrimary2();
        generateDeleteDoubleColumnPrimary3();
        generateDeleteDoubleColumnNonPrimary();
        generateDeleteDoubleColumnPrimary1Nullable();
        generateDeleteDoubleColumnPrimary2Nullable();
        generateDeleteDoubleColumnPrimary3Nullable();
        generateDeleteDoubleColumnNonPrimaryNullable();

        System.out.println("------------------------------------------");
        System.out.println("-- 琶GAłB --");
        System.out.println("------------------------------------------");

        generateDoubleColumnPrimary1();
        generateDoubleColumnPrimary2();
        generateDoubleColumnPrimary3();
        generateDoubleColumnNonPrimary();
        generateDoubleColumnPrimary1Nullable();
        generateDoubleColumnPrimary2Nullable();
        generateDoubleColumnPrimary3Nullable();
        generateDoubleColumnNonPrimaryNullable();
    }

    private static final void generateDoubleColumnPrimary1() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2̍ڂŁA1ڂ̃vC}L[ɂ\쐬܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                System.out.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                System.out.println("");
                continue;
            }

            System.out.println("/*2̍ڂŁA1ڂvC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            System.out.println("CREATE TABLE TEST_DOUBLE_COLUMN_PRIMARY1_"
                    + (index + 1) + " (");
            System.out.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index] + " NOT NULL");
            System.out.println(", FIELD_VARCHAR_FIXED VARCHAR(50) NOT NULL");
            System.out.println(", PRIMARY KEY (FIELD_" + fieldName + ")");
            System.out.println(");");
            System.out.println("");
        }
    }

    private static final void generateDoubleColumnPrimary2() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2̍ڂŁA2ڂ̃vC}L[ɂ\쐬܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            System.out.println("/*2̍ڂŁA2ڂvC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            System.out.println("CREATE TABLE TEST_DOUBLE_COLUMN_PRIMARY2_"
                    + (index + 1) + " (");
            System.out.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index] + " NOT NULL");
            System.out.println(", FIELD_VARCHAR_FIXED VARCHAR(50) NOT NULL");
            System.out.println(", PRIMARY KEY (FIELD_VARCHAR_FIXED)");
            System.out.println(");");
            System.out.println("");
        }
    }

    private static final void generateDoubleColumnPrimary3() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2̍ڂŁA2ƂvC}L[ł\쐬܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                System.out.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                System.out.println("");
                continue;
            }

            System.out.println("/*2̍ڂŁAƂvC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            System.out.println("CREATE TABLE TEST_DOUBLE_COLUMN_PRIMARY3_"
                    + (index + 1) + " (");
            System.out.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index] + " NOT NULL");
            System.out.println(", FIELD_VARCHAR_FIXED VARCHAR(50) NOT NULL");
            System.out.println(", PRIMARY KEY (FIELD_" + fieldName
                    + ", FIELD_VARCHAR_FIXED)");
            System.out.println(");");
            System.out.println("");
        }
    }

    private static final void generateDoubleColumnNonPrimary() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2̍ڂŁA2ƂvC}L[łȂ\쐬܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            System.out.println("/*2̍ڂŁAƂvC}L[łȂ\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            System.out.println("CREATE TABLE TEST_DOUBLE_COLUMN_NON_PRIMARY_"
                    + (index + 1) + " (");
            System.out.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index] + " NOT NULL");
            System.out.println(", FIELD_VARCHAR_FIXED VARCHAR(50) NOT NULL");
            System.out.println(");");
            System.out.println("");
        }
    }

    private static final void generateDoubleColumnPrimary1Nullable() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2nulleȍڂŁA1ڂvC}L[ł\쐬܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                System.out.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                System.out.println("");
                continue;
            }

            System.out.println("/*2nulleȍڂŁA1ڂvC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            System.out.println("CREATE TABLE TEST_DOUBLE_COLUMN_PRIMARY1_"
                    + (index + 1) + "_NULLABLE (");
            System.out.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index]);
            System.out.println(", FIELD_VARCHAR_FIXED VARCHAR(50)");
            System.out.println(", PRIMARY KEY (FIELD_" + fieldName + ")");
            System.out.println(");");
            System.out.println("");
        }
    }

    private static final void generateDoubleColumnPrimary2Nullable() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2nulleȍڂŁA2ڂvC}L[ł\쐬܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            System.out.println("/*2nulleȍڂŁA2ڂvC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            System.out.println("CREATE TABLE TEST_DOUBLE_COLUMN_PRIMARY2_"
                    + (index + 1) + "_NULLABLE (");
            System.out.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index]);
            System.out.println(", FIELD_VARCHAR_FIXED VARCHAR(50)");
            System.out.println(", PRIMARY KEY (FIELD_VARCHAR_FIXED)");
            System.out.println(");");
            System.out.println("");
        }
    }

    private static final void generateDoubleColumnPrimary3Nullable() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2nulleȍڂŁA2ƂvC}L[ł\쐬܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                System.out.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                System.out.println("");
                continue;
            }

            System.out.println("/*2nulleȍڂŁAƂvC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            System.out.println("CREATE TABLE TEST_DOUBLE_COLUMN_PRIMARY3_"
                    + (index + 1) + "_NULLABLE (");
            System.out.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index]);
            System.out.println(", FIELD_VARCHAR_FIXED VARCHAR(50)");
            System.out.println(", PRIMARY KEY (FIELD_" + fieldName
                    + ", FIELD_VARCHAR_FIXED)");
            System.out.println(");");
            System.out.println("");
        }
    }

    private static final void generateDoubleColumnNonPrimaryNullable() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2nulleȍڂŁA2ƂvC}L[łȂ\쐬܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            System.out.println("/*2nulleȍڂŁAƂvC}L[łȂ\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            System.out.println("CREATE TABLE TEST_DOUBLE_COLUMN_NON_PRIMARY_"
                    + (index + 1) + "_NULLABLE (");
            System.out.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index]);
            System.out.println(", FIELD_VARCHAR_FIXED VARCHAR(50)");
            System.out.println(");");
            System.out.println("");
        }
    }

    // ͍폜GAłB
    // 폜pDDL𐶐܂B

    private static final void generateDeleteDoubleColumnPrimary1() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2̍ڂŁA1ڂ̃vC}L[ɂ\폜܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                System.out.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                System.out.println("");
                continue;
            }

            System.out.println("DROP TABLE TEST_DOUBLE_COLUMN_PRIMARY1_"
                    + (index + 1) + ";");
        }
    }

    private static final void generateDeleteDoubleColumnPrimary2() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2̍ڂŁA2ڂ̃vC}L[ɂ\폜܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            System.out.println("DROP TABLE TEST_DOUBLE_COLUMN_PRIMARY2_"
                    + (index + 1) + ";");
        }
    }

    private static final void generateDeleteDoubleColumnPrimary3() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2̍ڂŁA2ƂvC}L[ł\폜܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                System.out.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                System.out.println("");
                continue;
            }

            System.out.println("DROP TABLE TEST_DOUBLE_COLUMN_PRIMARY3_"
                    + (index + 1) + ";");
        }
    }

    private static final void generateDeleteDoubleColumnNonPrimary() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2̍ڂŁA2ƂvC}L[łȂ\폜܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            System.out.println("DROP TABLE TEST_DOUBLE_COLUMN_NON_PRIMARY_"
                    + (index + 1) + ";");
        }
    }

    private static final void generateDeleteDoubleColumnPrimary1Nullable() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2nulleȍڂŁA1ڂvC}L[ł\폜܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                System.out.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                System.out.println("");
                continue;
            }

            System.out.println("DROP TABLE TEST_DOUBLE_COLUMN_PRIMARY1_"
                    + (index + 1) + "_NULLABLE;");
        }
    }

    private static final void generateDeleteDoubleColumnPrimary2Nullable() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2nulleȍڂŁA2ڂvC}L[ł\폜܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            System.out.println("DROP TABLE TEST_DOUBLE_COLUMN_PRIMARY2_"
                    + (index + 1) + "_NULLABLE;");
        }
    }

    private static final void generateDeleteDoubleColumnPrimary3Nullable() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2nulleȍڂŁA2ƂvC}L[ł\폜܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                System.out.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                System.out.println("");
                continue;
            }

            System.out.println("DROP TABLE TEST_DOUBLE_COLUMN_PRIMARY3_"
                    + (index + 1) + "_NULLABLE;");
        }
    }

    private static final void generateDeleteDoubleColumnNonPrimaryNullable() {
        System.out.println("------------------------------------------");
        System.out.println("-- 2nulleȍڂŁA2ƂvC}L[łȂ\폜܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            System.out.println("DROP TABLE TEST_DOUBLE_COLUMN_NON_PRIMARY_"
                    + (index + 1) + "_NULLABLE;");
        }
    }
}
