/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * @author Yasuo Nakanishi
 */
public class ImportList extends Expander {
    private Map _javaPackageList = new TreeMap();

    private Map _javaxPackageList = new TreeMap();

    private Map _otherPackageList = new TreeMap();

    private List _codeList = new ArrayList();

    public ImportList() {
    }

    public void add(Type type) {
        if (type.isPrimitive() || isJavaLangPackage(type)) {
            return;
        }

        if (isJavaPackage(type)) {
            addJavaPackageClass(type);
        } else if (isJavaxPackage(type)) {
            addJavaxPackageClass(type);
        } else {
            addOtherPackageClass(type);
        }
    }

    public void add(List typeList) {
        Iterator i = typeList.iterator();
        while (i.hasNext()) {
            add((Type) i.next());
        }
    }

    private void addJavaPackageClass(Type type) {
        String className = type.getFullName();
        if (!_javaPackageList.containsKey(className)) {
            _javaPackageList.put(className, className);
        }
    }

    private void addJavaxPackageClass(Type type) {
        String className = type.getFullName();
        if (!_javaxPackageList.containsKey(className)) {
            _javaxPackageList.put(className, className);
        }
    }

    private void addOtherPackageClass(Type type) {
        String className = type.getFullName();
        if (!_otherPackageList.containsKey(className)) {
            _otherPackageList.put(className, className);
        }
    }

    private boolean isJavaLangPackage(Type type) {
        return type.getNameSpace().startsWith("java.lang");
    }

    private boolean isJavaPackage(Type type) {
        return type.getNameSpace().startsWith("java.");
    }

    private boolean isJavaxPackage(Type type) {
        return type.getNameSpace().startsWith("javax.");
    }

    private String expandImportType(String type) {
        StringBuffer sb = new StringBuffer();
        sb.append("import ");
        if (type.endsWith("[]")) {
            // pbP[W̏I[ [] ͕svȂ̂ŏ܂B
            type = type.substring(0, type.length() - 2);
        }
        sb.append(type);
        sb.append(";");
        return new String(sb);
    }

    public List expand() {
        expandPackageList(_javaPackageList.values().iterator());

        if (_javaPackageList.size() != 0) {
            _codeList.add("");
        }

        expandPackageList(_javaxPackageList.values().iterator());

        if (_javaxPackageList.size() != 0) {
            _codeList.add("");
        }

        expandPackageList(_otherPackageList.values().iterator());

        return _codeList;
    }

    private void expandPackageList(Iterator iterator) {
        while (iterator.hasNext()) {
            _codeList.add(expandImportType((String) iterator.next()));
        }
    }

    public void clear() {
        _codeList.clear();
        _javaPackageList.clear();
        _javaxPackageList.clear();
        _otherPackageList.clear();
    }
}
