/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker;

import blanco.db.definition.QueryInvoker;
import blanco.db.expander.query.Finalize;
import blanco.db.expander.query.GetQueryMethod;
import blanco.db.expander.query.PrepareStatementMethod;
import blanco.db.expander.query.PrepareStatementMethod2;
import blanco.db.expander.query.QueryConstructor;
import blanco.db.expander.query.field.ConnectionField;
import blanco.db.expander.query.field.LogField;
import blanco.db.expander.query.field.StatementField;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class QueryInvokerClass extends ClassExpander {
    private BlancoDbObjectStorage storage = null;

    private QueryInvoker _invoker = null;

    public QueryInvokerClass(final BlancoDbObjectStorage storage,
            final Type type, final QueryInvoker invoker) {
        super(type);
        _invoker = invoker;
        this.storage = storage;

        getJavaDoc().addLine(type.getName() + "NX (QueryInvoker)B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("s^SQLbsOĊeANZT񋟂܂B<br>");
        if (invoker.isSingle()) {
            getJavaDoc().addLine("VO: L (҂鏈1)<br>");
        }
    }

    protected void expandClassStruct() {
        // ^CpbP[W̕ωɑΉB
        String runtimePackage = storage.getSetting().getRootNameSpace();
        if (storage.getSetting().getRuntimePackage() != null) {
            runtimePackage = storage.getSetting().getRuntimePackage();
        }

        addImport(new Type(runtimePackage
                + ".exception.IntegrityConstraintException"));

        // BlancoDbUtil͏ɃC|[g܂B
        addImport(new Type(runtimePackage + ".util.BlancoDbUtil"));

        addField(new ConnectionField());
        addField(new StatementField("java.sql.PreparedStatement"));

        if (storage.getSetting().isLogging()) {
            addImport(new Type("org.apache.commons.logging.LogFactory"));
            addField(new LogField(getName()));
        }

        addMethod(new QueryConstructor(getType()));
        addMethod(new GetQueryMethod(_invoker.getQuery()));

        addMethod(new PrepareStatementMethod(storage));
        // t.iga
        addMethod(new PrepareStatementMethod2(storage, null));

        // ̓p[^ꍇɂ̂bind܂B
        if (_invoker.getInParameterIterator().hasNext()) {
            addMethod(new SetInvokerInputParameterMethod(storage, _invoker));
        }
        addMethod(new ExecuteUpdateMethod(storage, _invoker));
        if (_invoker.isSingle()) {
            addMethod(new ExecuteSingleUpdateMethod(storage, _invoker));
        }

        addMethod(new CloseMethod(storage));

        addMethod(new Finalize(storage, getName()));
    }
}